/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.markusbordihn.easymobfarm.loot.LootManager;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapturedMob
extends Item {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected static final String ENTITY_COLOR_TAG = "EntityColor";
    protected static final String ENTITY_ID_TAG = "EntityId";
    protected static final String ENTITY_LOOT_TABLE_TAG = "EntityLootTable";
    protected static final String ENTITY_NAME_TAG = "EntityName";
    protected static final String ENTITY_POSSIBLE_LOOT_TAG = "EntityPossibleLoot";
    protected static final String ENTITY_SHEARED = "EntitySheared";
    protected static final String ENTITY_SIZE_TAG = "EntitySize";
    protected static final String ENTITY_SUB_TYPE_TAG = "EntitySubType";
    protected static final String ENTITY_TYPE_TAG = "EntityType";
    protected static final String FALL_DISTANCE_TAG = "FallDistance";
    protected static final String FIRE_TAG = "Fire";
    protected static final String MOTION_TAG = "Motion";
    protected static final String ON_GROUND_TAG = "OnGround";
    private static Gson gson = new Gson();
    protected final Random random = new Random();

    public CapturedMob(Item.Properties properties) {
        super(properties);
    }

    public static boolean hasCapturedMob(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128441_(ENTITY_NAME_TAG);
    }

    public static List<String> getPossibleLoot(ItemStack itemStack) {
        String possibleLootString;
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_POSSIBLE_LOOT_TAG) && !(possibleLootString = compoundTag.m_128461_(ENTITY_POSSIBLE_LOOT_TAG)).isBlank()) {
            return (List)gson.fromJson(possibleLootString, new TypeToken<List<String>>(){}.getType());
        }
        return Lists.newArrayList();
    }

    public static String getCapturedMob(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_NAME_TAG)) {
            return compoundTag.m_128461_(ENTITY_NAME_TAG);
        }
        return "";
    }

    public static String getCapturedMobName(ItemStack itemStack) {
        return CapturedMob.getCapturedMob(itemStack);
    }

    public static Float getCapturedMobHealth(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_("Health")) {
            return Float.valueOf(compoundTag.m_128457_("Health"));
        }
        return Float.valueOf(5.0f);
    }

    public static String getCapturedMobType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            return compoundTag.m_128461_(ENTITY_TYPE_TAG);
        }
        return "";
    }

    public static String getCapturedMobSubType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_SUB_TYPE_TAG)) {
            return compoundTag.m_128461_(ENTITY_SUB_TYPE_TAG);
        }
        return "";
    }

    public static EntityType<?> getCapturedMobEntityType(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_TYPE_TAG)) {
            String entityTypeName = compoundTag.m_128461_(ENTITY_TYPE_TAG);
            ResourceLocation resourceLocation = new ResourceLocation(entityTypeName);
            return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
        }
        return null;
    }

    public static DyeColor getCapturedMobColor(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_COLOR_TAG)) {
            return DyeColor.m_41053_((int)compoundTag.m_128451_(ENTITY_COLOR_TAG));
        }
        return null;
    }

    public static boolean getCapturedMobShearedStatus(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_SHEARED)) {
            return compoundTag.m_128471_(ENTITY_SHEARED);
        }
        return false;
    }

    public static int getCapturedMobSize(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_SIZE_TAG)) {
            return compoundTag.m_128451_(ENTITY_SIZE_TAG);
        }
        return 1;
    }

    public static String getLootTable(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41784_();
        if (compoundTag.m_128441_(ENTITY_LOOT_TABLE_TAG)) {
            return compoundTag.m_128461_(ENTITY_LOOT_TABLE_TAG);
        }
        return "";
    }

    public static ItemStack setCapturedMob(LivingEntity livingEntity, ItemStack itemStack) {
        ResourceLocation lootTable;
        String beeType;
        log.debug("Capturing mob {} ...", (Object)livingEntity.m_7755_());
        CompoundTag entityData = livingEntity.serializeNBT();
        CompoundTag compoundTag = itemStack.m_41784_();
        String name = livingEntity.m_7755_().getString();
        String type = EntityType.m_20613_((EntityType)livingEntity.m_6095_()).toString();
        String subType = "";
        if (entityData.m_128441_(FIRE_TAG) && entityData.m_128448_(FIRE_TAG) > 0) {
            entityData.m_128376_(FIRE_TAG, (short)0);
        }
        if (entityData.m_128441_(FALL_DISTANCE_TAG) && entityData.m_128457_(FALL_DISTANCE_TAG) > 0.0f) {
            entityData.m_128350_(FALL_DISTANCE_TAG, 0.0f);
        }
        if (entityData.m_128441_(MOTION_TAG)) {
            entityData.m_128365_(MOTION_TAG, (Tag)CapturedMob.newDoubleList(0.0, 0.0, 0.0));
        }
        if (entityData.m_128441_(ON_GROUND_TAG) && !entityData.m_128471_(ON_GROUND_TAG)) {
            entityData.m_128379_(ON_GROUND_TAG, true);
        }
        compoundTag.m_128359_(ENTITY_NAME_TAG, name);
        compoundTag.m_128359_(ENTITY_TYPE_TAG, type);
        compoundTag.m_128359_(ENTITY_ID_TAG, livingEntity.m_20078_());
        if ("productivebees:configurable_bee".equals(type) && entityData.m_128441_("type") && (beeType = entityData.m_128461_("type")) != null && !beeType.isEmpty()) {
            subType = beeType;
            compoundTag.m_128359_(ENTITY_SUB_TYPE_TAG, beeType);
        }
        if ((lootTable = livingEntity.m_5743_()) == null || lootTable == BuiltInLootTables.f_78712_) {
            lootTable = livingEntity.m_6095_().m_20677_();
        }
        if (lootTable != null) {
            List<String> possibleLoot = LootManager.getRandomLootDropOverview(lootTable, livingEntity.m_9236_(), type, subType);
            if (possibleLoot != null) {
                compoundTag.m_128359_(ENTITY_POSSIBLE_LOOT_TAG, gson.toJson(possibleLoot));
            }
            compoundTag.m_128359_(ENTITY_LOOT_TABLE_TAG, lootTable.toString());
        }
        if (livingEntity instanceof Sheep) {
            Sheep sheep = (Sheep)livingEntity;
            compoundTag.m_128405_(ENTITY_COLOR_TAG, sheep.m_29874_().m_41060_());
            compoundTag.m_128379_(ENTITY_SHEARED, sheep.m_29875_());
        }
        if (livingEntity instanceof Slime) {
            Slime slime = (Slime)livingEntity;
            compoundTag.m_128405_(ENTITY_SIZE_TAG, slime.m_33632_());
        }
        compoundTag.m_128391_(entityData);
        itemStack.m_41739_(compoundTag);
        livingEntity.m_142467_(Entity.RemovalReason.DISCARDED);
        return itemStack;
    }

    public static boolean releaseCapturedMob(ItemStack itemStack, BlockPos blockPos, Level level) {
        Entity entity = CapturedMob.getCapturedMobEntity(itemStack, level);
        if (entity != null) {
            BlockState blockState = level.m_8055_(blockPos);
            if (!(blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50037_))) {
                blockPos = blockPos.m_7494_();
                blockState = level.m_8055_(blockPos);
            }
            if (blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) || blockState.m_60713_(Blocks.f_50034_) || blockState.m_60713_(Blocks.f_50037_)) {
                entity.m_6034_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
                log.debug("Release captured mob {} with {}", (Object)entity);
                return level.m_7967_(entity);
            }
        }
        return false;
    }

    public static Entity getCapturedMobEntity(ItemStack itemStack, Level level) {
        CompoundTag compoundTag = itemStack.m_41784_();
        EntityType<?> entityType = CapturedMob.getCapturedMobEntityType(itemStack);
        if (entityType == null) {
            return null;
        }
        Entity entity = entityType.m_20615_(level);
        if (entity != null) {
            compoundTag.m_128473_(ENTITY_ID_TAG);
            compoundTag.m_128473_(ENTITY_LOOT_TABLE_TAG);
            compoundTag.m_128473_(ENTITY_NAME_TAG);
            compoundTag.m_128473_(ENTITY_POSSIBLE_LOOT_TAG);
            compoundTag.m_128473_(ENTITY_TYPE_TAG);
            compoundTag.m_128473_(ENTITY_COLOR_TAG);
            compoundTag.m_128473_(ENTITY_SHEARED);
            compoundTag.m_128473_(ENTITY_SIZE_TAG);
            entity.m_20258_(compoundTag);
            int damagedValue = itemStack.m_41773_();
            itemStack.m_41751_(new CompoundTag());
            itemStack.m_41721_(damagedValue);
        }
        return entity;
    }

    public static boolean willItemBreak(ItemStack itemStack, int damage) {
        return itemStack.m_41763_() && itemStack.m_41773_() + damage >= itemStack.m_41776_();
    }

    public static void damageItem(ItemStack itemStack, int damage) {
        int itemStackDamage = itemStack.m_41773_();
        if (itemStackDamage + damage >= itemStack.m_41776_()) {
            itemStack.m_41774_(1);
        } else {
            itemStack.m_41721_(itemStackDamage + damage);
        }
    }

    protected static ListTag newDoubleList(double ... values) {
        ListTag listTag = new ListTag();
        for (double value : values) {
            listTag.add((Object)DoubleTag.m_128500_((double)value));
        }
        return listTag;
    }
}

