/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.MobFarmTemplateItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapturedMobVirtual {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    private static final String CAPTURED_ENTITY_TAG = "CapturedEntity";
    private static final String ENTITY_HOLDER_TAG = "entity_holder";
    private static final String ENTITY_TAG = "entity";
    private static final String ENTITY_TAG_TAG = "EntityTag";
    private static final String ENTITY_TYPE_TAG = "EntityType";
    private static final String ID_TAG = "id";
    private static final String MOD_DATA_TAG = "mob_data";
    private static final String NAME_TAG = "name";
    private static final String SPAWN_DATA_TAG = "SpawnData";
    private static final String TYPE_TAG = "type";
    private static final String CREATE_BLAZE_BURNER = "create:blaze_burner";
    private static final String MOBCATCHER_NET = "mobcatcher:net";
    private static final String MOB_CAPTURING_TOOL = "mobcapturingtool:mob_capturing_tool";
    private static final String MOB_CATCHER_DIAMOND = "mob_catcher:diamond_mob_catcher";
    private static final String MOB_CATCHER_NETHERITE = "mob_catcher:netherite_mob_catcher";
    private static final String MONSTER_BALL = "cyclic:mob_container";
    private static final String QUANTUM_CATCHER = "forbidden_arcanus:quantum_catcher";
    private static final String SPAWN_EGG_CONFIGURABLE_BEE = "productivebees:spawn_egg_configurable_bee";

    protected CapturedMobVirtual() {
    }

    public static boolean isSupported(ItemStack itemStack) {
        String itemName;
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return true;
        }
        if (item instanceof AirItem || item instanceof ExperienceBottleItem || item instanceof BottleItem || item instanceof MobFarmTemplateItem || item instanceof ArmorItem || item instanceof SignItem || item instanceof DyeItem || item instanceof BedItem || item instanceof SwordItem) {
            return false;
        }
        CompoundTag compoundTag = itemStack.m_41777_().m_41784_();
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.MOB_CATCHER_LOADED && (itemName.equals(MOB_CATCHER_DIAMOND) || itemName.equals(MOB_CATCHER_NETHERITE))) {
            if (compoundTag.m_128441_(MOD_DATA_TAG) && compoundTag.m_128469_(MOD_DATA_TAG).m_128441_(ID_TAG)) {
                return !compoundTag.m_128469_(MOD_DATA_TAG).m_128461_(ID_TAG).isEmpty();
            }
        } else {
            if (Constants.CREATE_LOADED && itemName.equals(CREATE_BLAZE_BURNER)) {
                return true;
            }
            if (Constants.MOB_CAPTURING_TOOL_LOADED && itemName.equals(MOB_CAPTURING_TOOL)) {
                if (compoundTag.m_128441_(CAPTURED_ENTITY_TAG) && compoundTag.m_128469_(CAPTURED_ENTITY_TAG).m_128441_(ENTITY_TYPE_TAG)) {
                    return !compoundTag.m_128469_(CAPTURED_ENTITY_TAG).m_128461_(ENTITY_TYPE_TAG).isEmpty();
                }
            } else if (Constants.MOBCATCHER_LOADED && itemName.equals(MOBCATCHER_NET)) {
                if (compoundTag.m_128441_(ENTITY_HOLDER_TAG) && compoundTag.m_128469_(ENTITY_HOLDER_TAG).m_128441_(ID_TAG)) {
                    return !compoundTag.m_128469_(ENTITY_HOLDER_TAG).m_128461_(ID_TAG).isEmpty();
                }
            } else if (Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
                if (compoundTag.m_128441_(BLOCK_ENTITY_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128441_(SPAWN_DATA_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128441_(ENTITY_TAG) && compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128469_(ENTITY_TAG).m_128441_(ID_TAG)) {
                    return !compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128469_(ENTITY_TAG).m_128461_(ID_TAG).isEmpty();
                }
            } else if (Constants.FORBIDDEN_ARCANUS_LOADED && itemName.equals(QUANTUM_CATCHER)) {
                if (compoundTag.m_128441_(ENTITY_TAG) && compoundTag.m_128469_(ENTITY_TAG).m_128441_(ID_TAG)) {
                    return !compoundTag.m_128469_(ENTITY_TAG).m_128461_(ID_TAG).isEmpty();
                }
            } else {
                if (Constants.CYCLIC_LOADED && itemName.equals(MONSTER_BALL)) {
                    return !compoundTag.m_128461_(ID_TAG).isEmpty();
                }
                if (Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
                    if (compoundTag.m_128441_(ENTITY_TAG_TAG) && compoundTag.m_128469_(ENTITY_TAG_TAG).m_128441_(TYPE_TAG)) {
                        return !compoundTag.m_128469_(ENTITY_TAG_TAG).m_128461_(TYPE_TAG).isEmpty();
                    }
                } else if (item instanceof SpawnEggItem) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasCapturedMob(ItemStack itemStack) {
        String itemName;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.hasCapturedMob(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.MOB_CATCHER_LOADED && (itemName.equals(MOB_CATCHER_DIAMOND) || itemName.equals(MOB_CATCHER_NETHERITE))) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.CREATE_LOADED && itemName.equals(CREATE_BLAZE_BURNER)) {
            return true;
        }
        if (Constants.MOB_CAPTURING_TOOL_LOADED && itemName.equals(MOB_CAPTURING_TOOL)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.MOBCATCHER_LOADED && itemName.equals(MOBCATCHER_NET)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.FORBIDDEN_ARCANUS_LOADED && itemName.equals(QUANTUM_CATCHER)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.CYCLIC_LOADED && itemName.equals(MONSTER_BALL)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        if (Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
            return !CapturedMobVirtual.getCapturedMobType(itemStack).isBlank() && !CapturedMobVirtual.getCapturedMobType(itemStack).isEmpty();
        }
        return item instanceof SpawnEggItem;
    }

    public static String getCapturedMob(ItemStack itemStack) {
        String itemName;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMob(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.MOB_CATCHER_LOADED && (itemName.equals(MOB_CATCHER_DIAMOND) || itemName.equals(MOB_CATCHER_NETHERITE))) {
            CompoundTag compoundTag = itemStack.m_41784_();
            return compoundTag.m_128461_(NAME_TAG);
        }
        if (Constants.CREATE_LOADED && itemName.equals(CREATE_BLAZE_BURNER)) {
            return "Blaze";
        }
        if (Constants.MOB_CAPTURING_TOOL_LOADED && itemName.equals(MOB_CAPTURING_TOOL) || Constants.MOBCATCHER_LOADED && itemName.equals(MOBCATCHER_NET) || item instanceof SpawnEggItem || Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_) || Constants.FORBIDDEN_ARCANUS_LOADED && itemName.equals(QUANTUM_CATCHER) || Constants.CYCLIC_LOADED && itemName.equals(MONSTER_BALL) || Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
            EntityType<?> entityType = CapturedMobVirtual.getCapturedMobEntityType(itemStack);
            String descriptionId = entityType != null ? entityType.m_20675_() : "";
            return !descriptionId.isBlank() ? Component.m_237115_((String)descriptionId).getString() : descriptionId;
        }
        return "";
    }

    public static String getCapturedMobName(ItemStack itemStack) {
        CompoundTag compoundTag;
        String beeType;
        String itemName;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMob(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE) && (beeType = (compoundTag = itemStack.m_41784_()).m_128469_(ENTITY_TAG_TAG).m_128461_(TYPE_TAG)) != null && beeType.contains(":")) {
            String beeTypeName = "entity.productivebees." + beeType.split(":")[1] + "_bee";
            return Component.m_237115_((String)beeTypeName).getString();
        }
        return CapturedMobVirtual.getCapturedMob(itemStack);
    }

    public static EntityType<?> getCapturedMobEntityType(ItemStack itemStack) {
        String itemName;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobEntityType(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.MOB_CATCHER_LOADED && (itemName.equals(MOB_CATCHER_DIAMOND) || itemName.equals(MOB_CATCHER_NETHERITE)) || Constants.MOB_CAPTURING_TOOL_LOADED && itemName.equals(MOB_CAPTURING_TOOL) || Constants.MOBCATCHER_LOADED && itemName.equals(MOBCATCHER_NET) || Constants.CREATE_LOADED && itemName.equals(CREATE_BLAZE_BURNER) || Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_) || Constants.FORBIDDEN_ARCANUS_LOADED && itemName.equals(QUANTUM_CATCHER) || Constants.CYCLIC_LOADED && itemName.equals(MONSTER_BALL) || Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
            String capturedMobType = CapturedMobVirtual.getCapturedMobType(itemStack);
            if (capturedMobType.contains(":")) {
                ResourceLocation resourceLocation = new ResourceLocation(capturedMobType);
                return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
            }
            log.warn("Unable to get capture mob entity type for {}", (Object)capturedMobType);
        } else if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            return spawnEggItem.m_43228_(itemStack.m_41784_());
        }
        return null;
    }

    public static String getCapturedMobType(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobType(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        CompoundTag compoundTag = itemStack.m_41784_();
        if (Constants.MOB_CATCHER_LOADED && (itemName.equals(MOB_CATCHER_DIAMOND) || itemName.equals(MOB_CATCHER_NETHERITE))) {
            return compoundTag.m_128469_(MOD_DATA_TAG).m_128461_(ID_TAG);
        }
        if (Constants.CREATE_LOADED && itemName.equals(CREATE_BLAZE_BURNER)) {
            return "minecraft:blaze";
        }
        if (Constants.MOB_CAPTURING_TOOL_LOADED && itemName.equals(MOB_CAPTURING_TOOL)) {
            return compoundTag.m_128469_(CAPTURED_ENTITY_TAG).m_128461_(ENTITY_TYPE_TAG);
        }
        if (Constants.MOBCATCHER_LOADED && itemName.equals(MOBCATCHER_NET)) {
            return compoundTag.m_128469_(ENTITY_HOLDER_TAG).m_128461_(ID_TAG);
        }
        if (Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_)) {
            return compoundTag.m_128469_(BLOCK_ENTITY_TAG).m_128469_(SPAWN_DATA_TAG).m_128469_(ENTITY_TAG).m_128461_(ID_TAG);
        }
        if (Constants.FORBIDDEN_ARCANUS_LOADED && itemName.equals(QUANTUM_CATCHER)) {
            return compoundTag.m_128469_(ENTITY_TAG).m_128461_(ID_TAG);
        }
        if (Constants.CYCLIC_LOADED && itemName.equals(MONSTER_BALL)) {
            return compoundTag.m_128461_(ID_TAG);
        }
        if (Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
            return "productivebees:configurable_bee";
        }
        if (item instanceof SpawnEggItem) {
            String[] descriptionIdParts;
            String descriptionId;
            EntityType<?> entityType = CapturedMobVirtual.getCapturedMobEntityType(itemStack);
            String string = descriptionId = entityType != null ? entityType.m_20675_() : "";
            if (descriptionId != null && descriptionId.contains("entity.") && (descriptionIdParts = descriptionId.split("\\.")).length == 3) {
                return descriptionIdParts[1] + ":" + descriptionIdParts[2];
            }
        }
        return "";
    }

    public static String getCapturedMobSubType(ItemStack itemStack) {
        String itemName;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobSubType(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
            CompoundTag compoundTag = itemStack.m_41784_();
            return compoundTag.m_128469_(ENTITY_TAG_TAG).m_128461_(TYPE_TAG);
        }
        return "";
    }

    public static String getLootTable(ItemStack itemStack) {
        String itemName;
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return "";
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getLootTable(itemStack);
        }
        ResourceLocation itemRegistryName = ForgeRegistries.ITEMS.getKey((Object)item);
        String string = itemName = itemRegistryName != ForgeRegistries.ITEMS.getDefaultKey() ? itemRegistryName.toString() : "";
        if (Constants.MOB_CATCHER_LOADED && (itemName.equals(MOB_CATCHER_DIAMOND) || itemName.equals(MOB_CATCHER_NETHERITE)) || Constants.CREATE_LOADED && itemName.equals(CREATE_BLAZE_BURNER) || Constants.MOB_CAPTURING_TOOL_LOADED && itemName.equals(MOB_CAPTURING_TOOL) || Constants.MOBCATCHER_LOADED && itemName.equals(MOBCATCHER_NET) || item instanceof SpawnEggItem || Constants.CORAIL_SPAWNERS_LOADED && item.equals(Items.f_42007_) || Constants.FORBIDDEN_ARCANUS_LOADED && itemName.equals(QUANTUM_CATCHER) || Constants.CYCLIC_LOADED && itemName.equals(MONSTER_BALL)) {
            String capturedMobType = CapturedMobVirtual.getCapturedMobType(itemStack);
            if (capturedMobType != null && capturedMobType.contains(":")) {
                String[] mobTypeParts = capturedMobType.split("\\:");
                return mobTypeParts[0] + ":entities/" + mobTypeParts[1];
            }
        } else if (Constants.PRODUCTIVE_BEES_LOADED && itemName.equals(SPAWN_EGG_CONFIGURABLE_BEE)) {
            String string2 = CapturedMobVirtual.getCapturedMobType(itemStack);
        } else {
            log.warn("Unable to get loot table for {}", (Object)itemStack);
        }
        return "";
    }

    public static DyeColor getCapturedMobColor(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return null;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobColor(itemStack);
        }
        return null;
    }

    public static boolean getCapturedMobShearedStatus(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return false;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobShearedStatus(itemStack);
        }
        return false;
    }

    public static int getCapturedMobSize(ItemStack itemStack) {
        if (!CapturedMobVirtual.isSupported(itemStack)) {
            return 1;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof CapturedMob) {
            return CapturedMob.getCapturedMobSize(itemStack);
        }
        return 1;
    }
}

