/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcatcher;

import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.item.MobCatcherItem;
import de.markusbordihn.easymobfarm.text.TranslatableText;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;

public class InsectNet
extends MobCatcherItem {
    public static final String NAME = "Insect Net";

    public InsectNet(Item.Properties properties) {
        super(properties);
    }

    @Override
    public int getMobCatchingLuckConfig() {
        return (Integer)InsectNet.COMMON.insectNetMobCatchingLuck.get();
    }

    @Override
    public String getMobCatcherItemName() {
        return NAME;
    }

    @Override
    public void appendHoverTextCatchableMobs(List<Component> tooltipList) {
        Set<String> acceptedMobTypes = this.getAcceptedMobTypes();
        if (!acceptedMobTypes.isEmpty()) {
            MutableComponent mobTypeOverview = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GREEN);
            for (String acceptedMob : acceptedMobTypes) {
                Component acceptedMobName;
                if (!Constants.PRODUCTIVE_BEES_LOADED && acceptedMob.startsWith("productivebees:") || acceptedMobTypes.size() >= 16 && Constants.PRODUCTIVE_BEES_LOADED && acceptedMob.startsWith("productivebees:") || (acceptedMobName = TranslatableText.getEntityName(acceptedMob)).getString().isBlank()) continue;
                mobTypeOverview.m_7220_(acceptedMobName).m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (Constants.PRODUCTIVE_BEES_LOADED && acceptedMobTypes.size() >= 16) {
                mobTypeOverview.m_130946_("Productive Bees").m_130946_(", ").m_130940_(ChatFormatting.DARK_GREEN);
            }
            if (!mobTypeOverview.getString().isBlank()) {
                MutableComponent acceptedMobsOverview = Component.m_237115_((String)"text.easy_mob_farm.catchable_mobs").m_130946_(" ").m_130940_(ChatFormatting.GREEN);
                acceptedMobsOverview.m_7220_((Component)mobTypeOverview).m_130946_("...");
                tooltipList.add((Component)acceptedMobsOverview);
            }
        }
        if (this.getMobCatchingLuckConfig() > 0) {
            MutableComponent catchingLuck = Component.m_237110_((String)"text.easy_mob_farm.mob_catching_luck", (Object[])new Object[]{this.getMobCatchingLuckConfig()});
            tooltipList.add((Component)catchingLuck);
        }
    }
}

