/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.loot.LootManagerDrops;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
public class LootManager {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Random random = new Random();
    private static final GameProfile GAME_PROFILE = new GameProfile(UUID.randomUUID(), "[BOs_Easy_Mob_Farm]");
    private static final String PRODUCTIVE_BEES_CONFIGURABLE_HONEYCOMB = "productivebees:configurable_honeycomb";
    private static final String PRODUCTIVE_BEES_HONEYCOMB_GHOSTLY = "productivebees:honeycomb_ghostly";
    private static final String PRODUCTIVE_BEES_HONEYCOMB_MILKY = "productivebees:honeycomb_milky";
    private static final String PRODUCTIVE_BEES_HONEYCOMB_POWDERY = "productivebees:honeycomb_powdery";
    private static FakePlayer fakePlayer;
    private static Map<ResourceLocation, List<String>> lootTableDropListCache;

    protected LootManager() {
    }

    @SubscribeEvent
    public static void handleServerAboutToStartEvent(ServerAboutToStartEvent event) {
        lootTableDropListCache = new ConcurrentHashMap<ResourceLocation, List<String>>();
    }

    public static List<String> getRandomLootDropOverview(ResourceLocation lootTableLocation, Level level, String mobType, String mobSubType) {
        List<Object> lootDropList = Lists.newArrayList();
        for (int i = 0; i < (Integer)LootManager.COMMON.lootPreviewRolls.get(); ++i) {
            List<ItemStack> lootDrops = LootManager.getFilteredRandomLootDrop(lootTableLocation, ItemStack.f_41583_, level, mobType, mobSubType);
            lootDropList = LootManager.cacheLootDrops(lootTableLocation, lootDrops);
        }
        log.debug("[Loot Manager] Loot for {} with {} roll {} result: {}", (Object)mobType, (Object)lootTableLocation, LootManager.COMMON.lootPreviewRolls.get(), (Object)lootDropList);
        return lootDropList;
    }

    public static List<ItemStack> getRandomLootDrops(ResourceLocation lootTableLocation, ItemStack weaponItem, Level level, String mobType, String mobSubType) {
        if (lootTableLocation == null || level == null || level.m_7654_() == null) {
            log.error("[Loot Manager] Unable to get loot drops for {} and {}", (Object)lootTableLocation, (Object)level);
            return Lists.newArrayList();
        }
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            ServerLevel serverLevel = (ServerLevel)level;
            FakePlayer player = LootManager.getPlayer(serverLevel);
            DamageSource damageSource = serverLevel.m_269111_().m_269075_((Player)player);
            LootParams.Builder lootBuilder = null;
            if (weaponItem != null && !weaponItem.m_41619_()) {
                float dropLuck = 0.7f;
                if (weaponItem.getEnchantmentLevel(Enchantments.f_44982_) > 0) {
                    dropLuck += (float)weaponItem.getEnchantmentLevel(Enchantments.f_44982_) * 0.3f;
                } else if (weaponItem.getEnchantmentLevel(Enchantments.f_44953_) > 0) {
                    dropLuck += (float)weaponItem.getEnchantmentLevel(Enchantments.f_44953_) * 0.3f;
                }
                lootBuilder = new LootParams.Builder(serverLevel).m_287239_(dropLuck).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287286_(LootContextParams.f_81459_, (Object)player).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81456_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81463_, (Object)weaponItem);
            } else {
                lootBuilder = new LootParams.Builder(serverLevel).m_287239_(0.5f).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)player);
            }
            LootTable lootTable = server.m_278653_().m_278676_(lootTableLocation);
            ObjectArrayList lootDrops = lootTable.m_287195_(lootBuilder.m_287235_(LootContextParamSets.f_81415_));
            if (weaponItem != null && !weaponItem.m_41619_() && weaponItem.getEnchantmentLevel(Enchantments.f_44982_) > 0) {
                for (int i = 0; i < weaponItem.getEnchantmentLevel(Enchantments.f_44982_); ++i) {
                    lootDrops.addAll(lootTable.m_287195_(lootBuilder.m_287235_(LootContextParamSets.f_81415_)));
                }
            }
            if (!(!lootDrops.isEmpty() || lootTableLocation.equals((Object)new ResourceLocation("minecraft:empty")) || lootTableLocation.equals((Object)new ResourceLocation("minecraft:entities/bee")) || lootTableLocation.equals((Object)new ResourceLocation("minecraft:entities/blaze")) || "productivebees".equals(lootTableLocation.m_135827_()) || "alexsmobs".equals(lootTableLocation.m_135827_()))) {
                log.debug("[Loot Manager] Loot drop for {} with loot table {} was empty!", (Object)player, (Object)lootTableLocation);
            }
            if (lootDrops.isEmpty() && Constants.PRODUCTIVE_BEES_LOADED && "productivebees:entities/configurable_bee".equals(lootTableLocation.toString()) && random.nextInt(3) == 0) {
                Item honeyCombGhostly = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(PRODUCTIVE_BEES_HONEYCOMB_GHOSTLY));
                Item honeyCombMilky = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(PRODUCTIVE_BEES_HONEYCOMB_MILKY));
                Item honeyCombPowdery = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(PRODUCTIVE_BEES_HONEYCOMB_POWDERY));
                Item configurableHoneycomb = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(PRODUCTIVE_BEES_CONFIGURABLE_HONEYCOMB));
                if (mobType.equals("productivebees:ghostly_bee") && honeyCombGhostly != null) {
                    lootDrops.add(new ItemStack((ItemLike)honeyCombGhostly));
                } else if (mobType.equals("productivebees:rancher_bee") && honeyCombMilky != null) {
                    lootDrops.add(new ItemStack((ItemLike)honeyCombMilky));
                } else if (mobType.equals("productivebees:creeper_bee") && honeyCombPowdery != null) {
                    lootDrops.add(new ItemStack((ItemLike)honeyCombPowdery));
                } else if (mobSubType != null && !mobSubType.isEmpty() && configurableHoneycomb != null) {
                    ItemStack honeyComb = new ItemStack((ItemLike)configurableHoneycomb);
                    CompoundTag compoundTag = honeyComb.m_41698_("EntityTag");
                    compoundTag.m_128359_("type", mobSubType);
                    lootDrops.add(honeyComb);
                }
            }
            return lootDrops;
        }
        return Lists.newArrayList();
    }

    public static List<ItemStack> getFilteredRandomLootDrop(ItemStack capturedMob, ItemStack weaponItem, Level level) {
        ResourceLocation lootTable = LootManager.getLootTable(capturedMob, level);
        if (lootTable == null) {
            return Lists.newArrayList();
        }
        String mobType = "";
        String mobSubType = "";
        if (capturedMob.m_41720_() instanceof CapturedMob) {
            mobType = CapturedMob.getCapturedMobType(capturedMob);
            mobSubType = CapturedMob.getCapturedMobSubType(capturedMob);
        } else if (CapturedMobVirtual.isSupported(capturedMob)) {
            mobType = CapturedMobVirtual.getCapturedMobType(capturedMob);
            mobSubType = CapturedMobVirtual.getCapturedMobSubType(capturedMob);
        }
        return LootManager.getFilteredRandomLootDrop(lootTable, weaponItem, level, mobType, mobSubType);
    }

    public static List<ItemStack> getFilteredRandomLootDrop(ResourceLocation lootTableLocation, ItemStack weaponItem, Level level, String mobType, String mobSubType) {
        List<ItemStack> lootDrops = LootManager.getRandomLootDrops(lootTableLocation, weaponItem, level, mobType, mobSubType);
        List<ItemStack> filteredLootDrops = LootManager.filterLootDrop(lootDrops, mobType);
        LootManager.cacheLootDrops(lootTableLocation, filteredLootDrops);
        return filteredLootDrops;
    }

    public static List<ItemStack> filterLootDrop(List<ItemStack> lootDrops, String mobType) {
        ArrayList filteredLootDrops = Lists.newArrayList();
        LootManagerDrops.processForcedDrops(filteredLootDrops, mobType);
        for (ItemStack lootDrop : lootDrops) {
            if (lootDrop.m_41619_() || LootManager.filter((Boolean)LootManager.COMMON.disableChickenDropRawChicken.get(), "minecraft:chicken", Items.f_42581_, mobType, lootDrop) || LootManager.filter((Boolean)LootManager.COMMON.disableCowDropRawBeef.get(), "minecraft:cow", Items.f_42579_, mobType, lootDrop) || LootManager.filter((Boolean)LootManager.COMMON.disableSheepDropRawMutton.get(), "minecraft:sheep", Items.f_42658_, mobType, lootDrop) || LootManager.filter((Boolean)LootManager.COMMON.disableIronGolemDropPoppy.get(), "minecraft:iron_golem", Items.f_41940_, mobType, lootDrop)) continue;
            filteredLootDrops.add(lootDrop);
        }
        return filteredLootDrops;
    }

    private static FakePlayer getPlayer(ServerLevel level) {
        if (fakePlayer == null) {
            fakePlayer = new FakePlayer(level, GAME_PROFILE);
        }
        return fakePlayer;
    }

    private static ResourceLocation getLootTable(ItemStack itemStack, Level level) {
        if (itemStack.m_41619_() || !(level instanceof ServerLevel)) {
            return null;
        }
        if (itemStack.m_41720_() instanceof CapturedMob) {
            String lootTableLocation = CapturedMob.getLootTable(itemStack);
            if (!lootTableLocation.isEmpty()) {
                return new ResourceLocation(lootTableLocation);
            }
        } else if (CapturedMobVirtual.isSupported(itemStack)) {
            String lootTableLocation = CapturedMobVirtual.getLootTable(itemStack);
            if (!lootTableLocation.isEmpty()) {
                return new ResourceLocation(lootTableLocation);
            }
        } else {
            log.error("[Loot Manager] Unable to get loot table for {} in {}", (Object)itemStack, (Object)level);
        }
        return null;
    }

    private static final boolean filter(boolean status, String blockedMobType, Item blockedLootDrop, String mobType, ItemStack lootDrop) {
        if (!status) {
            return false;
        }
        return mobType.equals(blockedMobType) && lootDrop.m_150930_(blockedLootDrop);
    }

    private static List<String> cacheLootDrops(ResourceLocation lootTableLocation, List<ItemStack> lootDrops) {
        ArrayList lootDropList = Lists.newArrayList();
        if (lootTableLocation == null) {
            return lootDropList;
        }
        List lootDropListCache = lootTableDropListCache.getOrDefault(lootTableLocation, null);
        if (lootDropListCache != null) {
            lootDropList.addAll(lootDropListCache);
        }
        for (ItemStack lootDrop : lootDrops) {
            CompoundTag compoundTag;
            String combType;
            Object itemDescriptionId = lootDrop.m_41720_().m_5524_();
            if (itemDescriptionId == null || ((String)itemDescriptionId).isEmpty()) continue;
            if ("item.productivebees.configurable_honeycomb".equals(itemDescriptionId) && (combType = (compoundTag = lootDrop.m_41698_("EntityTag")).m_128461_("type")) != null && !combType.isEmpty() && combType.contains(":")) {
                itemDescriptionId = "item.productivebees.honeycomb_" + combType.split(":")[1];
            }
            lootDropList.add(itemDescriptionId);
        }
        List<String> sortedLootDropList = lootDropList.stream().distinct().sorted().toList();
        lootTableDropListCache.put(lootTableLocation, sortedLootDropList);
        return sortedLootDropList;
    }

    static {
        lootTableDropListCache = new ConcurrentHashMap<ResourceLocation, List<String>>();
    }
}

