/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.loot;

import de.markusbordihn.easymobfarm.Constants;
import de.markusbordihn.easymobfarm.config.CommonConfig;
import de.markusbordihn.easymobfarm.config.mobs.BeeAnimal;
import de.markusbordihn.easymobfarm.loot.RandomLootItems;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class LootManagerDrops {
    private static final CommonConfig.Config COMMON = CommonConfig.COMMON;
    private static final Random random = new Random();

    protected LootManagerDrops() {
    }

    public static final void processForcedDrops(List<ItemStack> lootDrops, String mobType) {
        if (mobType == null || mobType.isEmpty()) {
            return;
        }
        if (mobType.equals("minecraft:bee") && (Integer)LootManagerDrops.COMMON.forceBeeDropHoneycombChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceBeeDropHoneycombChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42784_));
        } else if (Constants.PRODUCTIVE_BEES_LOADED && BeeAnimal.ProductiveBees.contains(mobType) && (Integer)LootManagerDrops.COMMON.forceBeeDropHoneycombChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceBeeDropHoneycombChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42784_));
        } else if (mobType.equals("minecraft:blaze") && (Integer)LootManagerDrops.COMMON.forceBlazeDropBlazeRodChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceBlazeDropBlazeRodChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42585_));
        } else if (mobType.equals("minecraft:chicken") && (Integer)LootManagerDrops.COMMON.forceChickenDropEggChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceChickenDropEggChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42521_));
        } else if (mobType.equals("minecraft:drowned")) {
            if ((Integer)LootManagerDrops.COMMON.forceDrownedDropArmorChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceDrownedDropArmorChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomLeatherArmor());
            }
            if ((Integer)LootManagerDrops.COMMON.forceDrownedDropCopperIngotChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceDrownedDropCopperIngotChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_151052_));
            }
            if ((Integer)LootManagerDrops.COMMON.forceDrownedDropTridentChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceDrownedDropTridentChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42713_));
            }
            if ((Integer)LootManagerDrops.COMMON.forceDrownedDropNautilusShellChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceDrownedDropNautilusShellChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42715_));
            }
        } else if (mobType.equals("minecraft:enderman") && (Integer)LootManagerDrops.COMMON.forceEndermanDropEnderPearlChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceEndermanDropEnderPearlChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42584_));
        } else if (mobType.equals("minecraft:slime") && (Integer)LootManagerDrops.COMMON.forceSlimeDropSlimeBallChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceSlimeDropSlimeBallChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42518_));
        } else if (mobType.equals("minecraft:magma_cube") && (Integer)LootManagerDrops.COMMON.forceMagmaCubeDropMagmaCreamChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceMagmaCubeDropMagmaCreamChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42542_));
        } else if (mobType.equals("minecraft:piglin")) {
            if ((Integer)LootManagerDrops.COMMON.forcePiglinDropArmorChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forcePiglinDropArmorChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomGoldenArmor());
            }
            if ((Integer)LootManagerDrops.COMMON.forcePiglinDropWeaponChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forcePiglinDropWeaponChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomGoldenWeapon());
            }
        } else if (mobType.equals("minecraft:pillager")) {
            if ((Integer)LootManagerDrops.COMMON.forcePillagerDropArmorChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forcePillagerDropArmorChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomIronArmor());
            }
            if ((Integer)LootManagerDrops.COMMON.forcePillagerDropEmeraldChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forcePillagerDropEmeraldChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42616_));
            }
            if ((Integer)LootManagerDrops.COMMON.forcePillagerDropEnchantedBookChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forcePillagerDropEnchantedBookChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42690_));
            }
            if ((Integer)LootManagerDrops.COMMON.forcePillagerDropWeaponChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forcePillagerDropWeaponChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomIronTool());
            }
        } else if (mobType.equals("minecraft:wither") && (Integer)LootManagerDrops.COMMON.forceWitherDropNetherStarChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceWitherDropNetherStarChance.get()) == 0) {
            lootDrops.add(new ItemStack((ItemLike)Items.f_42686_));
        } else if (mobType.equals("minecraft:zombie")) {
            if ((Integer)LootManagerDrops.COMMON.forceZombieDropArmorChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceZombieDropArmorChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomArmor());
            }
            if ((Integer)LootManagerDrops.COMMON.forceZombieDropWeaponChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceZombieDropWeaponChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomWeapon());
            }
        } else if (mobType.equals("minecraft:zombified_piglin")) {
            if ((Integer)LootManagerDrops.COMMON.forceZombifiedPiglinDropGoldIngotChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceZombifiedPiglinDropGoldIngotChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42417_));
            }
            if ((Integer)LootManagerDrops.COMMON.forceZombifiedPiglinDropGoldNuggetChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceZombifiedPiglinDropGoldNuggetChance.get()) == 0) {
                lootDrops.add(new ItemStack((ItemLike)Items.f_42587_));
            }
            if ((Integer)LootManagerDrops.COMMON.forceZombifiedPiglinDropWeaponChance.get() > 0 && random.nextInt((Integer)LootManagerDrops.COMMON.forceZombifiedPiglinDropWeaponChance.get()) == 0) {
                lootDrops.add(RandomLootItems.getRandomGoldenWeapon());
            }
        }
    }
}

