/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.menu;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.config.MobTypeManager;
import de.markusbordihn.easymobfarm.data.RedstoneMode;
import de.markusbordihn.easymobfarm.item.CapturedMob;
import de.markusbordihn.easymobfarm.item.CapturedMobVirtual;
import de.markusbordihn.easymobfarm.menu.ModMenuTypes;
import de.markusbordihn.easymobfarm.menu.slots.CapturedMobSlot;
import de.markusbordihn.easymobfarm.menu.slots.ExperienceSlot;
import de.markusbordihn.easymobfarm.menu.slots.LockedResultSlot;
import de.markusbordihn.easymobfarm.menu.slots.WeaponSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobFarmMenu
extends AbstractContainerMenu {
    public static final int CAPTURED_MOB_SLOT = 0;
    public static final int RESULT_1_SLOT = 1;
    public static final int RESULT_2_SLOT = 2;
    public static final int RESULT_3_SLOT = 3;
    public static final int RESULT_4_SLOT = 4;
    public static final int RESULT_5_SLOT = 5;
    public static final int WEAPON_SLOT = 6;
    public static final int EXPERIENCE_SLOT = 7;
    public static final int PLAYER_SLOT_START = 9;
    public static final int PLAYER_INVENTORY_SLOT_START = 9;
    public static final int PLAYER_SLOT_STOP = 44;
    public static final int CAPTURED_MOB_SLOT_LEFT = 81;
    public static final int CAPTURED_MOB_SLOT_TOP = 51;
    public static final int RESULT_SLOTS_LEFT = 44;
    public static final int RESULT_SLOTS_TOP = 100;
    public static final int WEAPON_SLOT_LEFT = 131;
    public static final int WEAPON_SLOT_TOP = 51;
    public static final int EXPERIENCE_SLOT_LEFT = 152;
    public static final int EXPERIENCE_SLOT_TOP = 100;
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected static int containerSize = 8;
    private static int slotSize = 18;
    private static int slotSpacing = 8;
    private final Container container;
    private final ContainerData data;
    private BlockPos mobFarmBlockPos;
    private ItemStack mobFarmCapturedMob = ItemStack.f_41583_;
    private ItemStack mobFarmExperienceItem = ItemStack.f_41583_;
    private ItemStack mobFarmWeaponItem = ItemStack.f_41583_;
    private Level level;
    private RedstoneMode mobFarmRedstoneMode;
    private String mobFarmName = "- unknown -";
    private String mobFarmSubType = "";
    private String mobFarmTotalTimeText = "";
    private String mobFarmType = "";
    private boolean mobFarmPowered = false;
    private int mobFarmProgress;
    private int mobFarmProgressImage;
    private int mobFarmRemainingTime;
    private int mobFarmStatus;
    private int mobFarmTotalTime;

    public MobFarmMenu(int windowIdIn, Inventory inventory) {
        this(windowIdIn, inventory, (Container)new SimpleContainer(containerSize), (ContainerData)new SimpleContainerData(10), (MenuType)ModMenuTypes.MOB_FARM_MENU.get());
    }

    public MobFarmMenu(int windowId, Inventory playerInventory, Container container, ContainerData containerData) {
        this(windowId, playerInventory, container, containerData, (MenuType)ModMenuTypes.MOB_FARM_MENU.get());
    }

    public MobFarmMenu(int windowId, Inventory playerInventory, Container container, ContainerData containerData, MenuType<?> menuType) {
        super(menuType, windowId);
        this.level = playerInventory.f_35978_.m_9236_();
        MobFarmMenu.m_38869_((Container)container, (int)containerSize);
        MobFarmMenu.m_38886_((ContainerData)containerData, (int)10);
        this.container = container;
        this.data = containerData;
        this.m_38897_(new CapturedMobSlot(container, 0, 81, 51, this));
        this.m_38897_(new LockedResultSlot(container, 1, 44, 100));
        this.m_38897_(new LockedResultSlot(container, 2, 62, 100));
        this.m_38897_(new LockedResultSlot(container, 3, 80, 100));
        this.m_38897_(new LockedResultSlot(container, 4, 98, 100));
        this.m_38897_(new LockedResultSlot(container, 5, 116, 100));
        this.m_38897_(new WeaponSlot(container, 6, 131, 51));
        this.m_38897_(new ExperienceSlot(container, 7, 152, 100));
        int playerInventoryStartPositionY = 140;
        for (int inventoryRow = 0; inventoryRow < 3; ++inventoryRow) {
            for (int inventoryColumn = 0; inventoryColumn < 9; ++inventoryColumn) {
                this.m_38897_(new Slot((Container)playerInventory, inventoryColumn + inventoryRow * 9 + 9, slotSpacing + inventoryColumn * slotSize, playerInventoryStartPositionY + inventoryRow * slotSize));
            }
        }
        int hotbarStartPositionY = 198;
        for (int playerInventorySlot = 0; playerInventorySlot < 9; ++playerInventorySlot) {
            this.m_38897_(new Slot((Container)playerInventory, playerInventorySlot, slotSpacing + playerInventorySlot * slotSize, hotbarStartPositionY));
        }
        this.m_38884_(containerData);
    }

    public void updateMobFarmDataCache() {
        ItemStack currentItemStack = this.container.m_8020_(0);
        if (!this.mobFarmCapturedMob.m_150930_(currentItemStack.m_41720_())) {
            if (currentItemStack.m_41619_()) {
                this.mobFarmName = "- unknown -";
                this.mobFarmType = "";
                this.mobFarmSubType = "";
            } else if (currentItemStack.m_41720_() instanceof CapturedMob) {
                this.mobFarmName = CapturedMob.getCapturedMobName(currentItemStack);
                this.mobFarmType = CapturedMob.getCapturedMobType(currentItemStack);
                this.mobFarmSubType = CapturedMob.getCapturedMobSubType(currentItemStack);
            } else if (CapturedMobVirtual.isSupported(currentItemStack)) {
                this.mobFarmName = CapturedMobVirtual.getCapturedMobName(currentItemStack);
                this.mobFarmType = CapturedMobVirtual.getCapturedMobType(currentItemStack);
                this.mobFarmSubType = CapturedMobVirtual.getCapturedMobSubType(currentItemStack);
            }
            this.mobFarmCapturedMob = currentItemStack;
        }
        this.mobFarmExperienceItem = this.container.m_8020_(7);
        this.mobFarmWeaponItem = this.container.m_8020_(6);
        this.mobFarmProgress = this.data.m_6413_(2);
        this.mobFarmTotalTime = this.data.m_6413_(3);
        this.mobFarmTotalTimeText = this.mobFarmTotalTime / 20 + "s";
        this.mobFarmStatus = this.data.m_6413_(4);
        if (!this.mobFarmCapturedMob.m_41619_()) {
            int adaptiveTotalPixelHeight = this.mobFarmTotalTime > 200 ? 15 : 16;
            this.mobFarmProgressImage = this.mobFarmTotalTime != 0 && this.mobFarmProgress != 0 ? this.mobFarmProgress * adaptiveTotalPixelHeight / this.mobFarmTotalTime : 0;
            this.mobFarmRemainingTime = (this.mobFarmTotalTime - this.mobFarmProgress) / 20;
        }
        this.mobFarmRedstoneMode = RedstoneMode.valueOf(this.data.m_6413_(6));
        this.mobFarmBlockPos = new BlockPos(this.data.m_6413_(7), this.data.m_6413_(8), this.data.m_6413_(9));
        BlockState blockState = this.level.m_8055_(this.mobFarmBlockPos);
        this.mobFarmPowered = blockState.m_60734_() instanceof MobFarmBlock && (Boolean)blockState.m_61143_((Property)MobFarmBlock.POWERED) != false;
    }

    public int getMobFarmProgress() {
        return this.mobFarmProgress;
    }

    public int getMobFarmTotalTime() {
        return this.mobFarmTotalTime;
    }

    public String getMobFarmTotalTimeText() {
        return this.mobFarmTotalTimeText;
    }

    public int getMobFarmStatus() {
        return this.mobFarmStatus;
    }

    public int getMobFarmProgressImage() {
        return this.mobFarmProgressImage;
    }

    public int getMobFarmRemainingTime() {
        return this.mobFarmRemainingTime;
    }

    public String getMobFarmName() {
        return this.mobFarmName;
    }

    public String getMobFarmType() {
        return this.mobFarmType;
    }

    public String getMobFarmSubType() {
        return this.mobFarmSubType;
    }

    public BlockPos getMobFarmPosition() {
        return this.mobFarmBlockPos;
    }

    public RedstoneMode getMobFarmRedstoneMode() {
        return this.mobFarmRedstoneMode;
    }

    public boolean isMobFarmPowered() {
        return this.mobFarmPowered;
    }

    public String getAcceptedMobTypeName() {
        return "";
    }

    public boolean hasMobFarmCapturedMob() {
        return this.mobFarmCapturedMob != null && !this.mobFarmCapturedMob.m_41619_();
    }

    public boolean hasMobFarmExperienceItem() {
        return this.mobFarmExperienceItem != null && !this.mobFarmExperienceItem.m_41619_();
    }

    public boolean hasMobFarmWeaponItem() {
        return this.mobFarmWeaponItem != null && !this.mobFarmWeaponItem.m_41619_();
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public boolean mayPlaceCapturedMob(ItemStack itemStack) {
        if (itemStack.m_41720_() instanceof CapturedMob) {
            return CapturedMob.hasCapturedMob(itemStack);
        }
        if (CapturedMobVirtual.isSupported(itemStack)) {
            return CapturedMobVirtual.hasCapturedMob(itemStack);
        }
        return false;
    }

    public boolean mayPlaceCapturedMobType(String mobType) {
        return MobTypeManager.isAcceptedMobType(this.getAcceptedMobTypeName(), mobType);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return itemStack;
        }
        ItemStack slotItemStack = slot.m_7993_();
        itemStack = slotItemStack.m_41777_();
        if (slotItemStack.m_150930_(Items.f_42590_) && slotItemStack.m_41613_() >= 1) {
            if (slotIndex == 7 ? !this.m_38903_(slotItemStack, 9, this.f_38839_.size(), true) : slotIndex >= 6 && !((Slot)this.f_38839_.get(7)).m_6657_() && !this.m_38903_(slotItemStack, 7, 8, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            if (slotItemStack.m_41720_() instanceof ExperienceBottleItem && slotIndex == 7 && !this.m_38903_(slotItemStack, 9, this.f_38839_.size(), true)) {
                return ItemStack.f_41583_;
            }
            if (slotItemStack.m_41720_() instanceof SwordItem) {
                if (slotIndex == 6 ? !this.m_38903_(slotItemStack, 9, this.f_38839_.size(), true) : slotIndex >= 6 && !this.m_38903_(slotItemStack, 6, 7, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (!(slotIndex != 1 && slotIndex != 2 && slotIndex != 3 && slotIndex != 4 && slotIndex != 5 || this.m_38903_(slotItemStack, 9, this.f_38839_.size(), false))) {
                    return ItemStack.f_41583_;
                }
                if ((slotItemStack.m_41720_() instanceof CapturedMob || CapturedMobVirtual.isSupported(slotItemStack)) && (slotIndex == 0 ? !this.m_38903_(slotItemStack, 9, this.f_38839_.size(), true) : slotIndex >= 6 && !this.m_38903_(slotItemStack, 0, 1, false))) {
                    return ItemStack.f_41583_;
                }
            }
        }
        if (slotItemStack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (slotItemStack.m_41613_() == itemStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, slotItemStack);
        return itemStack;
    }
}

