/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.network.message;

import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.data.RedstoneMode;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageRedstoneModeChange {
    protected static final Logger log = LogManager.getLogger((String)"Bo's Easy Mob Farm");
    protected final BlockPos blockPos;
    protected final RedstoneMode redstoneMode;

    public MessageRedstoneModeChange(BlockPos blockPos, RedstoneMode redstoneMode) {
        this.blockPos = blockPos;
        this.redstoneMode = redstoneMode;
    }

    public static void handle(MessageRedstoneModeChange message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> MessageRedstoneModeChange.handlePacket(message, context));
        context.setPacketHandled(true);
    }

    public static void handlePacket(MessageRedstoneModeChange message, NetworkEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        if (serverPlayer == null) {
            return;
        }
        BlockPos blockPos = message.getBlockPos();
        if (blockPos == null) {
            log.error("Received invalid block position for redstone mode change!");
            return;
        }
        BlockEntity blockEntity = serverPlayer.m_9236_().m_7702_(blockPos);
        if (blockEntity == null) {
            log.error("Received invalid block entity for redstone mode change!");
            return;
        }
        if (!(blockEntity instanceof MobFarmBlockEntity)) {
            log.error("Received invalid block entity type for redstone mode change!");
            return;
        }
        RedstoneMode redstoneMode = message.getRedstoneMode();
        if (redstoneMode == null) {
            log.error("Received invalid redstone mode for redstone mode change!");
            return;
        }
        MobFarmBlockEntity mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity;
        log.debug("Change redstone mode for {} to {}", (Object)mobFarmBlockEntity, (Object)redstoneMode);
        mobFarmBlockEntity.setRedstoneMode(redstoneMode);
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }
}

