/*
 * Decompiled with CFR 0.152.
 */
package com.lootbeams;

import com.lootbeams.ClientSetup;
import com.lootbeams.Configuration;
import com.lootbeams.LootBeams;
import com.lootbeams.LootBeamsParticleRenderType;
import com.lootbeams.vfx.Trail;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class VFXParticle
extends TextureSheetParticle {
    private final boolean fullbright;
    private boolean stoppedByCollision;
    private boolean hasTrail = false;
    Trail trail;
    private static final ResourceLocation TEXTURE = new ResourceLocation("lootbeams:textures/entity/white.png");
    Vec3 particleCenter = Vec3.f_82478_;
    Vec3 axis = new Vec3(0.0, ((Double)Configuration.BEAM_HEIGHT.get()).doubleValue(), 0.0);
    private static final ParticleRenderType RENDER_TYPE = new LootBeamsParticleRenderType();

    public VFXParticle(ClientLevel clientWorld, TextureAtlasSprite sprite, float r, float g, float b, float a, int lifetime, float size, Vec3 pos, Vec3 motion, float gravity, boolean collision, boolean fullbright) {
        super(clientWorld, pos.f_82479_, pos.f_82480_, pos.f_82481_);
        this.m_108337_(sprite);
        this.f_107227_ = r;
        this.f_107228_ = g;
        this.f_107229_ = b;
        this.f_107230_ = Math.min(a, 1.0f);
        this.f_107225_ = lifetime + 5;
        this.setSize(size);
        this.f_107215_ = motion.f_82479_;
        this.f_107216_ = motion.f_82480_;
        this.f_107217_ = motion.f_82481_;
        this.f_107226_ = gravity;
        this.f_107219_ = collision;
        this.fullbright = fullbright;
        boolean bl = this.hasTrail = Math.random() < (Double)Configuration.TRAIL_CHANCE.get();
        if (this.hasTrail && ((Boolean)Configuration.TRAIL_PARTICLES_INVISIBLE.get()).booleanValue()) {
            this.setSize(1.0E-5f);
        }
        if (((Boolean)Configuration.TRAILS.get()).booleanValue() && this.hasTrail) {
            this.trail = new Trail(FastColor.ARGB32.m_13660_((int)((int)(r * 255.0f)), (int)((int)(g * 255.0f)), (int)((int)(b * 255.0f)), (int)((int)(a * 255.0f))), width -> Float.valueOf((float)((double)((float)Math.sin((double)width.floatValue() * 3.15) / 2.0f * 0.09f) * (Double)Configuration.TRAIL_WIDTH.get() * (1.0 + Math.random()))));
            this.trail.setColor(r, g, b, a);
            this.trail.setBillboard(true);
            this.trail.setLength((int)((double)((Integer)Configuration.TRAIL_LENGTH.get()).intValue() * (1.0 + Math.random())));
            this.trail.setFrequency((Integer)Configuration.TRAIL_FREQUENCY.get());
            this.trail.pushPoint(new Vec3(this.f_107212_, this.f_107213_, this.f_107214_));
        }
    }

    public boolean shouldCull() {
        return this.hasTrail;
    }

    public void m_5744_(VertexConsumer p_107678_, Camera p_107679_, float p_107680_) {
        Quaternionf quaternionf;
        Vec3 vec3 = p_107679_.m_90583_();
        float f = (float)(Mth.m_14139_((double)p_107680_, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)p_107680_, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)p_107680_, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        float lX = (float)Mth.m_14139_((double)p_107680_, (double)this.f_107209_, (double)this.f_107212_);
        float lY = (float)Mth.m_14139_((double)p_107680_, (double)this.f_107210_, (double)this.f_107213_);
        float lZ = (float)Mth.m_14139_((double)p_107680_, (double)this.f_107211_, (double)this.f_107214_);
        if (this.f_107231_ == 0.0f) {
            quaternionf = p_107679_.m_253121_();
        } else {
            quaternionf = new Quaternionf((Quaternionfc)p_107679_.m_253121_());
            quaternionf.rotateZ(Mth.m_14179_((float)p_107680_, (float)this.f_107204_, (float)this.f_107231_));
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(p_107680_);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        float f6 = this.m_5970_();
        float f7 = this.m_5952_();
        float f4 = this.m_5951_();
        float f5 = this.m_5950_();
        int j = this.m_6355_(p_107680_);
        p_107678_.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        p_107678_.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f7, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        p_107678_.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f6, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        p_107678_.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f6, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        if (((Boolean)Configuration.TRAILS.get()).booleanValue() && this.hasTrail) {
            ClientSetup.delayedRenders.add(ps -> {
                this.trail.pushPoint(new Vec3((double)lX, (double)lY, (double)lZ));
                this.trail.setColor(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_);
                this.trail.render((PoseStack)ps, Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(LootBeams.translucentNoCull(TEXTURE)), j);
            });
        }
    }

    protected int m_6355_(float pPartialTick) {
        if (this.fullbright) {
            return LightTexture.m_109885_((int)15, (int)15);
        }
        return super.m_6355_(pPartialTick);
    }

    public void setSize(float size) {
        this.f_107663_ = size / 10.0f;
        this.m_107250_(size / 10.0f, size / 10.0f);
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (((Boolean)Configuration.SPIN_AROUND_BEAM.get()).booleanValue()) {
            this.applyForce();
        }
        if (this.f_107224_ > this.f_107225_ - 5) {
            this.f_107230_ = 1.0f - (float)(this.f_107224_ - (this.f_107225_ - 5)) / 5.0f;
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        }
    }

    public void setParticleCenter(Vec3 particleCenter) {
        this.particleCenter = particleCenter;
    }

    private void applyForce() {
        Vec3 particleToCenter = this.particleCenter.m_82546_(this.getPosition());
        Vec3 particleToCenterOnAxis = particleToCenter.m_82546_(this.axis.m_82490_(particleToCenter.m_82526_(this.axis)));
        Vec3 particleToCenterOnAxisUnit = particleToCenterOnAxis.m_82541_();
        Vec3 particleToCenterOnAxisUnitCrossVortexAxis = particleToCenterOnAxisUnit.m_82537_(this.axis);
        Vec3 particleToCenterOnAxisUnitCrossVortexAxisUnit = particleToCenterOnAxisUnitCrossVortexAxis.m_82541_();
        Vec3 particleToCenterOnAxisUnitCrossVortexAxisUnitScaled = particleToCenterOnAxisUnitCrossVortexAxisUnit.m_82490_((double)0.01f);
        this.f_107215_ += particleToCenterOnAxisUnitCrossVortexAxisUnitScaled.f_82479_ * 0.65;
        this.f_107216_ += particleToCenterOnAxisUnitCrossVortexAxisUnitScaled.f_82480_;
        this.f_107217_ += particleToCenterOnAxisUnitCrossVortexAxisUnitScaled.f_82481_ * 0.65;
        Vec3 target = this.particleCenter.m_82549_(this.axis.m_82520_(0.0, ((Double)Configuration.BEAM_Y_OFFSET.get()).doubleValue(), 0.0));
        Vec3 particleToTarget = target.m_82546_(this.getPosition());
        Vec3 particleToTargetUnit = particleToTarget.m_82541_();
        boolean mod = !(this.f_107213_ > target.f_82480_);
        Vec3 particleToTargetUnitScaled = particleToTargetUnit.m_82490_((Double)Configuration.PARTICLE_SPEED.get() * (double)mod);
        this.f_107215_ += particleToTargetUnitScaled.f_82479_;
        this.f_107216_ += particleToTargetUnitScaled.f_82480_;
        this.f_107217_ += particleToTargetUnitScaled.f_82481_;
    }

    private Vec3 getPosition() {
        return new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
    }

    public void m_6257_(double x, double y, double z) {
        if (!this.stoppedByCollision) {
            double dX = x;
            double dY = y;
            double dZ = z;
            if (this.f_107219_ && (x != 0.0 || y != 0.0 || z != 0.0)) {
                Vec3 vector3d = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
                x = vector3d.f_82479_;
                y = vector3d.f_82480_;
                z = vector3d.f_82481_;
            }
            if (x != 0.0 || y != 0.0 || z != 0.0) {
                this.m_107259_(this.m_107277_().m_82386_(x, y, z));
                this.m_107275_();
            } else {
                this.stoppedByCollision = true;
            }
            if (dX != x) {
                this.f_107215_ = 0.0;
            }
            if (dY != y) {
                this.f_107216_ = 0.0;
            }
            if (dZ != z) {
                this.f_107217_ = 0.0;
            }
        }
    }

    public ParticleRenderType m_7556_() {
        return RENDER_TYPE;
    }
}

