/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class StructurifyConfig {
    public boolean isLoaded = false;
    public boolean isLoading = false;
    private final Path configPath = Path.of("config", "structurify.json");
    private final Path backupConfigPath = Path.of("config", "structurify_backup.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean enableGlobalSpacingAndSeparationModifier = true;
    public double globalSpacingAndSeparationModifier = 1.0;
    public boolean disableAllStructures = false;
    private Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();

    public Map<String, StructureData> getStructureData() {
        return this.structureData;
    }

    public Map<String, StructureSetData> getStructureSetData() {
        return this.structureSetData;
    }

    public void create() {
        if (Files.exists(this.configPath, new LinkOption[0])) {
            return;
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.isLoading) {
            return;
        }
        try {
            Structurify.getLogger().info("Loading Structurify config...");
            this.isLoading = true;
            WorldgenDataProvider.loadWorldgenData();
            this.structureData = WorldgenDataProvider.getStructures();
            this.structureSetData = WorldgenDataProvider.getStructureSets();
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                return;
            }
            String jsonString = Files.readString(this.configPath);
            JsonObject json = (JsonObject)this.gson.fromJson(jsonString, JsonObject.class);
            if (json.has("general")) {
                JsonObject general = json.getAsJsonObject("general");
                if (general.has("disable_all_structures")) {
                    this.disableAllStructures = general.get("disabled_all_structures").getAsBoolean();
                }
                if (general.has("enable_global_spacing_and_separation_modifier")) {
                    this.enableGlobalSpacingAndSeparationModifier = general.get("enable_global_spacing_and_separation_modifier").getAsBoolean();
                }
                if (general.has("global_spacing_and_separation_modifier")) {
                    this.globalSpacingAndSeparationModifier = (double)Math.round(general.get("global_spacing_and_separation_modifier").getAsDouble() * 10.0) / 10.0;
                }
            }
            if (json.has("disabled_structures")) {
                JsonArray disabledStructuresIds = json.getAsJsonArray("disabled_structures");
                for (JsonElement disabledStructureId : disabledStructuresIds) {
                    if (!this.structureData.containsKey(disabledStructureId.getAsString())) continue;
                    this.structureData.get(disabledStructureId.getAsString()).setDisabled(true);
                }
            }
            if (json.has("structures")) {
                JsonArray structures = json.getAsJsonArray("structures");
                for (JsonElement structure : structures) {
                    JsonObject structureJson = structure.getAsJsonObject();
                    if (!(structureJson.has("name") && structureJson.has("is_disabled") && structureJson.has("biomes") && structureJson.has("enable_biome_check") && structureJson.has("biome_check_distance"))) {
                        Structurify.getLogger().info("Found invalid structure entry, skipping.");
                        continue;
                    }
                    if (!this.structureData.containsKey(structureJson.get("name").getAsString())) {
                        Structurify.getLogger().info("Found invalid structure identifier of \"{}\", skipping.", (Object)structureJson.get("name").getAsString());
                        continue;
                    }
                    StructureData structureData = this.structureData.get(structureJson.get("name").getAsString());
                    structureData.setDisabled(structureJson.get("is_disabled").getAsBoolean());
                    JsonArray biomesJson = structureJson.getAsJsonArray("biomes");
                    ArrayList<String> biomes = new ArrayList<String>();
                    for (JsonElement biome : biomesJson) {
                        if (biomes.contains(biome.getAsString())) continue;
                        biomes.add(biome.getAsString());
                    }
                    structureData.setBiomes(biomes);
                    boolean isBiomeCheckEnabled = structureJson.get("enable_biome_check").getAsBoolean();
                    structureData.setEnableBiomeCheck(isBiomeCheckEnabled);
                    int biomeCheckDistance = structureJson.get("biome_check_distance").getAsInt();
                    structureData.setBiomeCheckDistance(biomeCheckDistance);
                }
            }
            if (json.has("structure_sets")) {
                JsonArray structureSets = json.getAsJsonArray("structure_sets");
                for (JsonElement structureSet : structureSets) {
                    JsonObject structureSpreadJson = structureSet.getAsJsonObject();
                    if (!(structureSpreadJson.has("name") && structureSpreadJson.has("spacing") && structureSpreadJson.has("separation"))) {
                        Structurify.getLogger().info("Found invalid structure set entry, skipping.");
                        continue;
                    }
                    if (!this.structureSetData.containsKey(structureSpreadJson.get("name").getAsString())) {
                        Structurify.getLogger().info("Found invalid structure set identifier of \"{}\", skipping.", (Object)structureSpreadJson.get("name").getAsString());
                        continue;
                    }
                    String structureSetName = structureSpreadJson.get("name").getAsString();
                    StructureSetData structureSetData = this.structureSetData.get(structureSpreadJson.get("name").getAsString());
                    int spacing = structureSpreadJson.get("spacing").getAsInt();
                    int separation = structureSpreadJson.get("separation").getAsInt();
                    if (separation >= spacing) {
                        Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is bigger than spacing {}, value will be automatically corrected to {}.", new Object[]{structureSetName, separation, spacing, spacing - 1});
                        separation = spacing - 1;
                    }
                    if (separation < 0) {
                        Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)separation);
                        separation = 0;
                    }
                    if (spacing < 1) {
                        Structurify.getLogger().info("Spacing value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)spacing);
                        separation = 0;
                    }
                    structureSetData.setSpacing(spacing);
                    structureSetData.setSeparation(separation);
                }
            }
            Structurify.getLogger().info("Structurify config loaded");
            this.isLoaded = true;
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to load Structurify config");
            e.printStackTrace();
        }
        finally {
            this.isLoading = false;
        }
    }

    public void save() {
        Structurify.getLogger().info("Saving Structurify config...");
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                Files.deleteIfExists(this.backupConfigPath);
                Files.move(this.configPath, this.backupConfigPath, new CopyOption[0]);
            }
            JsonObject json = new JsonObject();
            this.saveGeneralData(json);
            this.saveStructuresData(json);
            this.saveStructureSetsData(json);
            Files.createFile(this.configPath, new FileAttribute[0]);
            Files.writeString(this.configPath, (CharSequence)this.gson.toJson((JsonElement)json), new OpenOption[0]);
            Files.deleteIfExists(this.backupConfigPath);
            Structurify.getLogger().info("Structurify config saved");
        }
        catch (Exception e) {
            Structurify.getLogger().error("Failed to save Structurify config");
            e.printStackTrace();
            try {
                Structurify.getLogger().error("Restoring Structurify backup config...");
                Files.delete(this.backupConfigPath);
                Files.move(this.backupConfigPath, this.configPath, new CopyOption[0]);
            }
            catch (Exception fe) {
                Structurify.getLogger().error("Failed to restore Structurify backup config");
                fe.printStackTrace();
            }
        }
    }

    private void saveGeneralData(JsonObject json) {
        JsonObject general = new JsonObject();
        general.addProperty("disabled_all_structures", Boolean.valueOf(this.disableAllStructures));
        general.addProperty("enable_global_spacing_and_separation_modifier", Boolean.valueOf(this.enableGlobalSpacingAndSeparationModifier));
        general.addProperty("global_spacing_and_separation_modifier", (Number)((double)Math.round(this.globalSpacingAndSeparationModifier * 10.0) / 10.0));
        json.add("general", (JsonElement)general);
    }

    private void saveStructuresData(JsonObject json) {
        JsonArray structures = new JsonArray();
        this.structureData.entrySet().stream().filter(entry -> {
            if (((StructureData)entry.getValue()).isDisabled()) {
                return true;
            }
            if (((StructureData)entry.getValue()).isBiomeCheckEnabled()) {
                return true;
            }
            ArrayList<String> biomes = new ArrayList<String>(((StructureData)entry.getValue()).getBiomes());
            ArrayList<String> defaultBiomes = new ArrayList<String>(((StructureData)entry.getValue()).getDefaultBiomes());
            Collections.sort(biomes);
            Collections.sort(defaultBiomes);
            return !biomes.equals(defaultBiomes);
        }).forEach(entry -> {
            JsonObject structure = new JsonObject();
            structure.addProperty("name", (String)entry.getKey());
            structure.addProperty("is_disabled", Boolean.valueOf(((StructureData)entry.getValue()).isDisabled()));
            JsonArray blacklistedBiomes = new JsonArray();
            ((StructureData)entry.getValue()).getBiomes().stream().distinct().forEach(arg_0 -> ((JsonArray)blacklistedBiomes).add(arg_0));
            structure.add("biomes", (JsonElement)blacklistedBiomes);
            structures.add((JsonElement)structure);
            structure.addProperty("enable_biome_check", Boolean.valueOf(((StructureData)entry.getValue()).isBiomeCheckEnabled()));
            structure.addProperty("biome_check_distance", (Number)((StructureData)entry.getValue()).getBiomeCheckDistance());
        });
        json.add("structures", (JsonElement)structures);
    }

    private void saveStructureSetsData(JsonObject json) {
        JsonArray structureSets = new JsonArray();
        this.structureSetData.entrySet().stream().filter(entry -> !((StructureSetData)entry.getValue()).isUsingDefaultSpacing() || !((StructureSetData)entry.getValue()).isUsingDefaultSeparation()).forEach(entry -> {
            String structureSetName = (String)entry.getKey();
            int spacing = ((StructureSetData)entry.getValue()).getSpacing();
            int separation = ((StructureSetData)entry.getValue()).getSeparation();
            if (separation >= spacing) {
                Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is bigger than spacing {}, value will be automatically corrected to {}. ", new Object[]{structureSetName, separation, spacing, spacing - 1});
                separation = spacing - 1;
            }
            if (separation < 0) {
                Structurify.getLogger().info("Separatiton value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)separation);
                separation = 0;
            }
            if (spacing < 1) {
                Structurify.getLogger().info("Spacing value for structure set {} is currently {}, which is lower than minimum value of zero, value will be automatically corrected to 0.", (Object)structureSetName, (Object)spacing);
                separation = 0;
            }
            JsonObject specificStructureSpread = new JsonObject();
            specificStructureSpread.addProperty("name", (String)entry.getKey());
            specificStructureSpread.addProperty("spacing", (Number)spacing);
            specificStructureSpread.addProperty("separation", (Number)separation);
            structureSets.add((JsonElement)specificStructureSpread);
        });
        json.add("structure_sets", (JsonElement)structureSets);
    }
}

