/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import java.util.List;
import java.util.Map;

public final class StructurifyConfigLoader {
    public static void loadConfig(LoadConfigEvent event) {
        if (Structurify.getConfig().isLoaded) {
            return;
        }
        Structurify.getConfig().load();
        List<String> disabledStructures = Structurify.getConfig().getStructureData().entrySet().stream().filter(entry -> ((StructureData)entry.getValue()).isDisabled()).map(Map.Entry::getKey).toList();
        if (!disabledStructures.isEmpty()) {
            Structurify.getLogger().info("Disabled {} structures: {}", (Object)disabledStructures.size(), disabledStructures);
        }
        List<String> changedStructureSets = Structurify.getConfig().getStructureSetData().entrySet().stream().filter(entry -> !((StructureSetData)entry.getValue()).isUsingDefaultSpacingAndSeparation()).map(Map.Entry::getKey).toList();
        if (Structurify.getConfig().enableGlobalSpacingAndSeparationModifier && Structurify.getConfig().globalSpacingAndSeparationModifier != 1.0) {
            Structurify.getLogger().info("Enabled global spacing and separation modifier with value of {}", (Object)Structurify.getConfig().globalSpacingAndSeparationModifier);
        }
        if (!changedStructureSets.isEmpty()) {
            Structurify.getLogger().info("Changed spacing and/or separation of {} structures sets: {}", (Object)changedStructureSets.size(), changedStructureSets);
        }
    }
}

