/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller.element;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.client.api.controller.BiomeStringController;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownControllerElement;
import dev.isxander.yacl3.gui.image.impl.ResourceTextureImage;
import java.io.FileNotFoundException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public final class BiomeStringControllerElement
extends AbstractDropdownControllerElement<String, String> {
    private final BiomeStringController biomeStringController;

    public BiomeStringControllerElement(BiomeStringController control, YACLScreen screen, Dimension<Integer> dim) {
        super((AbstractDropdownController)control, screen, dim);
        this.biomeStringController = control;
    }

    protected void drawValueText(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        Dimension oldDimension = this.getDimension();
        this.setDimension(this.getDimension().withWidth((Number)((Integer)this.getDimension().width() - this.getDecorationPadding())));
        super.drawValueText(graphics, mouseX, mouseY, delta);
        this.setDimension(oldDimension);
        int imageX = (Integer)this.getDimension().xLimit() - this.getXPadding() - this.getDecorationPadding() + 4;
        int imageY = (Integer)this.getDimension().y() + 4;
        this.renderBiomeImage((String)this.biomeStringController.option().pendingValue(), graphics, imageX, imageY, delta);
    }

    public List<String> computeMatchingValues() {
        return this.biomeStringController.getAllowedValues(this.inputField).stream().filter(arg_0 -> ((BiomeStringControllerElement)this).matchingValue(arg_0)).sorted((s1, s2) -> {
            if (s1.startsWith(this.inputField) && !s2.startsWith(this.inputField)) {
                return -1;
            }
            return !s1.startsWith(this.inputField) && s2.startsWith(this.inputField) ? 1 : s1.compareTo((String)s2);
        }).toList();
    }

    public String getString(String biome) {
        return LanguageUtil.translateId("string", biome).getString();
    }

    protected int getDecorationPadding() {
        return 16;
    }

    protected int getDropdownEntryPadding() {
        return 4;
    }

    protected void renderDropdownEntry(GuiGraphics graphics, Dimension<Integer> entryDimension, String value) {
        super.renderDropdownEntry(graphics, entryDimension, (Object)value);
        int imageX = (Integer)entryDimension.xLimit() - 1;
        int imageY = (Integer)entryDimension.y() + 4;
        this.renderBiomeImage(value, graphics, imageX, imageY, 1.0f);
    }

    protected int getControlWidth() {
        return super.getControlWidth() + this.getDecorationPadding();
    }

    protected Component getValueText() {
        if (this.inputField.isEmpty() || this.biomeStringController == null) {
            return super.getValueText();
        }
        if (this.inputFieldFocused) {
            return Component.m_237113_((String)this.inputField);
        }
        return LanguageUtil.translateId("string", (String)this.biomeStringController.option().pendingValue());
    }

    private void renderBiomeImage(String biomeName, GuiGraphics graphics, int x, int y, float delta) {
        biomeName = Structurify.makeVanillaId(biomeName).m_135815_();
        ResourceLocation imageId = Structurify.makeId("textures/gui/config/images/biomes/" + biomeName + ".png");
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        try {
            Resource resource = resourceManager.m_215593_(imageId);
            resource.m_247173_().close();
        }
        catch (FileNotFoundException e) {
            imageId = Structurify.makeId("textures/gui/config/images/biomes/unknown.png");
        }
        try {
            ResourceTextureImage.createFactory((ResourceLocation)imageId, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16).prepareImage().completeImage().render(graphics, x, y, 11, delta);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

