/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.option;

import com.faboslav.structurify.common.config.client.api.controller.DualController;
import com.faboslav.structurify.common.config.client.api.option.OptionPair;
import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class HolderOption<K extends Option<?>, V extends Option<?>>
implements Option<OptionPair<K, V>> {
    private final Component name;
    private OptionDescription description;
    private final DualController<K, V> controller;
    private final OptionPair<K, V> optionPair;
    private final K firstOption;
    private final V secondOption;
    private boolean available;
    private final ImmutableSet<OptionFlag> flags;
    private final List<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>> listeners;
    private int listenerTriggerDepth = 0;

    public HolderOption(@NotNull Component name, @NotNull Function<OptionPair<K, V>, OptionDescription> descriptionFunction, @NotNull Function<Option<OptionPair<K, V>>, DualController<K, V>> controlGetter, boolean available, ImmutableSet<OptionFlag> flags, @NotNull Collection<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>> listeners) {
        this.name = name;
        this.available = available;
        this.flags = flags;
        this.listeners = new ArrayList<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>>(listeners);
        this.controller = controlGetter.apply(this);
        this.optionPair = this.controller.optionPair;
        this.firstOption = this.controller.optionPair.getFirstOption();
        this.secondOption = this.controller.optionPair.getSecondOption();
        this.optionPair.getFirstOption().addListener((opt, pending) -> this.triggerListeners(false));
        this.optionPair.getSecondOption().addListener((opt, pending) -> this.triggerListeners(false));
        this.addListener((opt, pending) -> {
            this.description = (OptionDescription)descriptionFunction.apply((OptionPair<K, V>)pending);
        });
        this.triggerListeners(true);
    }

    @NotNull
    public Component name() {
        return this.optionPair.getFirstOption().name().m_6881_().m_130946_(" & ").m_7220_((Component)this.optionPair.getSecondOption().name().m_6881_());
    }

    @NotNull
    public OptionDescription description() {
        return OptionDescription.of((Component[])new Component[]{this.optionPair.getFirstOption().description().text().m_6881_().m_130946_("\n\n").m_7220_(this.optionPair.getSecondOption().description().text())});
    }

    @NotNull
    public Component tooltip() {
        return this.description().text();
    }

    @NotNull
    public DualController<K, V> controller() {
        return this.controller;
    }

    @NotNull
    public Binding<OptionPair<K, V>> binding() {
        return null;
    }

    public boolean available() {
        return this.optionPair.getFirstOption().available() && this.optionPair.getSecondOption().available();
    }

    public void setAvailable(boolean available) {
        boolean changed = this.available != available;
        this.available = available;
        if (changed) {
            if (!available) {
                this.firstOption.forgetPendingValue();
                this.secondOption.forgetPendingValue();
            }
            this.triggerListeners(!available);
        }
    }

    @NotNull
    public ImmutableSet<OptionFlag> flags() {
        return this.flags;
    }

    public boolean changed() {
        return !this.firstOption.binding().getValue().equals(this.firstOption.pendingValue()) || !this.secondOption.binding().getValue().equals(this.secondOption.pendingValue());
    }

    @NotNull
    public OptionPair<K, V> pendingValue() {
        return null;
    }

    public void requestSet(@NotNull OptionPair<K, V> value) {
        Validate.notNull(value, (String)"`value` cannot be null", (Object[])new Object[0]);
        K firstOption = this.optionPair.getFirstOption();
        V secondOption = this.optionPair.getSecondOption();
        this.triggerListeners(true);
    }

    public boolean applyValue() {
        boolean changed = this.changed();
        if (changed) {
            this.firstOption.applyValue();
            this.secondOption.applyValue();
        }
        return changed;
    }

    public void forgetPendingValue() {
        this.firstOption.forgetPendingValue();
        this.secondOption.forgetPendingValue();
    }

    public void requestSetDefault() {
        this.firstOption.requestSetDefault();
        this.secondOption.requestSetDefault();
    }

    public boolean isPendingValueDefault() {
        return this.firstOption.isPendingValueDefault() && this.secondOption.isPendingValueDefault();
    }

    public void addListener(BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>> changedListener) {
        this.listeners.add(changedListener);
    }

    private void triggerListeners(boolean bypass) {
        if (bypass || this.listenerTriggerDepth == 0) {
            if (this.listenerTriggerDepth > 10) {
                throw new IllegalStateException("Listener trigger depth exceeded 10! This means a listener triggered a listener etc etc 10 times deep. This is likely a bug in the mod using YACL!");
            }
            ++this.listenerTriggerDepth;
            for (BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>> listener : this.listeners) {
                try {
                    listener.accept(this, this.optionPair);
                }
                catch (Exception e) {
                    YACLConstants.LOGGER.error("Exception whilst triggering listener for option '%s'".formatted(this.name.getString()), (Throwable)e);
                }
            }
            --this.listenerTriggerDepth;
        }
    }

    public static <K extends Option<?>, V extends Option<?>> Option.Builder<OptionPair<K, V>> createBuilder() {
        return new HolderOptionBuilder();
    }

    @ApiStatus.Internal
    public static class HolderOptionBuilder<K extends Option<?>, V extends Option<?>>
    implements Option.Builder<OptionPair<K, V>> {
        private Component name = Component.m_237113_((String)"Name not specified!").m_130940_(ChatFormatting.RED);
        private Function<OptionPair<K, V>, OptionDescription> descriptionFunction = pending -> OptionDescription.EMPTY;
        private Function<Option<OptionPair<K, V>>, DualController<K, V>> controlGetter;
        private OptionPair<K, V> optionPair;
        private boolean available = true;
        private boolean instant = false;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private final List<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>> listeners = new ArrayList<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>>();

        public Option.Builder<OptionPair<K, V>> name(@NotNull Component name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> description(@NotNull OptionDescription description) {
            return this.description((OptionPair<K, V> opt) -> description);
        }

        public Option.Builder<OptionPair<K, V>> description(@NotNull Function<OptionPair<K, V>, OptionDescription> descriptionFunction) {
            this.descriptionFunction = descriptionFunction;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> controller(@NotNull Function<Option<OptionPair<K, V>>, ControllerBuilder<OptionPair<K, V>>> controllerBuilder) {
            Validate.notNull(controllerBuilder, (String)"`controllerBuilder` cannot be null", (Object[])new Object[0]);
            return this.customController(opt -> ((ControllerBuilder)controllerBuilder.apply((Option)opt)).build());
        }

        public Option.Builder<OptionPair<K, V>> customController(@NotNull Function<Option<OptionPair<K, V>>, Controller<OptionPair<K, V>>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controlGetter = opt -> (DualController)control.apply((Option)opt);
            return this;
        }

        public Option.Builder<OptionPair<K, V>> binding(@NotNull Binding<OptionPair<K, V>> binding) {
            return null;
        }

        public Option.Builder<OptionPair<K, V>> binding(@NotNull OptionPair<K, V> def, @NotNull @NotNull Supplier<@NotNull OptionPair<K, V>> getter, @NotNull @NotNull Consumer<@NotNull OptionPair<K, V>> setter) {
            return null;
        }

        public Option.Builder<OptionPair<K, V>> optionPair(@NotNull OptionPair<K, V> optionPair) {
            Validate.notNull(optionPair, (String)"`optionPair` cannot be null", (Object[])new Object[0]);
            this.optionPair = optionPair;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> available(boolean available) {
            this.available = available;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        public Option.Builder<OptionPair<K, V>> flags(@NotNull Collection<? extends OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        public Option.Builder<OptionPair<K, V>> instant(boolean instant) {
            this.instant = instant;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> listener(@NotNull BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>> listener) {
            this.listeners.add(listener);
            return this;
        }

        public Option.Builder<OptionPair<K, V>> listeners(@NotNull Collection<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>> listeners) {
            this.listeners.addAll(listeners);
            return this;
        }

        public Option<OptionPair<K, V>> build() {
            Validate.notNull(this.controlGetter, (String)"`control` must not be null when building `Option`", (Object[])new Object[0]);
            Validate.isTrue((!this.instant || this.flags.isEmpty() ? 1 : 0) != 0, (String)"instant application does not support option flags", (Object[])new Object[0]);
            if (this.instant) {
                this.listeners.add((opt, pendingValue) -> opt.applyValue());
            }
            return new HolderOption<K, V>(this.name, this.descriptionFunction, this.controlGetter, this.available, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.listeners);
        }
    }
}

