/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.client.api.controller.builder.BiomeStringControllerBuilder;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructureConfigScreen {
    public static Screen create(Screen parent, String structureId) {
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.m_237113_((String)structureId)).save(Structurify.getConfig()::save);
        MutableComponent translatedStructureName = LanguageUtil.translateId("structure", structureId);
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.m_237110_((String)"gui.structurify.structures.structure.title", (Object[])new Object[]{translatedStructureName})).tooltip(new Component[]{Component.m_237115_((String)"gui.structurify.structures.structure.description")});
        Option enableBiomeCheckOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.enable_biome_check.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.structure.enable_biome_check.description")})).binding((Object)false, () -> Structurify.getConfig().getStructureData().get(structureId).isBiomeCheckEnabled(), enableBiomeCheck -> Structurify.getConfig().getStructureData().get(structureId).setEnableBiomeCheck((boolean)enableBiomeCheck)).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes") : Component.m_237115_((String)"gui.structurify.label.no"))).coloured(true)).build();
        structureCategoryBuilder.option(enableBiomeCheckOption);
        Option biomeCheckDistanceOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.biome_check_distance.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.structure.biome_check_distance.description")})).binding((Object)Structurify.getConfig().getStructureData().get(structureId).getDefaultBiomeCheckDistance(), () -> Structurify.getConfig().getStructureData().get(structureId).getBiomeCheckDistance(), biomeCheckDistance -> Structurify.getConfig().getStructureData().get(structureId).setBiomeCheckDistance((int)biomeCheckDistance)).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)256)).step((Number)1)).build();
        structureCategoryBuilder.option(biomeCheckDistanceOption);
        ListOption biomesOption = ListOption.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.structure.biomes.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structures.structure.biomes.description", (Object[])new Object[]{translatedStructureName})})).insertEntriesAtEnd(false).binding(Structurify.getConfig().getStructureData().get(structureId).getDefaultBiomes(), () -> Structurify.getConfig().getStructureData().get(structureId).getBiomes(), biomes -> Structurify.getConfig().getStructureData().get(structureId).setBiomes((List<String>)biomes)).controller(BiomeStringControllerBuilder::create).initial((Object)"").build();
        structureCategoryBuilder.group((OptionGroup)biomesOption);
        yacl.category(structureCategoryBuilder.build());
        return yacl.build().generateScreen(parent);
    }
}

