/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.DualControllerBuilder;
import com.faboslav.structurify.common.config.client.api.option.HolderOption;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.DoubleSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructureSetsConfigScreen {
    public static Screen createConfigGui(StructurifyConfig config, Screen parent) {
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.m_237115_((String)"gui.structurify.title")).save(config::save);
        StructureSetsConfigScreen.createStructureSetsTab(yacl, config);
        return yacl.build().generateScreen(parent);
    }

    public static void createStructureSetsTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureSetCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets_category.title")).tooltip(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets_category.description").m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.spacing.description")).m_130946_("\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.separation.description"))});
        OptionGroup.Builder generalStructuresSetsGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation.description")}));
        OptionDescription.Builder enableGlobalSpacingAndSeparationDescriptionBuilder = OptionDescription.createBuilder();
        enableGlobalSpacingAndSeparationDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.enable_global_spacing_and_separation_modifier.description")});
        enableGlobalSpacingAndSeparationDescriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
        Option enableGlobalSpacingAndSeparationOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.enable_global_spacing_and_separation_modifier.title")).description(enableGlobalSpacingAndSeparationDescriptionBuilder.build()).binding((Object)true, () -> config.enableGlobalSpacingAndSeparationModifier, enableGlobalSpacingAndSeparationModifier -> {
            config.enableGlobalSpacingAndSeparationModifier = enableGlobalSpacingAndSeparationModifier;
        }).controller(opt -> ((BooleanControllerBuilder)BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes") : Component.m_237115_((String)"gui.structurify.label.no"))).coloured(true)).build();
        generalStructuresSetsGroupBuilder.option(enableGlobalSpacingAndSeparationOption);
        OptionDescription.Builder globalSpacingAndSeparationModifierDescriptionBuilder = OptionDescription.createBuilder();
        globalSpacingAndSeparationModifierDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation_modifier.description")});
        globalSpacingAndSeparationModifierDescriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
        Option globalSpacingAndSeparationModifierOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.global_spacing_and_separation_modifier.title")).description(globalSpacingAndSeparationModifierDescriptionBuilder.build()).binding((Object)1.0, () -> config.globalSpacingAndSeparationModifier, modifier -> {
            config.globalSpacingAndSeparationModifier = modifier;
        }).controller(opt -> ((DoubleSliderControllerBuilder)DoubleSliderControllerBuilder.create((Option)opt).range((Number)0.1, (Number)100.0)).step((Number)0.1)).build();
        generalStructuresSetsGroupBuilder.option(globalSpacingAndSeparationModifierOption);
        structureSetCategoryBuilder.group(generalStructuresSetsGroupBuilder.build());
        Map<String, StructureSetData> structureSets = WorldgenDataProvider.getStructureSets();
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        OptionGroup.Builder currentGroupBuilder = null;
        String currentNamespace = null;
        for (Map.Entry<String, StructureSetData> entry : structureSets.entrySet()) {
            String structureSetStringId = entry.getKey();
            ResourceLocation structureSetId = Structurify.makeVanillaId(structureSetStringId);
            String namespace = structureSetId.m_135827_();
            if (!namespace.equals(currentNamespace)) {
                if (currentGroupBuilder != null) {
                    optionGroups.add(currentGroupBuilder.build());
                }
                currentGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237110_((String)"gui.structurify.structure_sets.structure_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, namespace)})).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structure_sets.structure_group.description", (Object[])new Object[]{namespace})}));
                currentNamespace = namespace;
            }
            OptionDescription.Builder spacingDescriptionBuilder = OptionDescription.createBuilder();
            spacingDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.spacing.description")});
            Option spacingOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.spacing.title")).description(spacingDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSpacing(), () -> config.getStructureSetData().get(structureSetStringId).getSpacing(), spacing -> config.getStructureSetData().get(structureSetStringId).setSpacing((int)spacing)).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)128)).step((Number)1)).build();
            OptionDescription.Builder separationDescriptionBuilder = OptionDescription.createBuilder();
            separationDescriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structure_sets.separation.description")});
            separationDescriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structure_sets.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
            Option separationOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structure_sets.separation.title")).description(separationDescriptionBuilder.build()).binding((Object)config.getStructureSetData().get(structureSetStringId).getDefaultSeparation(), () -> config.getStructureSetData().get(structureSetStringId).getSeparation(), separation -> config.getStructureSetData().get(structureSetStringId).setSeparation((int)separation)).controller(opt -> ((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)opt).range((Number)0, (Number)128)).step((Number)1)).build();
            spacingOption.addListener((opt, spacing) -> {
                if (spacing <= (Integer)separationOption.pendingValue()) {
                    spacingOption.requestSet((Object)((Integer)separationOption.pendingValue() + 1));
                }
            });
            separationOption.addListener((opt, separation) -> {
                if (separation >= (Integer)spacingOption.pendingValue()) {
                    separationOption.requestSet((Object)((Integer)spacingOption.pendingValue() - 1));
                }
            });
            Option.Builder spacingAndSeparationOptionBuilder = HolderOption.createBuilder().controller(opt -> DualControllerBuilder.create(LabelOption.createBuilder().line((Component)LanguageUtil.translateId("structure", structureSetStringId)).build(), spacingOption, separationOption));
            currentGroupBuilder.option(spacingAndSeparationOptionBuilder.build());
        }
        if (currentGroupBuilder != null) {
            optionGroups.add(currentGroupBuilder.build());
        }
        for (OptionGroup structureOptionGroup : optionGroups) {
            structureSetCategoryBuilder.group(structureOptionGroup);
        }
        yacl.category(structureSetCategoryBuilder.build());
    }
}

