/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.StructureButtonControllerBuilder;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class StructuresConfigScreen {
    public static Screen createConfigGui(StructurifyConfig config, Screen parent) {
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
        YetAnotherConfigLib.Builder yacl = YetAnotherConfigLib.createBuilder().title((Component)Component.m_237115_((String)"gui.structurify.title")).save(config::save);
        StructuresConfigScreen.createStructuresTab(yacl, config);
        return yacl.build().generateScreen(parent);
    }

    public static void createStructuresTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures_category.title")).tooltip(new Component[]{Component.m_237115_((String)"gui.structurify.structures_category.description")});
        OptionGroup.Builder generalStructuresGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.general.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.general.description")}));
        Option.Builder disableAllStructuresOptionBuilder = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.disable_all_structures.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.disable_all_structures.description")})).binding((Object)false, () -> config.disableAllStructures, disableAllStructures -> {
            config.disableAllStructures = disableAllStructures;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes").m_130938_(style -> style.m_131140_(ChatFormatting.RED)) : Component.m_237115_((String)"gui.structurify.label.no").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN))));
        generalStructuresGroupBuilder.option(disableAllStructuresOptionBuilder.build());
        structureCategoryBuilder.group(generalStructuresGroupBuilder.build());
        Map<String, StructureData> structures = WorldgenDataProvider.getStructures();
        ArrayList<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        OptionGroup.Builder currentGroupBuilder = null;
        String currentNamespace = null;
        for (Map.Entry<String, StructureData> entry : structures.entrySet()) {
            String structureStringId = entry.getKey();
            StructureData structureData = entry.getValue();
            ResourceLocation structureId = Structurify.makeVanillaId(structureStringId);
            String namespace = structureId.m_135827_();
            if (!namespace.equals(currentNamespace)) {
                if (currentGroupBuilder != null) {
                    optionGroups.add(currentGroupBuilder.build());
                }
                currentGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237110_((String)"gui.structurify.structures.structures_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, namespace).getString()})).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structures.structures_group.description", (Object[])new Object[]{namespace})}));
                currentNamespace = namespace;
            }
            Option.Builder optionBuilder = Option.createBuilder().name((Component)LanguageUtil.translateId("structure", structureStringId)).binding((Object)true, () -> !config.getStructureData().get(structureStringId).isDisabled(), isEnabled -> config.getStructureData().get(structureStringId).setDisabled(isEnabled == false)).controller(opt -> ((BooleanControllerBuilder)StructureButtonControllerBuilder.create((Option<Boolean>)opt, structureStringId).valueFormatter(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.enabled") : Component.m_237115_((String)"gui.structurify.label.disabled"))).coloured(true));
            OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
            descriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structures.biomes_description").m_7220_((Component)Component.m_237113_((String)"\n"))});
            for (String biome : structureData.getBiomes()) {
                descriptionBuilder.text(new Component[]{Component.m_237113_((String)" - ").m_7220_((Component)LanguageUtil.translateId("biome", biome))});
            }
            descriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structures.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
            optionBuilder.description(descriptionBuilder.build());
            currentGroupBuilder.option(optionBuilder.build());
        }
        if (currentGroupBuilder != null) {
            optionGroups.add(currentGroupBuilder.build());
        }
        for (OptionGroup structureOptionGroup : optionGroups) {
            structureCategoryBuilder.group(structureOptionGroup);
        }
        yacl.category(structureCategoryBuilder.build());
    }
}

