/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.data;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyRandomSpreadStructurePlacement;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.StructureSetData;
import com.faboslav.structurify.common.mixin.structure.jigsaw.MaxDistanceFromCenterAccessor;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.Platform;
import com.mojang.datafixers.util.Either;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class WorldgenDataProvider {
    private static List<String> biomes = new ArrayList<String>();
    private static Map<String, StructureData> structureData = new TreeMap<String, StructureData>();
    private static Map<String, StructureSetData> structureSetData = new TreeMap<String, StructureSetData>();
    private static final Comparator<String> alphabeticallComparator = (key1, key2) -> {
        boolean isKey1Minecraft = key1.startsWith("minecraft:");
        boolean isKey2Minecraft = key2.startsWith("minecraft:");
        if (isKey1Minecraft && !isKey2Minecraft) {
            return -1;
        }
        if (!isKey1Minecraft && isKey2Minecraft) {
            return 1;
        }
        return key1.compareTo((String)key2);
    };

    public static List<String> getBiomes() {
        return biomes;
    }

    public static Map<String, StructureData> getStructures() {
        return structureData;
    }

    public static Map<String, StructureSetData> getStructureSets() {
        return structureSetData;
    }

    public static void loadWorldgenData() {
        biomes = WorldgenDataProvider.loadBiomes();
        structureData = WorldgenDataProvider.loadStructures();
        structureSetData = WorldgenDataProvider.loadStructureSets();
    }

    public static List<String> loadBiomes() {
        RegistryAccess registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyList();
        }
        Registry biomeRegistry = registryManager.m_175515_(Registries.f_256952_);
        ArrayList<String> biomes = new ArrayList<String>();
        for (Holder.Reference biome : biomeRegistry.m_203611_().toList()) {
            biomes.add(((ResourceKey)biome.m_203543_().get()).m_135782_().toString());
        }
        return biomes;
    }

    public static Map<String, StructureData> loadStructures() {
        RegistryAccess registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        Registry structureRegistry = registryManager.m_175515_(Registries.f_256944_);
        Registry biomeRegistry = registryManager.m_175515_(Registries.f_256952_);
        TreeMap<String, StructureData> structures = new TreeMap<String, StructureData>(alphabeticallComparator);
        for (Structure structure : structureRegistry) {
            ResourceKey structureRegistryKey = structureRegistry.m_7854_((Object)structure).orElse(null);
            if (structureRegistryKey == null) continue;
            String structureId = structureRegistryKey.m_135782_().toString();
            Either biomeStorage = structure.m_226559_().m_203440_();
            ArrayList<String> defaultBiomes = new ArrayList<String>();
            biomeStorage.mapLeft(biomeTagKey -> {
                biomeRegistry.m_203431_(biomeTagKey).ifPresent(biomes -> {
                    for (Holder biome : biomes) {
                        String biomeKey = ((ResourceKey)biome.m_203543_().get()).m_135782_().toString();
                        defaultBiomes.add(biomeKey);
                    }
                });
                return null;
            });
            int biomeRadiusCheck = 0;
            if (structure instanceof JigsawStructure) {
                biomeRadiusCheck = ((MaxDistanceFromCenterAccessor)structure).structurify$getMaxDistanceFromCenter();
            } else if (Platform.isModLoaded("yungsapi") && structure instanceof YungJigsawStructure) {
                biomeRadiusCheck = ((YungJigsawStructure)structure).maxDistanceFromCenter;
            } else if (Platform.isModLoaded("repurposed_structures") && structure instanceof GenericJigsawStructure) {
                biomeRadiusCheck = ((GenericJigsawStructure)structure).maxDistanceFromCenter.orElse(0);
            } else {
                Field[] fields;
                Class<?> clazz = structure.getClass();
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!field.getName().equals("maxDistanceFromCenter")) continue;
                    field.setAccessible(true);
                    try {
                        if (Optional.class.isAssignableFrom(field.getType())) {
                            Optional optionalValue = (Optional)field.get(structure);
                            biomeRadiusCheck = optionalValue.map(val -> (Integer)val).orElse(0);
                            break;
                        }
                        biomeRadiusCheck = field.getInt(structure);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        Structurify.getLogger().error(e.getMessage());
                    }
                    break;
                }
            }
            structures.put(structureId, new StructureData(defaultBiomes, biomeRadiusCheck));
        }
        return structures;
    }

    public static Map<String, StructureSetData> loadStructureSets() {
        RegistryAccess registryManager = StructurifyRegistryManagerProvider.getRegistryManager();
        if (registryManager == null) {
            return Collections.emptyMap();
        }
        Registry structureSetRegistry = registryManager.m_175515_(Registries.f_256998_);
        TreeMap<String, StructureSetData> structureSets = new TreeMap<String, StructureSetData>();
        for (StructureSet structureSet : structureSetRegistry) {
            ResourceKey structureSetRegistryKey = structureSetRegistry.m_7854_((Object)structureSet).orElse(null);
            if (structureSetRegistryKey == null) continue;
            ResourceLocation structureSetId = structureSetRegistryKey.m_135782_();
            String structureSetStringId = structureSetId.toString();
            StructurePlacement structurePlacement = structureSet.f_210004_();
            if (!(structurePlacement instanceof StructurifyRandomSpreadStructurePlacement)) continue;
            StructurifyRandomSpreadStructurePlacement randomSpreadStructurePlacement = (StructurifyRandomSpreadStructurePlacement)structurePlacement;
            structureSets.put(structureSetStringId, new StructureSetData(randomSpreadStructurePlacement.structurify$getOriginalSpacing(), randomSpreadStructurePlacement.structurify$getOriginalSeparation()));
        }
        return structureSets;
    }
}

