/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.StructureData;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LocateCommand.class})
public class LocateCommandMixin {
    @WrapMethod(method={"locateStructure"})
    private static int structurify$executeLocateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> predicate, Operation<Integer> original) throws CommandSyntaxException {
        if (Structurify.getConfig().disableAllStructures) {
            throw new SimpleCommandExceptionType((Message)Component.m_237115_((String)"command.structurify.locate.exception.all_structures_are_disabled")).create();
        }
        Optional structureRegistryKey = predicate.m_245276_().left();
        Optional structureTagKey = predicate.m_245276_().right();
        if (structureRegistryKey.isPresent()) {
            String structureId = ((ResourceKey)structureRegistryKey.get()).m_135782_().toString();
            if (LocateCommandMixin.structurify$isStructureDisabled(structureId)) {
                throw new SimpleCommandExceptionType((Message)Component.m_237110_((String)"command.structurify.locate.structure_is_disabled", (Object[])new Object[]{structureId})).create();
            }
        } else if (structureTagKey.isPresent()) {
            Registry structureRegistry = source.m_81372_().m_9598_().m_175515_(Registries.f_256944_);
            try {
                structureRegistry.m_203431_((TagKey)structureTagKey.get()).ifPresent(tagStructures -> {
                    boolean areAllStructuresInTagDisabled = true;
                    for (Holder tagStructure : tagStructures) {
                        String tagStructureId = ((ResourceKey)tagStructure.m_203543_().get()).m_135782_().toString();
                        if (LocateCommandMixin.structurify$isStructureDisabled(tagStructureId)) continue;
                        areAllStructuresInTagDisabled = false;
                    }
                    if (areAllStructuresInTagDisabled) {
                        throw new RuntimeException((Throwable)new SimpleCommandExceptionType((Message)Component.m_237110_((String)"command.structurify.locate.structure_is_disabled", (Object[])new Object[]{"#" + ((TagKey)structureTagKey.get()).f_203868_().toString()})).create());
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof CommandSyntaxException) {
                    throw (CommandSyntaxException)e.getCause();
                }
                throw e;
            }
        }
        return (Integer)original.call(new Object[]{source, predicate});
    }

    @Unique
    private static boolean structurify$isStructureDisabled(String structureId) {
        StructureData structureData = Structurify.getConfig().getStructureData().getOrDefault(structureId, null);
        if (structureData == null) {
            return false;
        }
        return structureData.isDisabled();
    }
}

