/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.mixin.structure.jigsaw;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.config.data.StructureData;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.CheckerboardColumnBiomeSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={JigsawStructure.class})
public abstract class JigsawStructureBiomeRadiusCheckMixin
extends Structure
implements StructurifyStructure {
    @Nullable
    public ResourceLocation structureIdentifier = null;
    @Shadow
    @Final
    private HeightProvider f_227608_;

    protected JigsawStructureBiomeRadiusCheckMixin(Structure.StructureSettings config) {
        super(config);
    }

    @Override
    public void structurify$setStructureIdentifier(ResourceLocation structureIdentifier) {
        this.structureIdentifier = structureIdentifier;
    }

    @Override
    @Nullable
    public ResourceLocation structurify$getStructureIdentifier() {
        return this.structureIdentifier;
    }

    @WrapMethod(method={"findGenerationPoint"})
    private Optional<Structure.GenerationStub> structurify$getStructurePosition(Structure.GenerationContext generationContext, Operation<Optional<Structure.GenerationStub>> original) {
        ResourceLocation structureId = this.structurify$getStructureIdentifier();
        if (structureId == null || !Structurify.getConfig().getStructureData().containsKey(structureId.toString())) {
            return (Optional)original.call(new Object[]{generationContext});
        }
        StructureData structureData = Structurify.getConfig().getStructureData().get(structureId.toString());
        if (!structureData.isBiomeCheckEnabled()) {
            return (Optional)original.call(new Object[]{generationContext});
        }
        int biomeCheckDistance = (int)Math.ceil((double)structureData.getBiomeCheckDistance() / 16.0);
        if (biomeCheckDistance != 0 && !(generationContext.f_226623_() instanceof CheckerboardColumnBiomeSource)) {
            ChunkPos chunkPos = generationContext.f_226628_();
            int y = this.f_227608_.m_213859_((RandomSource)generationContext.f_226626_(), new WorldGenerationContext(generationContext.f_226622_(), generationContext.f_226629_()));
            BlockPos blockPos = new BlockPos(generationContext.f_226628_().m_45604_(), y, generationContext.f_226628_().m_45605_());
            int sectionY = blockPos.m_123342_();
            sectionY = QuartPos.m_175400_((int)sectionY);
            for (int curChunkX = chunkPos.f_45578_ - biomeCheckDistance; curChunkX <= chunkPos.f_45578_ + biomeCheckDistance; ++curChunkX) {
                for (int curChunkZ = chunkPos.f_45579_ - biomeCheckDistance; curChunkZ <= chunkPos.f_45579_ + biomeCheckDistance; ++curChunkZ) {
                    Holder biome = generationContext.f_226623_().m_203407_(QuartPos.m_175404_((int)curChunkX), sectionY, QuartPos.m_175404_((int)curChunkZ), generationContext.f_226624_().m_224579_());
                    if (generationContext.f_226630_().test(biome)) continue;
                    return Optional.empty();
                }
            }
        }
        return (Optional)original.call(new Object[]{generationContext});
    }
}

