/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.modcompat;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.modcompat.GlobalPacksCompat;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.modcompat.forge.ModCheckerImpl;
import com.faboslav.structurify.common.util.Platform;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public final class ModChecker {
    public static final List<ModCompat> CUSTOM_RESOURCE_PACK_PROVIDER_COMPATS = new ArrayList<ModCompat>();

    public static void setupModCompat() {
        String modId = "";
        try {
            modId = "globalpacks";
            ModChecker.loadModCompat(modId, () -> new GlobalPacksCompat());
            ModChecker.setupPlatformModCompat();
        }
        catch (Throwable e) {
            Structurify.getLogger().error("Failed to setup compat with " + modId);
            e.printStackTrace();
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void setupPlatformModCompat() {
        ModCheckerImpl.setupPlatformModCompat();
    }

    public static void loadModCompat(String modId, Supplier<ModCompat> loader) {
        try {
            ModCompat compat;
            if (Platform.isModLoaded(modId) && (compat = loader.get()).compatTypes().contains((Object)ModCompat.Type.CUSTOM_RESOURCE_PACK_PROVIDERS)) {
                CUSTOM_RESOURCE_PACK_PROVIDER_COMPATS.add(compat);
            }
        }
        catch (Throwable e) {
            Structurify.getLogger().error("Failed to load compat with " + modId);
            e.printStackTrace();
        }
    }
}

