/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.registry.StructurifyResourcePackProvider;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import org.jetbrains.annotations.Nullable;

public final class StructurifyRegistryManagerProvider {
    @Nullable
    private static RegistryAccess registryManager = null;
    private static boolean isLoading = false;

    @Nullable
    public static RegistryAccess getRegistryManager() {
        if (registryManager == null) {
            StructurifyRegistryManagerProvider.loadRegistryManager();
        }
        return registryManager;
    }

    public static void setRegistryManager(RegistryAccess registryAccess) {
        registryManager = registryAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadRegistryManager() {
        if (isLoading) {
            return;
        }
        isLoading = true;
        try {
            Structurify.getLogger().info("Loading registry manager...");
            ArrayList<RepositorySource> resourcePackProviders = StructurifyResourcePackProvider.getResourcePackProviders();
            for (RepositorySource resourcePackProvider : resourcePackProviders) {
                Structurify.getLogger().info("Registering resource pack provider: " + resourcePackProvider.getClass().getSimpleName());
            }
            PackRepository resourcePackManager = new PackRepository(StructurifyResourcePackProvider.getResourcePackProviders().toArray(new RepositorySource[0]));
            WorldLoader.PackConfig dataPacks = new WorldLoader.PackConfig(resourcePackManager, WorldDataConfiguration.f_244649_, false, false);
            WorldLoader.InitConfig serverConfig = new WorldLoader.InitConfig(dataPacks, Commands.CommandSelection.INTEGRATED, 2);
            WorldStem saveLoader = (WorldStem)Util.m_214679_(executor -> WorldLoader.m_214362_((WorldLoader.InitConfig)serverConfig, loadContextSupplierContext -> {
                Registry registry = new MappedRegistry(Registries.f_256862_, Lifecycle.stable()).m_203521_();
                WorldDimensions.Complete dimensionsConfig = ((WorldPreset)loadContextSupplierContext.f_244104_().m_175515_(Registries.f_256729_).m_246971_(WorldPresets.f_226438_).m_203334_()).m_247748_().m_245300_(registry);
                return new WorldLoader.DataLoadOutput(null, dimensionsConfig.m_245593_());
            }, WorldStem::new, (Executor)Util.m_183991_(), (Executor)executor)).get();
            if (saveLoader == null || saveLoader.f_244542_() == null) {
                Structurify.getLogger().error("SaveLoader or CombinedDynamicRegistries is null.");
                return;
            }
            StructurifyRegistryManagerProvider.setRegistryManager((RegistryAccess)saveLoader.f_244542_().m_247579_());
            Structurify.getLogger().info("Finished loading registry manager");
        }
        catch (Exception exception) {
            Structurify.getLogger().error("Failed to load registry manager.", (Throwable)exception);
        }
        finally {
            isLoading = false;
        }
    }
}

