/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyRandomSpreadStructurePlacement;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;

public final class StructurifyRegistryUpdater {
    public static void updateRegistries(UpdateRegistriesEvent event) {
        if (!Structurify.getConfig().isLoaded) {
            return;
        }
        try {
            Structurify.getLogger().info("Updating registries...");
            RegistryAccess registryManager = event.registryManager();
            if (registryManager == null) {
                return;
            }
            StructurifyRegistryUpdater.updateStructures(registryManager);
            StructurifyRegistryUpdater.updateStructureSets(registryManager);
            Structurify.getLogger().info("Registries updated");
        }
        catch (Exception e) {
            Structurify.getLogger().info("Failed to update registries");
        }
    }

    private static void updateStructures(RegistryAccess registryManager) {
        Registry structureRegistry = registryManager.m_6632_(Registries.f_256944_).orElse(null);
        if (structureRegistry == null) {
            return;
        }
        for (Structure structure : structureRegistry) {
            ResourceKey structureRegistryKey = structureRegistry.m_7854_((Object)structure).orElse(null);
            if (structureRegistryKey == null) continue;
            ResourceLocation structureId = structureRegistryKey.m_135782_();
            ((StructurifyStructure)structure).structurify$setStructureIdentifier(structureId);
        }
        Structurify.getLogger().info("Structure registries updated");
    }

    private static void updateStructureSets(RegistryAccess registryManager) {
        Registry structureSetRegistry = registryManager.m_6632_(Registries.f_256998_).orElse(null);
        if (structureSetRegistry == null) {
            return;
        }
        for (StructureSet structureSet : structureSetRegistry) {
            ResourceKey structureSetRegistryKey = structureSetRegistry.m_7854_((Object)structureSet).orElse(null);
            if (structureSetRegistryKey == null) continue;
            ResourceLocation structureSetId = structureSetRegistryKey.m_135782_();
            StructurePlacement structurePlacement = structureSet.f_210004_();
            if (!(structurePlacement instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement randomSpreadStructurePlacement = (RandomSpreadStructurePlacement)structurePlacement;
            ((StructurifyRandomSpreadStructurePlacement)randomSpreadStructurePlacement).structurify$setStructureSetIdentifier(structureSetId);
        }
        Structurify.getLogger().info("Structure Sets registries updated");
    }
}

