/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.entity.projectile;

import com.stal111.forbidden_arcanus.core.init.ModEntities;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class EnergyBall
extends Projectile {
    private static final float MOTION_FACTOR = 0.95f;
    private static final float MOTION_FACTOR_WATER = 0.8f;
    private static final float ROTATION_SPEED = 0.2f;
    private static final float DAMAGE_AMOUNT = 5.5f;
    private LivingEntity shootingEntity;
    private int ticksAlive;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;

    public EnergyBall(Level level, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super((EntityType)ModEntities.ENERGY_BALL.get(), level);
        this.shootingEntity = shooter;
        this.m_7678_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), shooter.f_19859_, shooter.f_19860_);
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(Vec3.f_82478_);
        double d0 = Mth.m_14116_((float)((float)(accelX * accelX + accelY * accelY + accelZ * accelZ)));
        this.accelerationX = accelX / d0 * 0.1;
        this.accelerationY = accelY / d0 * 0.1;
        this.accelerationZ = accelZ / d0 * 0.1;
    }

    public EnergyBall(EntityType<? extends EnergyBall> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void m_8119_() {
        super.m_8119_();
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, entity -> entity.m_6084_() && entity != this.shootingEntity);
        if (hitResult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.onImpact(hitResult);
        }
        Vec3 vec3 = this.m_20184_();
        this.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (vec3.f_82480_ - 0.01), this.m_20189_() + vec3.f_82481_);
        ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
        float motionFactor = 0.95f;
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - vec3.f_82479_ * 0.25, this.m_20186_() - vec3.f_82480_ * 0.25, this.m_20189_() - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
            motionFactor = 0.8f;
        }
        this.m_20256_(vec3.m_82520_(this.accelerationX, this.accelerationY, this.accelerationZ).m_82490_((double)motionFactor));
        this.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public void onImpact(HitResult result) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            Entity entity = entityHitResult.m_82443_();
            entity.m_6469_(this.m_9236_().m_269111_().m_269104_((Entity)this, (Entity)this.shootingEntity), 5.5f);
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.m_9236_());
            lightningBolt.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            this.m_9236_().m_7967_((Entity)lightningBolt);
        } else if (result.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 vec3 = result.m_82450_();
            this.m_9236_().m_6263_(null, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), (SoundEvent)ModSounds.ENERGY_BALL_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        this.m_146870_();
    }

    protected void m_7380_(CompoundTag tag) {
        Vec3 vec3 = this.m_20184_();
        tag.m_128365_("direction", (Tag)this.m_20063_(new double[]{vec3.f_82479_, vec3.f_82480_, vec3.f_82481_}));
        tag.m_128365_("power", (Tag)this.m_20063_(new double[]{this.accelerationX, this.accelerationY, this.accelerationZ}));
        tag.m_128405_("life", this.ticksAlive);
    }

    public void m_7378_(CompoundTag tag) {
        ListTag list;
        if (tag.m_128425_("power", 9) && (list = tag.m_128437_("power", 6)).size() == 3) {
            this.accelerationX = list.m_128772_(0);
            this.accelerationY = list.m_128772_(1);
            this.accelerationZ = list.m_128772_(2);
        }
        this.ticksAlive = tag.m_128451_("life");
        if (tag.m_128425_("direction", 9) && tag.m_128437_("direction", 6).size() == 3) {
            list = tag.m_128437_("direction", 6);
            this.m_20334_(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
        } else {
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public float m_6143_() {
        return 1.0f;
    }

    public boolean m_6469_(@Nonnull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        if (source.m_7639_() != null) {
            Vec3 vec3 = source.m_7639_().m_20154_();
            this.m_20256_(vec3);
            this.accelerationX = vec3.f_82479_ * 0.1;
            this.accelerationY = vec3.f_82480_ * 0.1;
            this.accelerationZ = vec3.f_82481_ * 0.1;
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.shootingEntity = livingEntity = (LivingEntity)entity;
            }
            return true;
        }
        return false;
    }

    public float m_213856_() {
        return 1.0f;
    }
}

