/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.data;

import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class GenericRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();

    public GenericRecipeBuilder(RecipeSerializer<?> serializer) {
        this.serializer = Objects.requireNonNull(serializer, "serializer");
    }

    public GenericRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementId;
        Supplier<JsonObject> advancementBuilder;
        if (this.advancementBuilder.m_138405_().isEmpty()) {
            advancementBuilder = () -> null;
            advancementId = new ResourceLocation("");
        } else {
            advancementBuilder = () -> ((Advancement.Builder)this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_)).m_138400_();
            advancementId = new ResourceLocation(id.m_135827_(), "recipes/fairylights/" + id.m_135815_());
        }
        consumer.accept(new Result(this.serializer, id, advancementBuilder, advancementId));
    }

    public static GenericRecipeBuilder customRecipe(RecipeSerializer<?> serializer) {
        return new GenericRecipeBuilder(serializer);
    }

    static class Result
    implements FinishedRecipe {
        final RecipeSerializer<?> serializer;
        final ResourceLocation id;
        final Supplier<JsonObject> advancementJson;
        final ResourceLocation advancementId;

        public Result(RecipeSerializer<?> serializer, ResourceLocation id, Supplier<JsonObject> advancementJson, ResourceLocation advancementId) {
            this.serializer = serializer;
            this.id = id;
            this.advancementJson = advancementJson;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public JsonObject m_5860_() {
            return this.advancementJson.get();
        }

        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

