/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.UUID;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.item.DyeableItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public final class GarlandTinselConnection
extends Connection {
    private int color = DyeableItem.getColor(DyeColor.LIGHT_GRAY);

    public GarlandTinselConnection(ConnectionType<? extends GarlandTinselConnection> type, Level world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public float getRadius() {
        return 0.125f;
    }

    @Override
    public CompoundTag serializeLogic() {
        return DyeableItem.setColor(super.serializeLogic(), this.color);
    }

    @Override
    public void deserializeLogic(CompoundTag compound) {
        super.deserializeLogic(compound);
        this.color = DyeableItem.getColor(compound);
    }
}

