/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NewCapabilities {
    public static final Capability<ITrinketsData> TRINKETS_DATA_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ITrinketsData>(){});
    public static final ResourceLocation ID = new ResourceLocation("nameless_trinkets", "trinkets_data");
    private static final String RAGE_ENTITY_TAG = "rageEntity";
    private static final String SIGIL_TAG = "sigil";
    private static final String TICK_TAG = "tick";
    private static final String TICK_VAMPIRE_PAUSE_TAG = "tickVampirePause";

    public static LazyOptional<ITrinketsData> getCapability(Player player) {
        return player.getCapability(TRINKETS_DATA_CAP);
    }

    public static class CapabilityEvents {
        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (entity instanceof Player) {
                evt.addCapability(ID, (ICapabilityProvider)new Provider());
            }
        }

        @SubscribeEvent
        public void onPlayerDeath(PlayerEvent.Clone evt) {
            if (evt.isWasDeath()) {
                Player player = evt.getEntity();
                Player original = evt.getOriginal();
                original.revive();
                NewCapabilities.getCapability(player).ifPresent(sleepdata -> NewCapabilities.getCapability(original).ifPresent(sleepdata::copyFrom));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<ITrinketsData> optional;
        final ITrinketsData data = new SleepDataWrapper();

        Provider() {
            this.optional = LazyOptional.of(() -> this.data);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction side) {
            return TRINKETS_DATA_CAP.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            CompoundTag compound = new CompoundTag();
            if (this.data.getRageEntity() != null) {
                compound.m_128365_(NewCapabilities.RAGE_ENTITY_TAG, (Tag)this.data.getRageEntity());
            }
            compound.m_128350_(NewCapabilities.SIGIL_TAG, this.data.getSigil());
            compound.m_128350_(NewCapabilities.TICK_TAG, this.data.getTick());
            compound.m_128350_(NewCapabilities.TICK_VAMPIRE_PAUSE_TAG, this.data.getTickVampirePause());
            return compound;
        }

        public void deserializeNBT(Tag nbt) {
            CompoundTag compound = (CompoundTag)nbt;
            this.data.setRageEntity(compound.m_128469_(NewCapabilities.RAGE_ENTITY_TAG));
            this.data.setSigil(compound.m_128457_(NewCapabilities.SIGIL_TAG));
            this.data.setTick(compound.m_128457_(NewCapabilities.TICK_TAG));
            this.data.setTickVampirePause(compound.m_128457_(NewCapabilities.TICK_VAMPIRE_PAUSE_TAG));
        }
    }

    public static class SleepDataWrapper
    implements ITrinketsData {
        float sigil = 0.0f;
        float tick = 0.0f;
        float tickVampirePause = 0.0f;
        CompoundTag entityRage = null;

        @Override
        public CompoundTag getRageEntity() {
            return this.entityRage;
        }

        @Override
        public CompoundTag setRageEntity(CompoundTag entity) {
            if (entity != null) {
                this.entityRage = entity;
                return this.entityRage;
            }
            return this.entityRage;
        }

        @Override
        public float getSigil() {
            return this.sigil;
        }

        @Override
        public float setSigil(float count) {
            this.sigil = count;
            return this.sigil;
        }

        @Override
        public float getTick() {
            return this.tick;
        }

        @Override
        public float setTick(float count) {
            this.tick = count;
            return this.tick;
        }

        @Override
        public float getTickVampirePause() {
            return this.tickVampirePause;
        }

        @Override
        public float setTickVampirePause(float count) {
            this.tickVampirePause = count;
            return this.tickVampirePause;
        }

        @Override
        public void copyFrom(ITrinketsData other) {
            this.setRageEntity(other.getRageEntity());
            this.setSigil(other.getSigil());
            this.setTick(other.getTick());
            this.setTickVampirePause(other.getTickVampirePause());
        }
    }

    public static interface ITrinketsData {
        public CompoundTag getRageEntity();

        public CompoundTag setRageEntity(CompoundTag var1);

        public float getSigil();

        public float setSigil(float var1);

        public float getTick();

        public float setTick(float var1);

        public float getTickVampirePause();

        public float setTickVampirePause(float var1);

        public void copyFrom(ITrinketsData var1);
    }
}

