/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class BrokenAnkh
extends TrinketItem<Stats>
implements ICurioItem {
    public static final String TAG_NAME = "CooldownTrinket";
    private static final List<ServerPlayer> joiningPlayerQueue = new ArrayList<ServerPlayer>();
    public static BrokenAnkh INSTANCE;

    public BrokenAnkh() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void stopDeath(LivingDeathEvent event) {
        Optional stack;
        Player player;
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_5833_() && (stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.BROKEN_ANKH.get())).isPresent() && player.m_21224_() && !player.m_36335_().m_41519_(((SlotResult)stack.get()).stack().m_41720_()) && !player.m_9236_().f_46443_) {
            ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
            ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123777_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 50, 1.0, 1.0, 1.0, 0.1);
            ((ServerLevel)player.m_20193_()).m_8767_((ParticleOptions)ParticleTypes.f_123789_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 100, 1.0, 1.0, 1.0, 0.1);
            event.setCanceled(true);
            player.m_21153_(2.0f);
            player.m_21219_();
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            player.m_36335_().m_41524_(((SlotResult)stack.get()).stack().m_41720_(), config.cooldown);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            joiningPlayerQueue.add((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            Optional stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player2, (Item)ModItems.BROKEN_ANKH.get());
            if (stack.isEmpty()) {
                return;
            }
            player2.getPersistentData().m_128350_(TAG_NAME, player2.m_36335_().m_41521_(((SlotResult)stack.get()).stack().m_41720_(), 0.0f));
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (event.phase == TickEvent.Phase.END && !joiningPlayerQueue.isEmpty()) {
            Iterator<ServerPlayer> iter = joiningPlayerQueue.iterator();
            while (iter.hasNext()) {
                ServerPlayer player = iter.next();
                iter.remove();
                Optional stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.BROKEN_ANKH.get());
                if (stack.isEmpty()) {
                    return;
                }
                CompoundTag playerData = player.getPersistentData();
                if (!playerData.m_128441_(TAG_NAME)) continue;
                float oldCooldown = playerData.m_128457_(TAG_NAME);
                player.m_36335_().m_41524_(((SlotResult)stack.get()).stack().m_41720_(), (int)(oldCooldown * (float)config.cooldown));
                playerData.m_128473_(TAG_NAME);
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.BROKEN_ANKH.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.broken_ankh_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.broken_ankh_1", (Object[])new Object[]{config.cooldown / 60 / 20}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int cooldown = 36000;
        public boolean isEnable = true;
    }
}

