/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class MinersSoul
extends TrinketItem<Stats>
implements ICurioItem {
    public static MinersSoul INSTANCE;

    public MinersSoul() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void playerBreakBlock(BlockEvent.BreakEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        if (event.getPlayer() != null) {
            Optional stack0;
            Player player = event.getPlayer();
            if (!player.m_9236_().f_46443_ && !player.m_150110_().f_35937_ && (stack0 = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.MINERS_SOUL.get())).isPresent()) {
                Level level = player.m_9236_();
                ItemStack itemStack = player.m_21205_();
                ItemStack fakeItemStack = new ItemStack((ItemLike)itemStack.m_41720_());
                HashMap map = Maps.newHashMap();
                if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44985_, (ItemStack)itemStack) > 0) {
                    return;
                }
                int bonusLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44987_, (ItemStack)itemStack);
                FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                fakePlayer.m_8061_(EquipmentSlot.MAINHAND, fakeItemStack);
                map.put(Enchantments.f_44987_, bonusLevel + config.extraLootingLevel);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)fakeItemStack);
                if (!(event.getState().m_60734_() instanceof EntityBlock)) {
                    LootParams context;
                    LootTable loot = Objects.requireNonNull(level.m_7654_()).m_278653_().m_278676_(event.getState().m_60734_().m_60589_());
                    ObjectArrayList drops = loot.m_287195_(context = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)event.getPos())).m_287286_(LootContextParams.f_81463_, (Object)fakeItemStack).m_287286_(LootContextParams.f_81461_, (Object)event.getState()).m_287235_(LootContextParamSets.f_81421_));
                    if (!drops.isEmpty()) {
                        ((ItemStack)drops.get(0)).m_41764_(((ItemStack)drops.get(0)).m_41613_() - 1);
                    }
                    for (ItemStack drop : drops) {
                        ItemEntity itementity = new ItemEntity(level, (double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123343_(), drop);
                        itementity.m_32060_();
                        itementity.m_146884_(Vec3.m_82512_((Vec3i)event.getPos()));
                        itementity.m_20256_(itementity.m_20184_().m_82520_((double)((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f), (double)(level.f_46441_.m_188501_() * 0.05f), (double)((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.1f)));
                        level.m_7967_((Entity)itementity);
                    }
                }
            }
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.MINERS_SOUL.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.miners_soul_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.miners_soul_1", (Object[])new Object[]{config.extraLootingLevel}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public int extraLootingLevel = 1;
        public boolean isEnable = true;
    }
}

