/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.capability.NewCapabilities;
import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class RageMind
extends TrinketItem<Stats>
implements ICurioItem {
    public static RageMind INSTANCE;

    public RageMind() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    @SubscribeEvent
    public static void getEntity(LivingDamageEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Entity entity;
            Player player = (Player)livingEntity;
            Optional stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.RAGE_MIND.get());
            if (stack.isPresent() && (entity = event.getSource().m_7639_()) != null && entity instanceof LivingEntity) {
                NewCapabilities.getCapability(player).ifPresent(trinketsData -> trinketsData.setRageEntity(entity.serializeNBT()));
            }
        }
    }

    @SubscribeEvent
    public static void dealDamage(LivingDamageEvent event) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Optional stack = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ModItems.RAGE_MIND.get());
            if (stack.isPresent()) {
                NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
                    if (trinketsData.getRageEntity() != null) {
                        CompoundTag entity = trinketsData.getRageEntity();
                        Entity entityTarget = EntityType.m_20645_((CompoundTag)entity, (Level)player.m_9236_(), p_138828_ -> {
                            p_138828_.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), p_138828_.m_146908_(), p_138828_.m_146909_());
                            return p_138828_;
                        });
                        if (entityTarget == null) {
                            return;
                        }
                        Class<?> classEntity = entityTarget.getClass();
                        if (event.getEntity() == null) {
                            return;
                        }
                        if (event.getEntity().getClass() == classEntity) {
                            event.setAmount(event.getAmount() * config.damageMultiplier);
                        }
                    }
                });
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        Player player = (Player)slotContext.entity();
        NewCapabilities.getCapability(player).ifPresent(trinketsData -> {
            if (trinketsData.getRageEntity() != null) {
                CompoundTag entityCompound = trinketsData.getRageEntity();
                LivingEntity entityTarget = (LivingEntity)EntityType.m_20645_((CompoundTag)entityCompound, (Level)player.m_9236_(), p_138828_ -> {
                    p_138828_.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), p_138828_.m_146908_(), p_138828_.m_146909_());
                    return p_138828_;
                });
                if (entityTarget == null) {
                    return;
                }
                Class<?> classEntity = entityTarget.getClass();
                AABB targetBox = new AABB(player.m_20182_(), player.m_20182_()).m_82400_((double)config.range);
                List foundTarget = player.m_9236_().m_45976_(classEntity, targetBox);
                if (!foundTarget.isEmpty()) {
                    for (LivingEntity entity1 : foundTarget) {
                        PlayerTeam playerteam;
                        if (entity1 == null) {
                            return;
                        }
                        MobEffectInstance effectinstance = new MobEffectInstance(MobEffects.f_19619_, 20, 20);
                        Scoreboard scoreboard = player.m_36329_();
                        if (!scoreboard.m_83488_().contains("revengeEntities")) {
                            scoreboard.m_83492_("revengeEntities");
                        }
                        if ((playerteam = player.m_9236_().m_6188_().m_83489_("revengeEntities")) == null) {
                            return;
                        }
                        scoreboard.m_6546_(entity1.m_20149_(), playerteam);
                        playerteam.m_83351_(ChatFormatting.RED);
                        entity1.m_7292_(effectinstance);
                    }
                }
            }
        });
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.RAGE_MIND.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.rage_mind_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.rage_mind_1").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.rage_mind_2", (Object[])new Object[]{Float.valueOf(config.damageMultiplier)}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
            }
        }
    }

    public static class Stats
    extends TrinketsStats {
        public float damageMultiplier = 1.5f;
        public float range = 50.0f;
        public boolean isEnable = true;
    }
}

