/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.nameless_trinkets.items.trinkets;

import com.cozary.nameless_trinkets.init.ModItems;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketData;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketItem;
import com.cozary.nameless_trinkets.items.subTrinket.TrinketsStats;
import com.cozary.nameless_trinkets.utils.EntityUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod.EventBusSubscriber(modid="nameless_trinkets")
public class TearOfTheSea
extends TrinketItem<Stats>
implements ICurioItem {
    public static TearOfTheSea INSTANCE;
    private final MutablePair<String, UUID> TearOfTHeSea_MOD = new MutablePair((Object)"nameless_trinkets:tear_of_the_sea_swim_speed", (Object)UUID.randomUUID());

    public TearOfTheSea() {
        super(TrinketData.builder().config(Stats.class).build());
        INSTANCE = this;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return CuriosApi.getCuriosHelper().findFirstCurio(slotContext.entity(), (Item)ModItems.TEAR_OF_THE_SEA.get()).isEmpty();
    }

    public void onEquipFromUse(SlotContext slotContext, ItemStack stack) {
        slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo(SoundEvents.f_11674_, 1.0f, 1.0f);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.isDisabled").m_130940_(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.tear_of_the_sea_lore").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC}));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"tooltip.nameless_trinkets.tear_of_the_sea_1", (Object[])new Object[]{config.swimSpeedMultiplier + "%"}).m_130940_(ChatFormatting.GOLD));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.nameless_trinkets.hold_shift"));
                tooltip.add((Component)Component.m_237115_((String)(ChatFormatting.GRAY + "Suggested By: JayOnline_")));
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Stats config = (Stats)INSTANCE.getConfig();
        if (!config.isEnable) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        Level world = livingEntity.m_20193_();
        if (world.m_5776_() || livingEntity.f_19797_ % 20 != 0) {
            return;
        }
        AttributeInstance attribSpeed = livingEntity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        AttributeModifier speedModifier = new AttributeModifier((UUID)this.TearOfTHeSea_MOD.getRight(), (String)this.TearOfTHeSea_MOD.getLeft(), config.swimSpeedMultiplier / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        assert (attribSpeed != null);
        EntityUtils.applyAttributeModifier(attribSpeed, speedModifier);
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        EntityUtils.removeAttributeModifier(Objects.requireNonNull(slotContext.entity().m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())), new AttributeModifier((UUID)this.TearOfTHeSea_MOD.getRight(), (String)this.TearOfTHeSea_MOD.getLeft(), ((Stats)this.config).swimSpeedMultiplier / 100.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    public static class Stats
    extends TrinketsStats {
        public double swimSpeedMultiplier = 150.0;
        public boolean isEnable = true;
    }
}

