/*
 * Decompiled with CFR 0.152.
 */
package com.ineffa.trulytreasures;

import com.ineffa.trulytreasures.config.TrulyTreasuresConfig;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="trulytreasures")
public class TrulyTreasures {
    public static final String MOD_ID = "trulytreasures";
    public static TrulyTreasuresConfig config;

    public TrulyTreasures() {
        AutoConfig.register(TrulyTreasuresConfig.class, GsonConfigSerializer::new);
        config = (TrulyTreasuresConfig)AutoConfig.getConfigHolder(TrulyTreasuresConfig.class).getConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    protected static void addWandererTradesForEnchantment(Enchantment enchantment, WandererTradesEvent event) {
        for (int level = enchantment.m_44702_(); level <= enchantment.m_6586_(); ++level) {
            ItemStack book = EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, level));
            book.m_41764_(1);
            int maxTrades = TrulyTreasures.config.wanderingTraderSettings.maxTrades;
            int basePrice = TrulyTreasures.config.wanderingTraderSettings.basePrice;
            int price = enchantment.m_6586_() == 1 ? basePrice * 2 : Mth.m_14045_((int)(basePrice * level), (int)0, (int)64);
            int xp = enchantment.m_6586_() == 1 ? 10 : 5 * level;
            event.getRareTrades().add(new BasicItemListing(price, book, maxTrades, xp));
        }
    }

    public static boolean isEnchantmentAllowedForVillagers(Enchantment enchantment) {
        if (!enchantment.m_6594_()) {
            return false;
        }
        return !TrulyTreasures.config.villagerSettings.enchantmentRemovalMode.shouldRemoveEnchantment(enchantment) || TrulyTreasures.config.villagerSettings.enchantmentsToKeep.contains(Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment)).toString());
    }
}

