/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod;

import baguchan.earthmobsmod.EarthMobsMod;
import baguchan.earthmobsmod.api.IMoss;
import baguchan.earthmobsmod.api.IMuddy;
import baguchan.earthmobsmod.block.CarvedMelonBlock;
import baguchan.earthmobsmod.capability.ShadowCapability;
import baguchan.earthmobsmod.entity.FurnaceGolem;
import baguchan.earthmobsmod.entity.ZombifiedPig;
import baguchan.earthmobsmod.entity.ZombifiedRabbit;
import baguchan.earthmobsmod.registry.ModBlocks;
import baguchan.earthmobsmod.registry.ModDamageSource;
import baguchan.earthmobsmod.registry.ModEntities;
import com.mojang.serialization.DynamicOps;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="earthmobsmod")
public class CommonEvents {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ShadowCapability.class);
    }

    @SubscribeEvent
    public static void addSpawn(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof Villager) {
            Villager abstractVillager = (Villager)event.getEntity();
            abstractVillager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)abstractVillager, ZombifiedRabbit.class, 10.0f, (double)0.65f, (double)0.7f));
        }
        if (event.getEntity() instanceof WanderingTrader) {
            WanderingTrader wanderingTraderEntity = (WanderingTrader)event.getEntity();
            wanderingTraderEntity.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)wanderingTraderEntity, ZombifiedRabbit.class, 10.0f, (double)0.65f, (double)0.7f));
        }
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("earthmobsmod", "shadow"), (ICapabilityProvider)new ShadowCapability());
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(MobSpawnEvent.PositionCheck event) {
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPattern.BlockPatternMatch blockpattern$blockpatternmatch1;
        Direction direction;
        InteractionHand hand = event.getHand();
        ItemStack itemStack = event.getEntity().m_21120_(hand);
        BlockPos pos = event.getPos();
        Level level = event.getEntity().m_9236_();
        if (itemStack.m_41720_() instanceof ShearsItem && event.getEntity().m_9236_().m_8055_(pos).m_60734_() == Blocks.f_50186_ && (direction = event.getHitVec().m_82434_()) != Direction.DOWN && direction != Direction.UP) {
            itemStack.m_41622_(1, (LivingEntity)event.getEntity(), p_29910_ -> p_29910_.m_21190_(hand));
            level.m_5594_(null, pos, SoundEvents.f_12296_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7731_(pos, (BlockState)((Block)ModBlocks.CARVED_MELON.get()).m_49966_().m_61124_((Property)CarvedMelonBlock.FACING, (Comparable)direction), 2);
            event.setUseItem(Event.Result.ALLOW);
        }
        if (itemStack.m_150930_(Blocks.f_50143_.m_5456_()) && (blockpattern$blockpatternmatch1 = CommonEvents.getOrCreateFurnaceGolemBase().m_61184_((LevelReader)level, pos.m_121945_(event.getFace()))) != null) {
            FurnaceGolem irongolem = (FurnaceGolem)((EntityType)ModEntities.FURNACE_GOLEM.get()).m_20615_(level);
            if (irongolem != null) {
                CommonEvents.spawnGolemInWorld(level, blockpattern$blockpatternmatch1, (Entity)irongolem, blockpattern$blockpatternmatch1.m_61229_(1, 2, 0).m_61176_());
            }
            if (!event.getEntity().m_7500_()) {
                itemStack.m_41774_(1);
            }
            event.getEntity().m_6674_(hand);
            event.setCanceled(true);
        }
    }

    public static void clearPatternBlocks(Level p_249604_, BlockPattern.BlockPatternMatch p_251190_) {
        for (int i = 0; i < p_251190_.m_155970_(); ++i) {
            for (int j = 0; j < p_251190_.m_155971_(); ++j) {
                BlockInWorld blockinworld = p_251190_.m_61229_(i, j, 0);
                p_249604_.m_7731_(blockinworld.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                p_249604_.m_46796_(2001, blockinworld.m_61176_(), Block.m_49956_((BlockState)blockinworld.m_61168_()));
            }
        }
    }

    public static void updatePatternBlocks(Level p_248711_, BlockPattern.BlockPatternMatch p_251935_) {
        for (int i = 0; i < p_251935_.m_155970_(); ++i) {
            for (int j = 0; j < p_251935_.m_155971_(); ++j) {
                BlockInWorld blockinworld = p_251935_.m_61229_(i, j, 0);
                p_248711_.m_6289_(blockinworld.m_61176_(), Blocks.f_50016_);
            }
        }
    }

    private static BlockPattern getOrCreateFurnaceGolemBase() {
        return BlockPatternBuilder.m_61243_().m_61247_(new String[]{"   ", "SFS", " # "}).m_61244_('#', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50075_))).m_61244_('F', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50620_))).m_61244_('S', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)Blocks.f_50470_))).m_61249_();
    }

    @SubscribeEvent
    public static void onUpdate(LivingEvent.LivingTickEvent event) {
        event.getEntity().getCapability(EarthMobsMod.SHADOW_CAP).ifPresent(shadowCapability -> shadowCapability.tick(event.getEntity()));
    }

    @SubscribeEvent
    public static void onLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Pig) {
            Pig pig = (Pig)entity;
            if (event.getEntity().m_6095_() != ModEntities.ZOMBIFIED_PIG.get()) {
                ZombifiedPig zombifiedpig = (ZombifiedPig)((EntityType)ModEntities.ZOMBIFIED_PIG.get()).m_20615_(event.getEntity().m_9236_());
                zombifiedpig.m_7678_(pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), pig.m_146908_(), pig.m_146909_());
                zombifiedpig.m_21557_(pig.m_21525_());
                zombifiedpig.m_6863_(pig.m_6162_());
                if (pig.m_8077_()) {
                    zombifiedpig.m_6593_(pig.m_7770_());
                    zombifiedpig.m_20340_(pig.m_20151_());
                }
                zombifiedpig.m_21530_();
                ForgeEventFactory.onLivingConvert((LivingEntity)pig, (LivingEntity)zombifiedpig);
                event.getEntity().m_9236_().m_7967_((Entity)zombifiedpig);
                pig.m_146870_();
                event.setCanceled(true);
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKill(LivingDeathEvent event) {
        Rabbit rabbit;
        LivingEntity living = event.getEntity();
        Level level = event.getEntity().m_9236_();
        if ((event.getSource().m_7640_() instanceof Zombie || event.getSource().m_7640_() instanceof ZombifiedRabbit) && living instanceof Rabbit) {
            rabbit = (Rabbit)living;
            if (!(living instanceof Enemy) && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ZombifiedRabbit zombierabbit = (ZombifiedRabbit)rabbit.m_21406_((EntityType)ModEntities.ZOMBIFIED_RABBIT.get(), false);
                if (zombierabbit != null) {
                    zombierabbit.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(zombierabbit.m_20183_()), MobSpawnType.CONVERSION, null, null);
                    zombierabbit.m_28464_(rabbit.m_28554_());
                    ForgeEventFactory.onLivingConvert((LivingEntity)rabbit, (LivingEntity)zombierabbit);
                    if (!rabbit.m_20067_()) {
                        level.m_5898_((Player)null, 1026, rabbit.m_20183_(), 0);
                    }
                }
            }
        }
        if (event.getSource().m_276093_(ModDamageSource.ZOMBIFIED)) {
            if (living instanceof Rabbit) {
                ZombifiedRabbit zombifiedRabbit;
                rabbit = (Rabbit)living;
                if (!(living instanceof Enemy) && (zombifiedRabbit = (ZombifiedRabbit)rabbit.m_21406_((EntityType)ModEntities.ZOMBIFIED_RABBIT.get(), false)) != null) {
                    zombifiedRabbit.m_28464_(rabbit.m_28554_());
                    if (!rabbit.m_20067_()) {
                        level.m_5898_((Player)null, 1026, rabbit.m_20183_(), 0);
                    }
                }
            }
            if (living instanceof Villager) {
                ZombieVillager zombieVillager;
                Villager villager = (Villager)living;
                if (!(living instanceof Enemy) && (zombieVillager = (ZombieVillager)villager.m_21406_(EntityType.f_20530_, false)) != null) {
                    zombieVillager.m_28464_(villager.m_28554_());
                    zombieVillager.m_34375_(villager.m_7141_());
                    zombieVillager.m_34373_(villager.m_7809_());
                    zombieVillager.m_34391_((Tag)villager.m_35517_().m_262795_((DynamicOps)NbtOps.f_128958_));
                    zombieVillager.m_34411_(villager.m_6616_().m_45388_());
                    if (!villager.m_20067_()) {
                        level.m_5898_((Player)null, 1026, villager.m_20183_(), 0);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        event.getEntity().getCapability(EarthMobsMod.SHADOW_CAP).ifPresent(shadowCapability -> {
            if (shadowCapability.getPercentBoost() >= 0.5f && !event.getSource().m_269533_(DamageTypeTags.f_268490_) && !event.getSource().m_269533_(DamageTypeTags.f_268415_) && !event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                event.setAmount(event.getAmount() * (1.0f - shadowCapability.getPercentBoost()));
                if (shadowCapability.getPercentBoost() > 0.9f) {
                    event.setCanceled(true);
                }
            }
        });
    }

    @SubscribeEvent
    public static void onLivingKnockback(LivingKnockBackEvent event) {
        event.getEntity().getCapability(EarthMobsMod.SHADOW_CAP).ifPresent(shadowCapability -> {
            if (shadowCapability.getPercentBoost() >= 0.5f) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void initSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        ServerLevelAccessor serverLevelAccessor = event.getLevel();
        if (entity instanceof IMoss) {
            IMoss moss = (IMoss)entity;
            if (serverLevelAccessor.m_204166_(BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ())).m_203656_(Tags.Biomes.IS_SWAMP)) {
                moss.setMoss(true);
            }
        }
        if (entity instanceof IMuddy) {
            IMuddy muddy = (IMuddy)entity;
            if (serverLevelAccessor.m_204166_(BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ())).m_203656_(Tags.Biomes.IS_SWAMP)) {
                muddy.setMuddy(true);
            }
        }
    }

    private static void spawnGolemInWorld(Level p_249110_, BlockPattern.BlockPatternMatch p_251293_, Entity p_251251_, BlockPos p_251189_) {
        CommonEvents.clearPatternBlocks(p_249110_, p_251293_);
        p_251251_.m_7678_((double)p_251189_.m_123341_() + 0.5, (double)p_251189_.m_123342_() + 0.05, (double)p_251189_.m_123343_() + 0.5, 0.0f, 0.0f);
        p_249110_.m_7967_(p_251251_);
        for (ServerPlayer serverplayer : p_249110_.m_45976_(ServerPlayer.class, p_251251_.m_20191_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverplayer, p_251251_);
        }
        CommonEvents.updatePatternBlocks(p_249110_, p_251293_);
    }
}

