/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.goal.RangedAndMeleeAttack;
import baguchan.earthmobsmod.entity.projectile.BoneShard;
import baguchan.earthmobsmod.registry.ModEntities;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class BoneSpider
extends Spider
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_STRAY_CONVERSION_ID = SynchedEntityData.m_135353_(BoneSpider.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int inPowderSnowTime;
    private int conversionTime;

    public BoneSpider(EntityType<? extends BoneSpider> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.f_21364_ = 10;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_STRAY_CONVERSION_ID, (Object)false);
    }

    public static AttributeSupplier.Builder m_33815_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 18.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new BoneSpiderAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new SpiderTargetGoal<Player>(this, Player.class));
        this.f_21346_.m_25352_(3, new SpiderTargetGoal<IronGolem>(this, IronGolem.class));
    }

    public boolean isFreezeConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_STRAY_CONVERSION_ID);
    }

    public void setFreezeConverting(boolean p_149843_) {
        this.f_19804_.m_135381_(DATA_STRAY_CONVERSION_ID, (Object)p_149843_);
    }

    public boolean isShaking() {
        return this.isFreezeConverting();
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && !this.m_21525_()) {
            if (this.isFreezeConverting()) {
                --this.conversionTime;
                if (this.conversionTime < 0) {
                    this.doFreezeConversion();
                }
            } else if (this.f_146808_) {
                ++this.inPowderSnowTime;
                if (this.inPowderSnowTime >= 140) {
                    this.startFreezeConversion(300);
                }
            } else {
                this.inPowderSnowTime = -1;
            }
        }
        super.m_8119_();
    }

    public void m_7380_(CompoundTag p_149836_) {
        super.m_7380_(p_149836_);
        p_149836_.m_128405_("StrayConversionTime", this.isFreezeConverting() ? this.conversionTime : -1);
    }

    public void m_7378_(CompoundTag p_149833_) {
        super.m_7378_(p_149833_);
        if (p_149833_.m_128425_("StrayConversionTime", 99) && p_149833_.m_128451_("StrayConversionTime") > -1) {
            this.startFreezeConversion(p_149833_.m_128451_("StrayConversionTime"));
        }
    }

    public void startFreezeConversion(int p_149831_) {
        this.conversionTime = p_149831_;
        this.f_19804_.m_135381_(DATA_STRAY_CONVERSION_ID, (Object)true);
    }

    protected void doFreezeConversion() {
        this.m_21406_((EntityType)ModEntities.STRAY_BONE_SPIDER.get(), true);
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_((Player)null, 1048, this.m_20183_(), 0);
        }
    }

    public boolean m_142079_() {
        return false;
    }

    public boolean m_21222_() {
        return true;
    }

    public void m_6504_(LivingEntity p_29912_, float p_29913_) {
        BoneShard bone = new BoneShard(this.m_9236_(), (LivingEntity)this);
        double d1 = p_29912_.m_20185_() - this.m_20185_();
        double d2 = p_29912_.m_20188_() - this.m_20188_();
        double d3 = p_29912_.m_20189_() - this.m_20189_();
        bone.m_6686_(d1, d2, d3, 1.4f, 2.0f + p_29913_);
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            for (MobEffectInstance mobEffectInstance : this.m_21220_()) {
                bone.addEffect(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_19557_() / 4, 0));
            }
        }
        this.m_9236_().m_7967_((Entity)bone);
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.6f : 1.0f;
    }

    static class BoneSpiderAttackGoal
    extends RangedAndMeleeAttack {
        private final BoneSpider spider;

        public BoneSpiderAttackGoal(BoneSpider p_32247_) {
            super(p_32247_, 1.0, 40, 80, 14.0f);
            this.spider = p_32247_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.attackTime == 15) {
                this.spider.m_5496_(SoundEvents.f_12098_, this.spider.m_6121_(), 0.4f / (this.spider.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            float f = this.mob.m_213856_();
            if (f >= 0.5f && this.mob.m_217043_().m_188503_(100) == 0) {
                this.mob.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        @Override
        protected double getAttackReachSqr(LivingEntity p_33825_) {
            return 4.0f + p_33825_.m_20205_();
        }
    }

    static class SpiderTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        public SpiderTargetGoal(Spider p_33832_, Class<T> p_33833_) {
            super((Mob)p_33832_, p_33833_, true);
        }

        public boolean m_8036_() {
            float f = this.f_26135_.m_213856_();
            return f >= 0.5f ? false : super.m_8036_();
        }
    }
}

