/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.phys.Vec3;

public class BoulderingDrowned
extends Drowned {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BoulderingDrowned.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected final WaterBoundPathNavigation waterNavigation;
    protected final WallClimberNavigation groundNavigation;
    boolean searchingForLand;

    public BoulderingDrowned(EntityType<? extends BoulderingDrowned> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, p_34272_);
        this.groundNavigation = new WallClimberNavigation((Mob)this, p_34272_);
    }

    public static AttributeSupplier.Builder m_34328_() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.22f).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22278_, 0.15).m_22266_(Attributes.f_22287_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    boolean m_32392_() {
        if (this.searchingForLand) {
            return true;
        }
        LivingEntity livingentity = this.m_5448_();
        return livingentity != null && livingentity.m_20069_();
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.m_32392_()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    protected void m_213945_(RandomSource p_218953_, DifficultyInstance p_218954_) {
        if ((double)p_218953_.m_188501_() > 0.9) {
            int i = p_218953_.m_188503_(16);
            if (i < 10) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42713_);
                HashMap map = Maps.newHashMap();
                map.put(Enchantments.f_44957_, 1);
                EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack);
                this.m_8061_(EquipmentSlot.MAINHAND, stack);
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
            }
        }
    }

    public static boolean checkBoulderingDrownedSpawnRules(EntityType<BoulderingDrowned> p_32350_, ServerLevelAccessor p_32351_, MobSpawnType p_32352_, BlockPos p_32353_, RandomSource p_32354_) {
        boolean flag;
        if (!p_32351_.m_6425_(p_32353_.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        Holder holder = p_32351_.m_204166_(p_32353_);
        boolean bl = flag = p_32351_.m_46791_() != Difficulty.PEACEFUL && BoulderingDrowned.m_219009_((ServerLevelAccessor)p_32351_, (BlockPos)p_32353_, (RandomSource)p_32354_) && (p_32352_ == MobSpawnType.SPAWNER || p_32351_.m_6425_(p_32353_).m_205070_(FluidTags.f_13131_));
        if (!holder.m_203565_(Biomes.f_48208_) && !holder.m_203565_(Biomes.f_48212_)) {
            return p_32354_.m_188503_(40) == 0 && BoulderingDrowned.m_32366_((LevelAccessor)p_32351_, p_32353_) && flag;
        }
        return p_32354_.m_188503_(15) == 0 && flag;
    }

    private static boolean m_32366_(LevelAccessor p_32367_, BlockPos p_32368_) {
        return p_32368_.m_123342_() < p_32367_.m_5736_() - 5;
    }

    public void m_6504_(LivingEntity p_32356_, float p_32357_) {
        if (this.m_20280_((Entity)p_32356_) < 42.0) {
            int j = EnchantmentHelper.m_44932_((ItemStack)this.m_21205_());
            int k = EnchantmentHelper.m_44932_((ItemStack)this.m_21206_());
            if (j > 0 || k > 0) {
                double f1 = p_32356_.m_20185_() - this.m_20185_();
                double f2 = p_32356_.m_20186_() - this.m_20186_();
                double f3 = p_32356_.m_20189_() - this.m_20189_();
                float f4 = Mth.m_14116_((float)((float)(f1 * f1 + f2 * f2 + f3 * f3)));
                float f5 = 3.0f * ((1.0f + (float)j) / 4.0f);
                this.m_5997_(f1 *= (double)(f5 / f4), f2 *= (double)(f5 / f4), f3 *= (double)(f5 / f4));
                this.startAutoSpinAttack(30);
                if (this.m_20096_()) {
                    float f6 = 1.1999999f;
                    this.m_6478_(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                }
                SoundEvent soundevent = j >= 3 || k >= 3 ? SoundEvents.f_12519_ : (j == 2 || k == 2 ? SoundEvents.f_12518_ : SoundEvents.f_12517_);
                this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        } else {
            super.m_6504_(p_32356_, p_32357_);
        }
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.m_6109_() && this.m_20069_() && this.m_32392_()) {
            this.m_19920_(0.0175f, p_32394_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(p_32394_);
        }
    }

    public void startAutoSpinAttack(int p_204080_) {
        this.f_20938_ = p_204080_;
        if (!this.m_9236_().f_46443_) {
            this.m_21155_(4, true);
        }
    }

    protected void m_6727_(LivingEntity p_36355_) {
        p_36355_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 9.0f);
    }
}

