/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.entity.IPlantMob;
import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;

public class CluckShroom
extends Chicken
implements Shearable,
IForgeShearable,
IPlantMob {
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.m_135353_(CluckShroom.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private UUID lastLightningBoltUUID;

    public CluckShroom(EntityType<? extends CluckShroom> p_28236_, Level p_28237_) {
        super(p_28236_, p_28237_);
    }

    @Nullable
    public ItemEntity m_19998_(ItemLike p_19999_) {
        if (p_19999_.m_5456_() == Items.f_42521_) {
            p_19999_ = (ItemLike)ModItems.SMELLY_EGG.get();
        }
        return super.m_19998_(p_19999_);
    }

    public static boolean checkCluckShroomSpawnRules(EntityType<CluckShroom> p_28949_, LevelAccessor p_28950_, MobSpawnType p_28951_, BlockPos p_28952_, RandomSource p_28953_) {
        return p_28950_.m_8055_(p_28952_.m_7495_()).m_60713_(Blocks.f_50195_) && p_28950_.m_45524_(p_28952_, 0) > 8;
    }

    public float m_5610_(BlockPos p_28933_, LevelReader p_28934_) {
        return p_28934_.m_8055_(p_28933_.m_7495_()).m_60713_(Blocks.f_50195_) ? 10.0f : p_28934_.m_220419_(p_28933_) - 0.5f;
    }

    public void m_8038_(ServerLevel p_28921_, LightningBolt p_28922_) {
        UUID uuid = p_28922_.m_20148_();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setCluckShroomType(this.getCluckShroomType() == CluckShroomType.RED ? CluckShroomType.BROWN : CluckShroomType.RED);
            this.lastLightningBoltUUID = uuid;
            this.m_5496_(SoundEvents.f_12616_, 2.0f, 1.0f);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TYPE, (Object)CluckShroomType.RED.type);
    }

    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        return this.shearInternal(player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS);
    }

    public void m_5851_(SoundSource p_28924_) {
        this.shearInternal(p_28924_).forEach(s -> this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), s)));
    }

    private List<ItemStack> shearInternal(SoundSource p_28924_) {
        this.m_9236_().m_6269_((Player)null, (Entity)this, SoundEvents.f_12075_, p_28924_, 1.0f, 1.0f);
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.m_146870_();
            Chicken chickin = (Chicken)EntityType.f_20555_.m_20615_(this.m_9236_());
            chickin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            chickin.m_21153_(this.m_21223_());
            chickin.f_20883_ = this.f_20883_;
            if (this.m_8077_()) {
                chickin.m_6593_(this.m_7770_());
                chickin.m_20340_(this.m_20151_());
            }
            if (this.m_21532_()) {
                chickin.m_21530_();
            }
            chickin.m_20331_(this.m_20147_());
            this.m_9236_().m_7967_((Entity)chickin);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < 5; ++i) {
                items.add(new ItemStack((ItemLike)this.getCluckShroomType().blockState.m_60734_()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_7380_(CompoundTag p_28944_) {
        super.m_7380_(p_28944_);
        p_28944_.m_128359_("Type", this.getCluckShroomType().type);
    }

    public void m_7378_(CompoundTag p_28936_) {
        super.m_7378_(p_28936_);
        this.setCluckShroomType(CluckShroomType.byType(p_28936_.m_128461_("Type")));
    }

    public void setCluckShroomType(CluckShroomType p_28929_) {
        this.f_19804_.m_135381_(DATA_TYPE, (Object)p_28929_.type);
    }

    public CluckShroomType getCluckShroomType() {
        return CluckShroomType.byType((String)this.f_19804_.m_135370_(DATA_TYPE));
    }

    public CluckShroom getBreedOffspring(ServerLevel p_148942_, AgeableMob p_148943_) {
        CluckShroom mushroomchickin = (CluckShroom)((EntityType)ModEntities.CLUCK_SHROOM.get()).m_20615_((Level)p_148942_);
        mushroomchickin.setCluckShroomType(this.getOffspringType((CluckShroom)p_148943_));
        return mushroomchickin;
    }

    private CluckShroomType getOffspringType(CluckShroom p_28931_) {
        CluckShroomType mushroomchickin$mushroomtype1;
        CluckShroomType mushroomchickin$mushroomtype = this.getCluckShroomType();
        CluckShroomType mushroomchickin$mushroomtype2 = mushroomchickin$mushroomtype == (mushroomchickin$mushroomtype1 = p_28931_.getCluckShroomType()) && this.f_19796_.m_188503_(1024) == 0 ? (mushroomchickin$mushroomtype == CluckShroomType.BROWN ? CluckShroomType.RED : CluckShroomType.BROWN) : (this.f_19796_.m_188499_() ? mushroomchickin$mushroomtype : mushroomchickin$mushroomtype1);
        return mushroomchickin$mushroomtype2;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    @Override
    public Block getPlant() {
        return this.getCluckShroomType().blockState.m_60734_();
    }

    public static enum CluckShroomType {
        RED("red", Blocks.f_50073_.m_49966_()),
        BROWN("brown", Blocks.f_50072_.m_49966_());

        final String type;
        final BlockState blockState;

        private CluckShroomType(String p_28967_, BlockState p_28968_) {
            this.type = p_28967_;
            this.blockState = p_28968_;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        static CluckShroomType byType(String p_28977_) {
            for (CluckShroomType mushroomchickin$mushroomtype : CluckShroomType.values()) {
                if (!mushroomchickin$mushroomtype.type.equals(p_28977_)) continue;
                return mushroomchickin$mushroomtype;
            }
            return RED;
        }
    }
}

