/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModDamageSource;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FurnaceGolem
extends AbstractGolem {
    private static final EntityDataAccessor<Boolean> FURNACE_ACTIVE = SynchedEntityData.m_135353_(FurnaceGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackAnimationTick;
    private int activeTime;

    public FurnaceGolem(EntityType<? extends AbstractGolem> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.m_274367_(1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FURNACE_ACTIVE, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(2, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.6, false));
        this.f_21345_.m_25352_(4, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, p_28879_ -> p_28879_ instanceof Enemy && !(p_28879_ instanceof Creeper)));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 10.0);
    }

    protected int m_7302_(int p_28882_) {
        return p_28882_;
    }

    protected void m_7324_(Entity p_28839_) {
        if (p_28839_ instanceof Enemy && !(p_28839_ instanceof Creeper)) {
            if (this.m_217043_().m_188503_(20) == 0) {
                this.m_6710_((LivingEntity)p_28839_);
            }
            if (!this.isFurnaceActive()) {
                this.m_5496_(SoundEvents.f_11937_, 2.0f, 1.0f);
                this.setFurnaceActive(true);
            }
        }
        super.m_7324_(p_28839_);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
        if (this.m_6084_() && this.isFurnaceActive()) {
            ++this.activeTime;
            this.checkFurnaceAttack(this.m_20191_(), this.m_20191_().m_82400_(2.0));
            if (this.activeTime >= 400 && this.m_20096_()) {
                this.m_5496_(SoundEvents.f_11937_, 2.0f, 1.0f);
                this.setFurnaceActive(false);
                this.activeTime = 0;
            }
        }
        if (this.m_20184_().m_165925_() > 2.500000277905201E-7 && this.f_19796_.m_188503_(5) == 0) {
            int i = Mth.m_14107_((double)this.m_20185_());
            int j = Mth.m_14107_((double)(this.m_20186_() - (double)0.2f));
            int k = Mth.m_14107_((double)this.m_20189_());
            BlockPos pos = new BlockPos(i, j, k);
            BlockState blockstate = this.m_9236_().m_8055_(pos);
            if (!blockstate.m_60795_()) {
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate).setPos(pos), this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_(), 4.0 * ((double)this.f_19796_.m_188501_() - 0.5), 0.5, ((double)this.f_19796_.m_188501_() - 0.5) * 4.0);
            }
        }
    }

    protected void checkFurnaceAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.m_82367_(p_21073_);
        List list = this.m_9236_().m_45933_((Entity)this, aabb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity == this) continue;
                this.furnaceAttack(entity);
            }
        }
    }

    public void furnaceAttack(Entity p_36347_) {
        if (p_36347_ instanceof Enemy && !(p_36347_ instanceof Creeper) && p_36347_.m_6097_() && !this.m_7307_(p_36347_)) {
            p_36347_.m_6469_(this.m_269291_().m_269298_(ModDamageSource.BURNING, (Entity)this), 6.0f);
            p_36347_.m_20254_(5);
        }
    }

    public boolean m_6549_(EntityType<?> p_28851_) {
        if (p_28851_ == EntityType.f_20532_) {
            return false;
        }
        return p_28851_ == EntityType.f_20558_ ? false : super.m_6549_(p_28851_);
    }

    public void m_7380_(CompoundTag p_28867_) {
        super.m_7380_(p_28867_);
    }

    public void m_7378_(CompoundTag p_28857_) {
        super.m_7378_(p_28857_);
    }

    public void setFurnaceActive(boolean active) {
        this.f_19804_.m_135381_(FURNACE_ACTIVE, (Object)active);
    }

    public boolean isFurnaceActive() {
        return (Boolean)this.f_19804_.m_135370_(FURNACE_ACTIVE);
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity p_28837_) {
        this.attackAnimationTick = 10;
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = this.getAttackDamage();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        boolean flag = p_28837_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f1);
        if (flag) {
            double d2;
            if (p_28837_ instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)p_28837_;
                d2 = livingentity.m_21133_(Attributes.f_22278_);
            } else {
                d2 = 0.0;
            }
            double d0 = d2;
            double d1 = Math.max(0.0, 1.0 - d0);
            p_28837_.m_20256_(p_28837_.m_20184_().m_82520_(0.0, (double)0.4f * d1, 0.0));
            this.m_19970_((LivingEntity)this, p_28837_);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    public boolean m_6469_(DamageSource p_28848_, float p_28849_) {
        Crackiness irongolem$crackiness = this.getCrackiness();
        boolean flag = super.m_6469_(p_28848_, p_28849_);
        if (flag && this.getCrackiness() != irongolem$crackiness) {
            this.m_5496_(SoundEvents.f_12058_, 1.0f, 1.0f);
        }
        return flag;
    }

    public Crackiness getCrackiness() {
        return Crackiness.byFraction(this.m_21223_() / this.m_21233_());
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    protected SoundEvent m_7975_(DamageSource p_28872_) {
        return SoundEvents.f_12008_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected InteractionResult m_6071_(Player p_28861_, InteractionHand p_28862_) {
        ItemStack itemstack = p_28861_.m_21120_(p_28862_);
        if (!itemstack.m_150930_(Items.f_41994_)) {
            return InteractionResult.PASS;
        }
        float f = this.m_21223_();
        this.m_5634_(20.0f);
        if (this.m_21223_() == f) {
            return InteractionResult.PASS;
        }
        float f1 = 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f;
        this.m_5496_(SoundEvents.f_12009_, 1.0f, f1);
        if (!p_28861_.m_150110_().f_35937_) {
            itemstack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
    }

    protected void m_7355_(BlockPos p_28864_, BlockState p_28865_) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    public void m_6667_(DamageSource p_28846_) {
        super.m_6667_(p_28846_);
    }

    public boolean m_6914_(LevelReader p_28853_) {
        BlockPos blockpos = this.m_20183_();
        BlockPos blockpos1 = blockpos.m_7495_();
        BlockState blockstate = p_28853_.m_8055_(blockpos1);
        if (!blockstate.m_60634_((BlockGetter)p_28853_, blockpos1, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 3; ++i) {
            BlockState blockstate1;
            BlockPos blockpos2 = blockpos.m_6630_(i);
            if (NaturalSpawner.m_47056_((BlockGetter)p_28853_, (BlockPos)blockpos2, (BlockState)(blockstate1 = p_28853_.m_8055_(blockpos2)), (FluidState)blockstate1.m_60819_(), (EntityType)EntityType.f_20460_)) continue;
            return false;
        }
        return NaturalSpawner.m_47056_((BlockGetter)p_28853_, (BlockPos)blockpos, (BlockState)p_28853_.m_8055_(blockpos), (FluidState)Fluids.f_76191_.m_76145_(), (EntityType)EntityType.f_20460_) && p_28853_.m_45784_((Entity)this);
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public static enum Crackiness {
        NONE(1.0f),
        LOW(0.75f),
        MEDIUM(0.5f),
        HIGH(0.25f);

        private static final List<Crackiness> BY_DAMAGE;
        private final float fraction;

        private Crackiness(float p_28900_) {
            this.fraction = p_28900_;
        }

        public static Crackiness byFraction(float p_28902_) {
            for (Crackiness irongolem$crackiness : BY_DAMAGE) {
                if (!(p_28902_ < irongolem$crackiness.fraction)) continue;
                return irongolem$crackiness;
            }
            return NONE;
        }

        static {
            BY_DAMAGE = (List)Stream.of(Crackiness.values()).sorted(Comparator.comparingDouble(p_28904_ -> p_28904_.fraction)).collect(ImmutableList.toImmutableList());
        }
    }
}

