/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import baguchan.earthmobsmod.registry.ModItems;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HornedSheep
extends Sheep {
    private static final EntityDataAccessor<Boolean> DATA_HAS_HORN = SynchedEntityData.m_135353_(HornedSheep.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float aggressiveScale;
    private float aggressiveScaleOld;

    public HornedSheep(EntityType<? extends Sheep> p_29806_, Level p_29807_) {
        super(p_29806_, p_29807_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HAS_HORN, (Object)true);
    }

    protected void m_8099_() {
        this.f_29803_ = new EatBlockGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.3f){

            public boolean m_8036_() {
                return !HornedSheep.this.hasHorn() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !HornedSheep.this.hasHorn() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal<Goat>((PathfinderMob)this, Goat.class, 12.0f, 1.3, 1.35){

            public boolean m_8036_() {
                return !HornedSheep.this.hasHorn() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !HornedSheep.this.hasHorn() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new HornedSheepAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)this.f_29803_);
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return super.m_8036_() && HornedSheep.this.hasHorn();
            }

            public boolean m_8045_() {
                return super.m_8045_() && HornedSheep.this.hasHorn();
            }
        }.m_26044_(new Class[0]));
    }

    public boolean hasHorn() {
        return (Boolean)this.f_19804_.m_135370_(DATA_HAS_HORN);
    }

    public boolean dropHorn() {
        boolean flag = this.hasHorn();
        if (!flag) {
            return false;
        }
        this.f_19804_.m_135381_(DATA_HAS_HORN, (Object)false);
        Vec3 vec3 = this.m_20182_();
        ItemStack itemstack = this.createHorn();
        double d0 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
        double d1 = Mth.m_216283_((RandomSource)this.f_19796_, (float)0.3f, (float)0.7f);
        double d2 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
        ItemEntity itementity = new ItemEntity(this.m_9236_(), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), itemstack, d0, d1, d2);
        this.m_9236_().m_7967_((Entity)itementity);
        ItemEntity itementity2 = new ItemEntity(this.m_9236_(), vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), itemstack, d0, d1, d2);
        this.m_9236_().m_7967_((Entity)itementity2);
        return true;
    }

    public ItemStack createHorn() {
        RandomSource randomsource = RandomSource.m_216335_((long)this.m_20148_().hashCode());
        TagKey tagkey = InstrumentTags.f_215856_;
        HolderSet.Named holderset = BuiltInRegistries.f_256896_.m_203561_(tagkey);
        return InstrumentItem.m_220107_((Item)((Item)ModItems.HORN_FLUTE.get()), (Holder)((Holder)holderset.m_213653_(randomsource).get()));
    }

    public void addHorns() {
        this.f_19804_.m_135381_(DATA_HAS_HORN, (Object)true);
    }

    public void m_7380_(CompoundTag p_149385_) {
        super.m_7380_(p_149385_);
        p_149385_.m_128379_("HasHorn", this.hasHorn());
    }

    public void m_7378_(CompoundTag p_149373_) {
        super.m_7378_(p_149373_);
        this.f_19804_.m_135381_(DATA_HAS_HORN, (Object)p_149373_.m_128471_("HasHorn"));
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            this.aggressiveScaleOld = this.aggressiveScale;
            this.aggressiveScale = this.m_5912_() ? Mth.m_14036_((float)(this.aggressiveScale + 0.2f), (float)0.0f, (float)1.0f) : Mth.m_14036_((float)(this.aggressiveScale - 0.2f), (float)0.0f, (float)1.0f);
        }
    }

    public float getAggressiveAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.aggressiveScaleOld, (float)this.aggressiveScale);
    }

    public static AttributeSupplier.Builder m_29873_() {
        return Sheep.m_29873_().m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, (double)0.9f);
    }

    public HornedSheep getBreedOffspring(ServerLevel p_149035_, AgeableMob p_149036_) {
        return (HornedSheep)((EntityType)ModEntities.HORNED_SHEEP.get()).m_20615_((Level)p_149035_);
    }

    public boolean m_6469_(DamageSource damagesource, float p_27568_) {
        Entity entity1 = damagesource.m_7639_();
        if (entity1 != null && entity1 instanceof LivingEntity) {
            this.m_6703_((LivingEntity)entity1);
        }
        return super.m_6469_(damagesource, p_27568_);
    }

    public static class HornedSheepAttackGoal
    extends Goal {
        private final HornedSheep hornedSheep;
        private boolean rushing = true;
        private BlockPos targetPos;
        private int rushTick;
        private int rushCooldowmTick;
        public int ticksUntilNextAttack;
        private boolean attack;

        public HornedSheepAttackGoal(HornedSheep hornedSheep) {
            this.hornedSheep = hornedSheep;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.hornedSheep.m_5448_();
            if (livingentity == null) {
                return false;
            }
            return livingentity.m_6084_();
        }

        public boolean m_8045_() {
            return this.hornedSheep.m_5448_() != null && this.hornedSheep.m_5448_().m_6084_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.targetPos = null;
            this.rushTick = 200;
            this.hornedSheep.m_21561_(true);
            this.rushing = true;
        }

        public void m_8041_() {
            super.m_8041_();
            this.attack = false;
            this.hornedSheep.m_21561_(false);
        }

        public void m_8037_() {
            LivingEntity livingentity = this.hornedSheep.m_5448_();
            if (livingentity != null) {
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                if (this.rushing) {
                    if (this.rushTick == 140) {
                        this.targetPos = livingentity.m_20183_();
                    }
                    if (this.rushTick <= 140) {
                        if (this.targetPos != null) {
                            this.hornedSheep.m_21563_().m_24950_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 30.0f, 30.0f);
                            this.hornedSheep.m_21566_().m_6849_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), 2.5);
                        }
                        if (this.hasRammedHornBreakingBlock(this.hornedSheep.m_9236_(), this.hornedSheep)) {
                            boolean flag = this.hornedSheep.dropHorn();
                            if (flag) {
                                this.hornedSheep.m_9236_().m_6269_((Player)null, (Entity)this.hornedSheep, SoundEvents.f_215698_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                            }
                            this.rushCooldowmTick = 200 + this.hornedSheep.f_19796_.m_188503_(200);
                            this.rushing = false;
                        }
                        if (this.hornedSheep.m_20182_().m_82509_((Position)this.targetPos.m_252807_(), 0.25)) {
                            this.rushCooldowmTick = 200 + this.hornedSheep.f_19796_.m_188503_(200);
                            this.rushing = false;
                        }
                    }
                    if (this.rushTick > 0) {
                        --this.rushTick;
                    }
                    if (this.rushing && this.rushTick <= 0 || this.attack && this.rushTick > 0) {
                        this.rushCooldowmTick = 200 + this.hornedSheep.f_19796_.m_188503_(200);
                        this.rushing = false;
                    }
                } else {
                    if (this.rushCooldowmTick > 0) {
                        --this.rushCooldowmTick;
                    }
                    if (this.rushCooldowmTick <= 0) {
                        this.rushing = true;
                        this.rushTick = 200;
                    }
                    this.hornedSheep.m_21573_().m_5624_((Entity)livingentity, (double)1.1f);
                }
                if (this.rushing && this.rushTick <= 140 || !this.rushing && this.ticksUntilNextAttack <= 0) {
                    this.checkAndPerformAttack(livingentity);
                }
            }
        }

        protected void checkAndPerformAttack(LivingEntity p_25557_) {
            double d0 = this.getAttackReachSqr(p_25557_);
            if (!(!this.hornedSheep.m_217066_(p_25557_) || this.attack && this.rushing)) {
                this.hornedSheep.m_6674_(InteractionHand.MAIN_HAND);
                if (!this.rushing) {
                    this.hornedSheep.m_7327_((Entity)p_25557_);
                    this.attack = true;
                } else {
                    int i = this.hornedSheep.m_21023_(MobEffects.f_19596_) ? this.hornedSheep.m_21124_(MobEffects.f_19596_).m_19564_() + 1 : 0;
                    int j = this.hornedSheep.m_21023_(MobEffects.f_19597_) ? this.hornedSheep.m_21124_(MobEffects.f_19597_).m_19564_() + 1 : 0;
                    float f = 0.25f * (float)(i - j);
                    float f1 = Mth.m_14036_((float)(this.hornedSheep.m_6113_() * 1.65f), (float)0.2f, (float)3.0f) + f;
                    float f2 = p_25557_.m_21275_(this.hornedSheep.m_269291_().m_269333_((LivingEntity)this.hornedSheep)) ? 0.5f : 1.0f;
                    p_25557_.m_147240_((double)(f2 * f1) * (double)(this.hornedSheep.m_6162_() ? 0.2f : 1.5f), this.hornedSheep.m_20185_() - p_25557_.m_20185_(), this.hornedSheep.m_20189_() - p_25557_.m_20189_());
                    p_25557_.m_6469_(this.hornedSheep.m_269291_().m_269333_((LivingEntity)this.hornedSheep), (float)this.hornedSheep.m_21133_(Attributes.f_22281_) + 2.0f);
                }
                this.ticksUntilNextAttack = 30;
            }
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            return this.hornedSheep.m_20205_() * 2.0f * this.hornedSheep.m_20205_() * 2.0f + p_25556_.m_20205_();
        }

        public boolean m_183429_() {
            return true;
        }

        private boolean hasRammedHornBreakingBlock(Level p_217363_, HornedSheep p_217364_) {
            Vec3 vec3 = p_217364_.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_();
            BlockPos blockpos = BlockPos.m_274446_((Position)p_217364_.m_20182_().m_82549_(vec3));
            return p_217363_.m_8055_(blockpos).m_204336_(BlockTags.f_215832_) || p_217363_.m_8055_(blockpos.m_7494_()).m_204336_(BlockTags.f_215832_);
        }
    }
}

