/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.entity;

import baguchan.earthmobsmod.registry.ModEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class ZombifiedRabbit
extends Rabbit
implements Enemy {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING_ID = SynchedEntityData.m_135353_(ZombifiedRabbit.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int conversionTime;
    @javax.annotation.Nullable
    private UUID conversionStarter;

    public ZombifiedRabbit(EntityType<? extends Rabbit> p_29656_, Level p_29657_) {
        super(p_29656_, p_29657_);
        this.f_21364_ = 3;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_148105_().stream().map(it -> it.m_26015_()).filter(it -> it instanceof PanicGoal || it instanceof AvoidEntityGoal).findFirst().ifPresent(goal -> this.f_21345_.m_25363_(goal));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING_ID, (Object)false);
    }

    public static AttributeSupplier.Builder m_29717_() {
        return Rabbit.m_29717_().m_22268_(Attributes.f_22276_, 8.0);
    }

    public void m_7380_(CompoundTag p_34397_) {
        super.m_7380_(p_34397_);
        p_34397_.m_128405_("ConversionTime", this.isConverting() ? this.conversionTime : -1);
        if (this.conversionStarter != null) {
            p_34397_.m_128362_("ConversionPlayer", this.conversionStarter);
        }
    }

    public void m_7378_(CompoundTag p_34387_) {
        super.m_7378_(p_34387_);
        if (p_34387_.m_128425_("ConversionTime", 99) && p_34387_.m_128451_("ConversionTime") > -1) {
            this.startConverting(p_34387_.m_128403_("ConversionPlayer") ? p_34387_.m_128342_("ConversionPlayer") : null, p_34387_.m_128451_("ConversionTime"));
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.isConverting()) {
            --this.conversionTime;
            if (this.conversionTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                this.conversionTime = timer;
            })) {
                this.finishConversion((ServerLevel)this.m_9236_());
            }
        }
        super.m_8119_();
    }

    public InteractionResult m_6071_(Player p_34394_, InteractionHand p_34395_) {
        ItemStack itemstack = p_34394_.m_21120_(p_34395_);
        if (itemstack.m_150930_(Items.f_42677_)) {
            if (this.m_21023_(MobEffects.f_19613_)) {
                if (!p_34394_.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.m_9236_().f_46443_) {
                    this.startConverting(p_34394_.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(p_34394_, p_34395_);
    }

    public boolean isConverting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING_ID);
    }

    private void startConverting(@javax.annotation.Nullable UUID p_34384_, int p_34385_) {
        this.conversionStarter = p_34384_;
        this.conversionTime = p_34385_;
        this.m_20088_().m_135381_(DATA_CONVERTING_ID, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, p_34385_, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    private void finishConversion(ServerLevel p_34399_) {
        Player player;
        Rabbit rabbit = (Rabbit)this.m_21406_(EntityType.f_20517_, false);
        rabbit.m_28464_(this.m_28554_());
        rabbit.m_6518_((ServerLevelAccessor)p_34399_, p_34399_.m_6436_(rabbit.m_20183_()), MobSpawnType.CONVERSION, (SpawnGroupData)null, (CompoundTag)null);
        if (this.conversionStarter == null || (player = p_34399_.m_46003_(this.conversionStarter)) instanceof ServerPlayer) {
            // empty if block
        }
        rabbit.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (!this.m_20067_()) {
            p_34399_.m_5898_((Player)null, 1027, this.m_20183_(), 0);
        }
        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)rabbit);
    }

    public void m_8107_() {
        boolean flag;
        if (this.m_6084_() && (flag = this.m_21527_())) {
            ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.m_20254_(8);
            }
        }
        super.m_8107_();
    }

    public void m_28464_(Rabbit.Variant p_262578_) {
        if (p_262578_ != Rabbit.Variant.EVIL) {
            this.m_21051_(Attributes.f_22284_).m_22100_(2.0);
            this.f_21345_.m_25352_(4, (Goal)new RabbitAttackGoal(this));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        }
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        super.m_28464_(p_262578_);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor p_219010_, BlockPos p_219011_, RandomSource p_219012_) {
        if (p_219010_.m_45517_(LightLayer.SKY, p_219011_) > p_219012_.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = p_219010_.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && p_219010_.m_45517_(LightLayer.BLOCK, p_219011_) > i) {
            return false;
        }
        int j = p_219010_.m_6018_().m_46470_() ? p_219010_.m_46849_(p_219011_, 10) : p_219010_.m_46803_(p_219011_);
        return j <= dimensiontype.m_223569_().m_214085_(p_219012_);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends ZombifiedRabbit> p_219014_, ServerLevelAccessor p_219015_, MobSpawnType p_219016_, BlockPos p_219017_, RandomSource p_219018_) {
        return p_219015_.m_8055_(p_219017_.m_7495_()).m_204336_(BlockTags.f_184234_) && p_219015_.m_46791_() != Difficulty.PEACEFUL && ZombifiedRabbit.isDarkEnoughToSpawn(p_219015_, p_219017_, p_219018_) && ZombifiedRabbit.m_217057_(p_219014_, (LevelAccessor)p_219015_, (MobSpawnType)p_219016_, (BlockPos)p_219017_, (RandomSource)p_219018_);
    }

    public boolean m_6785_(double p_27598_) {
        return true;
    }

    protected boolean m_8028_() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Rabbit m_142606_(ServerLevel p_149035_, AgeableMob p_149036_) {
        block2: {
            block3: {
                rabbit = (Rabbit)((EntityType)ModEntities.ZOMBIFIED_RABBIT.get()).m_20615_((Level)p_149035_);
                if (rabbit == null) break block2;
                rabbit$variant = ZombifiedRabbit.m_262482_((LevelAccessor)p_149035_, this.m_20183_());
                if (this.f_19796_.m_188503_(20) == 0) break block3;
                if (!(p_149036_ instanceof Rabbit)) ** GOTO lbl-1000
                rabbit1 = (Rabbit)p_149036_;
                if (this.f_19796_.m_188499_()) {
                    rabbit$variant = rabbit1.m_28554_();
                } else lbl-1000:
                // 2 sources

                {
                    rabbit$variant = this.m_28554_();
                }
            }
            rabbit.m_28464_(rabbit$variant);
        }
        return rabbit;
    }

    private static Rabbit.Variant m_262482_(LevelAccessor p_262699_, BlockPos p_262700_) {
        Holder holder = p_262699_.m_204166_(p_262700_);
        int i = p_262699_.m_213780_().m_188503_(100);
        if (holder.m_203656_(BiomeTags.f_263794_)) {
            return i < 80 ? Rabbit.Variant.WHITE : Rabbit.Variant.WHITE_SPLOTCHED;
        }
        if (holder.m_203656_(BiomeTags.f_263796_)) {
            return Rabbit.Variant.GOLD;
        }
        return i < 50 ? Rabbit.Variant.BROWN : (i < 90 ? Rabbit.Variant.SALT : Rabbit.Variant.BLACK);
    }

    static class RabbitAttackGoal
    extends MeleeAttackGoal {
        public RabbitAttackGoal(Rabbit p_29738_) {
            super((PathfinderMob)p_29738_, 1.4, true);
        }
    }
}

