/*
 * Decompiled with CFR 0.152.
 */
package baguchan.earthmobsmod.message;

import baguchan.earthmobsmod.api.IMoss;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class MossMessage {
    private final int entityId;
    private final boolean moss;

    public MossMessage(int entityId, boolean moss) {
        this.entityId = entityId;
        this.moss = moss;
    }

    public static void writeToPacket(MossMessage packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.entityId);
        buf.writeBoolean(packet.moss);
    }

    public static MossMessage readFromPacket(FriendlyByteBuf buf) {
        return new MossMessage(buf.readInt(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.get().enqueueWork(() -> {
                Entity entity = Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(this.entityId);
                if (entity instanceof IMoss) {
                    IMoss imoss = (IMoss)entity;
                    imoss.setMoss(this.moss);
                }
            });
        }
        context.get().setPacketHandled(true);
    }
}

