/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.base;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.mixin.client.AccessorClientAdvancements;

public class ClientAdvancements {
    private static boolean gotFirstAdvPacket = false;

    public static void onClientPacket() {
        if (!gotFirstAdvPacket) {
            ClientBookRegistry.INSTANCE.reload();
            gotFirstAdvPacket = true;
        } else {
            ClientBookRegistry.INSTANCE.reloadLocks(false);
        }
    }

    public static boolean hasDone(String advancement) {
        net.minecraft.client.multiplayer.ClientAdvancements cm;
        Advancement adv;
        ClientPacketListener conn;
        ResourceLocation id = ResourceLocation.m_135820_((String)advancement);
        if (id != null && (conn = Minecraft.m_91087_().m_91403_()) != null && (adv = (cm = conn.m_105145_()).m_104396_().m_139337_(id)) != null) {
            Map<Advancement, AdvancementProgress> progressMap = ((AccessorClientAdvancements)cm).getProgress();
            AdvancementProgress progress = progressMap.get(adv);
            return progress != null && progress.m_8193_();
        }
        return false;
    }

    public static void playerLogout() {
        gotFirstAdvPacket = false;
    }

    public static void sendBookToast(Book book) {
        ToastComponent gui = Minecraft.m_91087_().m_91300_();
        if (gui.m_94926_(LexiconToast.class, (Object)book) == null) {
            gui.m_94922_((Toast)new LexiconToast(book));
        }
    }

    public static class LexiconToast
    implements Toast {
        private final Book book;

        public LexiconToast(Book book) {
            this.book = book;
        }

        @NotNull
        public Book getToken() {
            return this.book;
        }

        @NotNull
        public Toast.Visibility m_7172_(GuiGraphics graphics, ToastComponent toastGui, long delta) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)f_94893_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.m_280218_(f_94893_, 0, 0, 0, 32, 160, 32);
            Font font = toastGui.m_94929_().f_91062_;
            graphics.m_280614_(font, (Component)Component.m_237115_((String)this.book.name), 30, 7, -11534256, false);
            graphics.m_280614_(font, (Component)Component.m_237115_((String)"patchouli.gui.lexicon.toast.info"), 30, 17, -16777216, false);
            graphics.m_280480_(this.book.getBookItem(), 8, 8);
            graphics.m_280370_(font, this.book.getBookItem(), 8, 8);
            return delta >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
    }
}

