/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import tanukidecor.TanukiDecor;
import tanukidecor.util.MultiblockHandler;

public final class TDUnitTests {
    private static final StringBuilder debug = new StringBuilder();

    public static void run() {
        TDUnitTests.runMultiblockHandlerTests();
    }

    private static void runMultiblockHandlerTests() {
        MultiblockHandler handler = MultiblockHandler.MULTIBLOCK_3X3X3;
        Direction dir = MultiblockHandler.ORIGIN_DIRECTION;
        BlockPos center = BlockPos.f_121853_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        TDUnitTests.debug("Testing helper methods");
        TDUnitTests.debug("[MultiblockHandler#getCenterPos]");
        pos.m_122190_((Vec3i)center);
        TDUnitTests.testEquals("assert center from 0, 0, 0", center, MultiblockHandler.getCenterPos((BlockPos)pos, new Vec3i(0, 0, 0), dir));
        pos.m_175306_((Vec3i)center, (Vec3i)new BlockPos(1, -1, -1));
        TDUnitTests.testEquals("assert center from -1, -1, -1", center, MultiblockHandler.getCenterPos((BlockPos)pos, new Vec3i(-1, -1, -1), dir));
        pos.m_175306_((Vec3i)center, (Vec3i)new BlockPos(0, 0, -1));
        TDUnitTests.testEquals("assert center from 0, 0, -1", center, MultiblockHandler.getCenterPos((BlockPos)pos, new Vec3i(0, 0, -1), dir));
        pos.m_175306_((Vec3i)center, (Vec3i)new BlockPos(-1, 1, 0));
        TDUnitTests.testEquals("assert center from 1, 1, 0", center, MultiblockHandler.getCenterPos((BlockPos)pos, new Vec3i(1, 1, 0), dir));
        TDUnitTests.debug("============================");
        TDUnitTests.debug("Testing MultiblockHandler 3x3x3");
        TDUnitTests.debug("dimensions=" + handler.getDimensions());
        TDUnitTests.debug("bounds=" + handler.getBounds(dir));
        TDUnitTests.debug("boundsCenterPos=" + handler.getBounds(dir).m_162394_());
        TDUnitTests.debug("[properties]");
        TDUnitTests.testEquals("assert width = [0,2]", handler.getWidthProperty(), MultiblockHandler.getWidthProperty(3));
        TDUnitTests.testEquals("assert height = [0,2]", handler.getHeightProperty(), MultiblockHandler.getHeightProperty(3));
        TDUnitTests.testEquals("assert depth = [0,2]", handler.getDepthProperty(), MultiblockHandler.getDepthProperty(3));
        TDUnitTests.debug("[index]");
        TDUnitTests.testEquals("assert min index is -1, -1, -1", handler.getMinIndex(), new Vec3i(-1, -1, -1));
        TDUnitTests.testEquals("assert max index is 1, 1, 1", handler.getMaxIndex(), new Vec3i(1, 1, 1));
        TDUnitTests.debug("[getBounds]");
        TDUnitTests.testEquals("assert min is (1, -1, -1)", handler.getMin(center, dir), new BlockPos(1, -1, -1));
        TDUnitTests.testEquals("assert max is (-1, 1, 1)", handler.getMax(center, dir), new BlockPos(-1, 1, 1));
        AtomicInteger i = new AtomicInteger();
        i.set(0);
        handler.getPositions(center, dir).forEach(s -> i.getAndAdd(1));
        TDUnitTests.testEquals("assert 27 positions", i.get(), 27);
        handler = MultiblockHandler.MULTIBLOCK_3X3X1;
        TDUnitTests.debug("============================");
        TDUnitTests.debug("Testing MultiblockHandler 3x3x1");
        TDUnitTests.debug("dimensions=" + handler.getDimensions());
        TDUnitTests.debug("bounds=" + handler.getBounds(dir));
        TDUnitTests.debug("boundsCenterPos=" + handler.getBounds(dir).m_162394_());
        TDUnitTests.debug("[properties]");
        TDUnitTests.testEquals("assert width = [0,2]", handler.getWidthProperty(), MultiblockHandler.getWidthProperty(3));
        TDUnitTests.testEquals("assert height = [0,2]", handler.getHeightProperty(), MultiblockHandler.getHeightProperty(3));
        TDUnitTests.testEquals("assert depth = null", handler.getDepthProperty(), MultiblockHandler.getDepthProperty(1));
        TDUnitTests.debug("[index]");
        TDUnitTests.testEquals("assert min index is -1, -1, 0", handler.getMinIndex(), new Vec3i(-1, -1, 0));
        TDUnitTests.testEquals("assert max index is 1, 1, 0", handler.getMaxIndex(), new Vec3i(1, 1, 0));
        TDUnitTests.debug("[getBounds]");
        TDUnitTests.testEquals("assert min is (1, -1, 0)", handler.getMin(center, dir), new BlockPos(1, -1, 0));
        TDUnitTests.testEquals("assert max is (-1, 1, 0)", handler.getMax(center, dir), new BlockPos(-1, 1, 0));
        i.set(0);
        handler.getPositions(center, dir).forEach(s -> i.getAndAdd(1));
        TDUnitTests.testEquals("assert 9 positions", i.get(), 9);
        handler = MultiblockHandler.MULTIBLOCK_2X3X1;
        TDUnitTests.debug("============================");
        TDUnitTests.debug("Testing MultiblockHandler 2x3x1");
        TDUnitTests.debug("dimensions=" + handler.getDimensions());
        TDUnitTests.debug("bounds=" + handler.getBounds(dir));
        TDUnitTests.debug("boundsCenterPos=" + handler.getBounds(dir).m_162394_());
        TDUnitTests.debug("[properties]");
        TDUnitTests.testEquals("assert width = [0,1]", handler.getWidthProperty(), MultiblockHandler.getWidthProperty(2));
        TDUnitTests.testEquals("assert height = [0,2]", handler.getHeightProperty(), MultiblockHandler.getHeightProperty(3));
        TDUnitTests.testEquals("assert depth = null", handler.getDepthProperty(), MultiblockHandler.getDepthProperty(1));
        TDUnitTests.debug("[index]");
        TDUnitTests.testEquals("assert min index is 0, -1, 0", handler.getMinIndex(), new Vec3i(0, -1, 0));
        TDUnitTests.testEquals("assert max index is 1, 1, 0", handler.getMaxIndex(), new Vec3i(1, 1, 0));
        TDUnitTests.debug("[getBounds]");
        TDUnitTests.testEquals("assert min is (0, -1, 0)", handler.getMin(center, dir), new BlockPos(0, -1, 0));
        TDUnitTests.testEquals("assert max is (-1, 1, 0)", handler.getMax(center, dir), new BlockPos(-1, 1, 0));
        i.set(0);
        handler.getPositions(center, dir).forEach(s -> i.getAndAdd(1));
        TDUnitTests.testEquals("assert 6 positions", i.get(), 6);
        TanukiDecor.LOGGER.debug(debug.toString());
    }

    private static void debug(String message) {
        debug.append(message).append("\n");
    }

    private static boolean testEquals(String message, Object o1, Object o2) {
        if (Objects.equals(o1, o2)) {
            TDUnitTests.debug("  PASS " + message + " " + (o1 != null ? o1 : "null") + " = " + (o2 != null ? o2 : "null"));
            return true;
        }
        TDUnitTests.debug("  FAIL " + message + " " + (o1 != null ? o1 : "null") + " = " + (o2 != null ? o2 : "null"));
        return false;
    }
}

