/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tanukidecor.block.clock.IChimeProvider;

public class ClockBlockEntity
extends BlockEntity {
    @Nullable
    protected final IChimeProvider chimeProvider;
    protected final byte bias;

    public ClockBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        IChimeProvider provider;
        Block block = pBlockState.m_60734_();
        this.chimeProvider = block instanceof IChimeProvider ? (provider = (IChimeProvider)block) : null;
        this.bias = (byte)(Mth.m_14057_((Vec3i)pPos) % 2L == 0L ? -1 : 1);
    }

    public byte getBias() {
        return this.bias;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ClockBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        blockEntity.playTick(level, blockPos, blockState);
        blockEntity.playChime(level, blockPos, blockState);
    }

    protected void playTick(Level level, BlockPos blockPos, BlockState blockState) {
        if (null == this.chimeProvider) {
            return;
        }
        long gameTime = level.m_46467_();
        long dayTime = level.m_46468_() % 24000L;
        RandomSource random = level.m_213780_();
        SoundEvent tickSound = this.chimeProvider.getTickSound(blockState);
        if (tickSound != null && gameTime % (long)this.chimeProvider.getTickSoundInterval(blockState) == 0L) {
            float pitch = this.chimeProvider.getTickPitch(blockState, random, dayTime);
            float volume = this.chimeProvider.getTickVolume(blockState, random, dayTime);
            level.m_5594_(null, blockPos, tickSound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    protected void playChime(Level level, BlockPos blockPos, BlockState blockState) {
        if (null == this.chimeProvider) {
            return;
        }
        if (!level.m_46469_().m_46207_(GameRules.f_46140_)) {
            return;
        }
        long dayTime = level.m_46468_() % 24000L;
        RandomSource random = level.m_213780_();
        SoundEvent chimeSound = this.chimeProvider.getChimeSound(blockState);
        if (chimeSound != null && this.chimeProvider.isTimeToChime(blockState, dayTime)) {
            float pitch = this.chimeProvider.getChimePitch(blockState, random, dayTime);
            float volume = this.chimeProvider.getChimeVolume(blockState, random, dayTime);
            level.m_5594_(null, blockPos, chimeSound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    public static float getHour(long dayTime, float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)(dayTime - 1L), (float)dayTime) / 1000.0f;
    }

    public static float getMinute(long dayTime, float partialTick) {
        int minute = (int)(dayTime % 1000L);
        return Mth.m_14179_((float)partialTick, (float)(minute - 1), (float)minute) / 1000.0f;
    }

    public static float getSecond(long dayTime, float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)(dayTime - 1L), (float)dayTime) / 20.0f;
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(1.0);
    }
}

