/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import tanukidecor.block.RotatingBlock;

public class GlobeBlockEntity
extends BlockEntity {
    public static int USE_DURATION = 60;
    protected long startTime;
    protected boolean active;
    protected Direction targetDirection;
    private static final String KEY_TIMESTAMP = "StartTime";
    private static final String KEY_TARGET_DIRECTION = "Direction";

    public GlobeBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
        this.targetDirection = (Direction)pBlockState.m_61143_((Property)RotatingBlock.f_54117_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, GlobeBlockEntity blockEntity) {
        int timeElapsed;
        if (level.m_5776_()) {
            return;
        }
        if (blockEntity.isActive() && blockEntity.getStartTime() > 0L && (timeElapsed = (int)(level.m_46467_() - blockEntity.getStartTime())) > 20) {
            blockEntity.stop(level);
        }
    }

    public static InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        GlobeBlockEntity blockEntity;
        BlockEntity blockEntity2 = level.m_7702_(pos);
        if (!(blockEntity2 instanceof GlobeBlockEntity) || (blockEntity = (GlobeBlockEntity)blockEntity2).isActive()) {
            return InteractionResult.PASS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        blockEntity.start(level);
        return InteractionResult.SUCCESS;
    }

    public boolean isActive() {
        return this.active;
    }

    public void start(Level level) {
        this.active = true;
        if (!level.m_5776_()) {
            this.startTime = level.m_46467_();
            this.targetDirection = Direction.Plane.HORIZONTAL.m_235690_(level.m_213780_());
            this.m_6596_();
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            level.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
            level.m_5594_(null, this.m_58899_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.5f, 0.8f + level.m_213780_().m_188501_() * 0.4f);
        }
    }

    public void stop(Level level) {
        this.active = false;
        if (!level.m_5776_()) {
            this.startTime = 0L;
            this.m_6596_();
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            level.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Direction getTargetDirection() {
        return this.targetDirection;
    }

    public float getUsePercentage(float partialTick) {
        if (!this.active) {
            return 1.0f;
        }
        int useTime = (int)(this.m_58904_().m_46467_() - this.startTime);
        return Mth.m_14179_((float)partialTick, (float)(useTime - 1), (float)useTime) / 20.0f;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.startTime = pTag.m_128454_(KEY_TIMESTAMP);
        this.active = this.startTime > 0L;
        this.targetDirection = Direction.m_122402_((String)pTag.m_128461_(KEY_TARGET_DIRECTION));
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128356_(KEY_TIMESTAMP, this.startTime);
        pTag.m_128359_(KEY_TARGET_DIRECTION, this.targetDirection.m_7912_());
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128356_(KEY_TIMESTAMP, this.startTime);
        tag.m_128359_(KEY_TARGET_DIRECTION, this.targetDirection.m_7912_());
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

