/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.seat;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ISeatProvider {
    public static final Predicate<Entity> IS_SEAT_ENTITY = e -> e.m_6095_() == EntityType.f_20510_ && e.m_20067_() && e.m_20145_() && e.m_20068_();

    public double getSeatYOffset(BlockState var1, Level var2, BlockPos var3);

    public Direction getSeatDirection(BlockState var1, Level var2, BlockPos var3);

    default public Vec3 getSeatPosition(BlockState blockState, Level level, BlockPos blockPos) {
        return new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + this.getSeatYOffset(blockState, level, blockPos), (double)blockPos.m_123343_() + 0.5);
    }

    default public boolean despawnSeat(BlockState blockState, Level level, BlockPos pos, boolean force) {
        Entity entity = this.getSeat(level, pos);
        if (entity != null && (force || !entity.m_20160_())) {
            entity.m_20153_();
            entity.m_146870_();
            return true;
        }
        return false;
    }

    default public boolean startSitting(BlockState blockState, Level level, BlockPos pos, Player player) {
        Entity entity = this.getOrCreateSeat(blockState, level, pos);
        if (null == entity || entity.m_20160_()) {
            return false;
        }
        if (!player.m_7998_(entity, true)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9774_(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), entity.m_146908_(), serverPlayer.m_146909_());
        }
        return true;
    }

    default public boolean stopSitting(BlockState blockState, Level level, BlockPos pos) {
        Entity entity = this.getSeat(level, pos);
        if (null == entity || !entity.m_20160_()) {
            return false;
        }
        entity.m_20153_();
        return true;
    }

    @Nullable
    default public Entity getOrCreateSeat(BlockState blockState, Level level, BlockPos pos) {
        Entity existingEntity = this.getSeat(level, pos);
        if (existingEntity != null) {
            return existingEntity;
        }
        Vec3 seatPos = this.getSeatPosition(blockState, level, pos);
        Direction seatDirection = this.getSeatDirection(blockState, level, pos);
        Pig entity = (Pig)EntityType.f_20510_.m_20615_(level);
        if (entity != null) {
            float rotation = seatDirection.m_122435_();
            entity.m_146922_(rotation);
            entity.m_5616_(rotation);
            entity.m_146884_(seatPos.m_82520_(0.0, -entity.m_6048_(), 0.0));
            entity.m_21557_(true);
            entity.m_20225_(true);
            entity.m_20242_(true);
            entity.m_6842_(true);
            entity.m_20331_(true);
            entity.m_146762_(Integer.MIN_VALUE);
            entity.f_19794_ = true;
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19609_, Integer.MAX_VALUE, 0, false, false));
            level.m_7967_((Entity)entity);
        }
        return entity;
    }

    @Nullable
    default public Entity getSeat(Level level, BlockPos pos) {
        AABB aabb = new AABB(pos).m_82377_(-0.0625, 0.25, -0.0625);
        List list = level.m_6443_(Entity.class, aabb, IS_SEAT_ENTITY);
        if (!list.isEmpty()) {
            return (Entity)list.get(0);
        }
        return null;
    }
}

