/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import tanukidecor.block.entity.RocketLampBlockEntity;
import tanukidecor.block.misc.RocketLampBlock;

public class RocketLampBER
implements BlockEntityRenderer<RocketLampBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;
    private static final Map<String, Map<WaxSize, ResourceLocation>> WAX_MODELS = new HashMap<String, Map<WaxSize, ResourceLocation>>();

    public RocketLampBER(BlockEntityRendererProvider.Context pContext) {
        this.blockRenderer = pContext.m_173584_();
    }

    protected static ResourceLocation getWaxModel(WaxSize waxSize, String color) {
        return WAX_MODELS.computeIfAbsent(color, s -> new EnumMap(WaxSize.class)).computeIfAbsent(waxSize, size -> new ResourceLocation("tanukidecor", "block/rocket_lamp/" + color + "/" + size.m_7912_() + "_wax"));
    }

    public void render(RocketLampBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        String color = blockEntity.getColor();
        long seed = blockState.m_60726_(blockEntity.m_58899_());
        float time = (float)((blockEntity.m_58904_().m_46467_() + seed) % 96000L) + partialTick;
        Direction direction = Direction.m_122407_((int)((int)(Math.abs(seed) % 4L)));
        Minecraft mc = Minecraft.m_91087_();
        RenderType renderType = RenderType.m_110451_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        BakedModel largeModel = mc.m_91304_().getModel(RocketLampBER.getWaxModel(WaxSize.LARGE, color));
        BakedModel mediumModel = mc.m_91304_().getModel(RocketLampBER.getWaxModel(WaxSize.MEDIUM, color));
        BakedModel smallModel = mc.m_91304_().getModel(RocketLampBER.getWaxModel(WaxSize.SMALL, color));
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(direction.m_122435_()));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        this.renderWax(poseStack, vertexConsumer, blockState, largeModel, 3.0f, 0.6f, 0.4f, time, 0.51f, 0.245f, 0.0163f);
        this.renderWax(poseStack, vertexConsumer, blockState, largeModel, 3.0f, 0.475f, 0.58f, time + 773.0f, 0.48f, 0.132f, 0.0115f);
        this.renderWax(poseStack, vertexConsumer, blockState, mediumModel, 2.0f, 0.64f, 0.59f, time + 559.0f, 0.49f, 0.02f, 0.0134f);
        this.renderWax(poseStack, vertexConsumer, blockState, mediumModel, 2.0f, 0.5f, 0.4f, time + 79.0f, 0.446f, 0.09f, 0.0194f);
        this.renderWax(poseStack, vertexConsumer, blockState, smallModel, 1.0f, 0.4f, 0.65f, time + 109.0f, 0.39f, 0.111f, 0.0212f);
        poseStack.m_85849_();
    }

    private void renderWax(PoseStack poseStack, VertexConsumer vertexConsumer, BlockState blockState, BakedModel model, float sizeY, float dx, float dz, float time, float biasFactor, float amplitudeFactor, float frequencyFactor) {
        float y = (sizeY / 2.0f - 8.0f) / 16.0f;
        float range = (16.0f - sizeY) / 16.0f;
        float dy = y + range * RocketLampBER.smoothstep(biasFactor + (0.5f + amplitudeFactor) * Mth.m_14031_((float)(time * frequencyFactor)));
        float scaleFactor = 0.34f + 0.31f * (float)Mth.m_14197_((double)(Mth.m_14031_((float)(time * 0.053f)) * 0.9f + 0.5f));
        float scaleX = 0.4f + 0.6f * (1.0f - (scaleFactor *= 0.5f + 0.5f * Math.abs(Mth.m_14089_((float)(time * frequencyFactor)))));
        float scaleY = 0.8f + 0.5f * scaleFactor;
        float scaleZ = 0.4f + 0.6f * (1.0f - scaleFactor);
        poseStack.m_85836_();
        poseStack.m_252880_(dx, dy, dz);
        poseStack.m_85841_(scaleX, scaleY, scaleZ);
        this.blockRenderer.m_110937_().renderModel(poseStack.m_85850_(), vertexConsumer, blockState, model, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, RenderType.m_110451_());
        poseStack.m_85849_();
    }

    private static float smoothstep(float f) {
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        return f * f * (3.0f - 2.0f * f);
    }

    public static void addSpecialModels(Set<ResourceLocation> set) {
        for (String color : RocketLampBlock.getColors().keySet()) {
            for (WaxSize size : WaxSize.values()) {
                set.add(RocketLampBER.getWaxModel(size, color));
            }
        }
    }

    private static enum WaxSize implements StringRepresentable
    {
        SMALL("small"),
        MEDIUM("medium"),
        LARGE("large");

        private final String name;

        private WaxSize(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

