/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.integration;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tanukidecor.TDRegistry;
import tanukidecor.block.entity.DIYWorkbenchBlockEntity;
import tanukidecor.integration.TDJeiPlugin;
import tanukidecor.recipe.DIYRecipe;

public class JeiDIYRecipeCategory
implements IRecipeCategory<DIYRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("tanukidecor", "diy");
    public static final RecipeType<DIYRecipe> RECIPE_TYPE = new RecipeType(UID, DIYRecipe.class);
    private static final ResourceLocation TEXTURE = new ResourceLocation("tanukidecor", "textures/jei/diy_recipe.png");
    private static final int PADDING = 10;
    private static final int INPUT_SPACING = 33;
    private static final int SLOT_SIZE = 18;
    private static final int ARROW_HEIGHT = 26;
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public JeiDIYRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 117, 62).addPadding(10, 10, 10, 10).setTextureSize(128, 64).build();
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)TDRegistry.BlockReg.DIY_WORKBENCH.get()));
        this.title = Component.m_237115_((String)Util.m_137492_((String)"jei.recipe.category", (ResourceLocation)UID));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DIYRecipe recipe, IFocusGroup focuses) {
        Optional<RegistryAccess> oRegistryAccess = TDJeiPlugin.getClientRegistryAccess();
        if (oRegistryAccess.isEmpty()) {
            return;
        }
        int x = 11;
        int y = 11;
        for (int i = 0; i < 4; ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, x + 33 * i, y).setSlotName("input" + i).addItemStacks(List.of(DIYWorkbenchBlockEntity.INGREDIENTS[i].m_43908_()));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, x += (this.background.getWidth() - 18 - 20) / 2, y += 44).setSlotName("output").addItemStack(recipe.m_8043_(oRegistryAccess.get()));
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<DIYRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }
}

