/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import tanukidecor.TanukiDecor;
import tanukidecor.menu.DIYWorkbenchMenu;
import tanukidecor.recipe.DIYRecipe;

public class ServerBoundSelectDIYRecipePacket {
    private static final TagKey<Item> DIY_BLACKLIST_TAG_KEY = ForgeRegistries.ITEMS.tags().createTagKey(new ResourceLocation("tanukidecor", "diy_blacklist"));
    private ResourceLocation recipeId;

    public ServerBoundSelectDIYRecipePacket(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public static ServerBoundSelectDIYRecipePacket fromBytes(FriendlyByteBuf buf) {
        ResourceLocation recipeId = buf.m_130281_();
        return new ServerBoundSelectDIYRecipePacket(recipeId);
    }

    public static void toBytes(ServerBoundSelectDIYRecipePacket msg, FriendlyByteBuf buf) {
        buf.m_130085_(msg.recipeId);
    }

    public static void handlePacket(ServerBoundSelectDIYRecipePacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER && context.getSender() != null) {
            context.enqueueWork(() -> {
                Object patt3131$temp;
                ServerPlayer player = context.getSender();
                AbstractContainerMenu patt2674$temp = player.f_36096_;
                if (!(patt2674$temp instanceof DIYWorkbenchMenu)) {
                    return;
                }
                DIYWorkbenchMenu menu = (DIYWorkbenchMenu)patt2674$temp;
                if (!((Boolean)TanukiDecor.CONFIG.isDIYWorkbenchEnabled.get()).booleanValue()) {
                    return;
                }
                Optional oRecipe = player.m_9236_().m_7465_().m_44043_(message.recipeId);
                if (oRecipe.isEmpty() || !((patt3131$temp = oRecipe.get()) instanceof DIYRecipe)) {
                    return;
                }
                DIYRecipe recipe = (DIYRecipe)patt3131$temp;
                if (recipe.m_8043_(player.m_9236_().m_9598_()).m_204117_(DIY_BLACKLIST_TAG_KEY)) {
                    return;
                }
                menu.setRecipe(recipe);
            });
        }
        context.setPacketHandled(true);
    }
}

