/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.data.candle.CandleEffects;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.item.custom.CandleItem;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;

public class Candle
extends AbstractCandleBlock
implements ITileEntity<CandleTile>,
EntityBlock,
SimpleWaterloggedBlock,
DyeableLeatherItem {
    public static final IntegerProperty CANDLES = IntegerProperty.m_61631_((String)"candles", (int)1, (int)4);
    public static final IntegerProperty CANDLES_LIT = IntegerProperty.m_61631_((String)"candles_lit", (int)0, (int)4);
    public static final IntegerProperty POWER = IntegerProperty.m_61631_((String)"power", (int)0, (int)15);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int BASE_COLOR = 13419416;
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.m_137537_(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of());
        int2objectmap.put(1, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.5, 0.5)));
        int2objectmap.put(2, (Object)ImmutableList.of((Object)new Vec3(0.375, 0.44, 0.5), (Object)new Vec3(0.625, 0.5, 0.44)));
        int2objectmap.put(3, (Object)ImmutableList.of((Object)new Vec3(0.5, 0.313, 0.625), (Object)new Vec3(0.375, 0.44, 0.5), (Object)new Vec3(0.56, 0.5, 0.44)));
        int2objectmap.put(4, (Object)ImmutableList.of((Object)new Vec3(0.44, 0.313, 0.56), (Object)new Vec3(0.625, 0.44, 0.56), (Object)new Vec3(0.375, 0.44, 0.375), (Object)new Vec3(0.56, 0.5, 0.375)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    public static final VoxelShape ONE_SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0);
    public static final VoxelShape TWO_SHAPE = Block.m_49796_((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    public static final VoxelShape THREE_SHAPE = Block.m_49796_((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    public static final VoxelShape FOUR_SHAPE = Block.m_49796_((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)9.0, (double)12.5);
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new OptionalDispenseItemBehavior(){

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            this.m_123573_(false);
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = source.m_7961_().m_121945_(direction);
                try {
                    this.m_123573_(((BlockItem)item).m_40576_((BlockPlaceContext)new DirectionalPlaceContext((Level)source.m_7727_(), blockpos, direction, stack, direction)).m_19077_());
                }
                catch (Exception exception) {
                    f_181892_.error("Error trying to place shulker box at {}", (Object)blockpos, (Object)exception);
                }
                BlockEntity blockEntity = source.m_7727_().m_7702_(blockpos);
                BlockState blockState = source.m_7727_().m_8055_(blockpos);
                if (blockEntity instanceof CandleTile) {
                    CandleTile candleTile = (CandleTile)blockEntity;
                    source.m_7727_().m_186460_(blockpos, blockState.m_60734_(), 1);
                }
            }
            return stack;
        }

        protected void m_6823_(BlockSource p_42947_) {
            p_42947_.m_7727_().m_46796_(1000, p_42947_.m_7961_(), 0);
        }
    };

    public RenderShape m_7514_(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState p_220697_, Level p_220698_, BlockPos p_220699_, RandomSource p_220700_) {
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        if (blockstate.m_60713_((Block)ModBlocks.CANDLE.get())) {
            return (BlockState)blockstate.m_61124_((Property)CANDLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.m_61143_((Property)CANDLES) + 1)));
        }
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)context.m_8125_())).m_61124_((Property)CANDLES_LIT, (Comparable)Integer.valueOf(0));
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)blockEntity;
            int analog = candleTile.updateAnalog();
            pLevel.m_46672_(pPos, pState.m_60734_());
        }
        super.m_213897_(pState, pLevel, pPos, pRandom);
    }

    public static boolean m_151933_(BlockState p_151934_) {
        return p_151934_.m_61138_((Property)f_151895_) && (p_151934_.m_204336_(BlockTags.f_144265_) || p_151934_.m_204336_(BlockTags.f_144268_)) && (Boolean)p_151934_.m_61143_((Property)f_151895_) != false;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return useContext.m_43722_().m_41720_() == ModItems.CANDLE.get() && (Integer)state.m_61143_((Property)CANDLES) < 4 || super.m_6864_(state, useContext);
    }

    public void dropCandles(Level level, BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)entity;
            if (!level.m_5776_()) {
                for (int i = 0; i < 4; ++i) {
                    CandleData candleData = (CandleData)candleTile.candles.get(i);
                    if (!candleData.hasCandle) continue;
                    ItemStack itemStack = new ItemStack((ItemLike)ModBlocks.CANDLE.get());
                    if (candleData.dyeColor != 13419416) {
                        CandleItem.setColorStatic(itemStack, candleData.dyeColor);
                    }
                    if (candleData.height < 7) {
                        CandleItem.setHeight(itemStack, candleData.height);
                    }
                    if (candleData.herb.layer != null) {
                        CandleItem.setHerbLayer(itemStack, candleData.herb.layer.toString());
                    }
                    if (candleData.base.layer != null) {
                        CandleItem.setBaseLayer(itemStack, candleData.base.layer.toString());
                    }
                    if (candleData.glow.layer != null) {
                        CandleItem.setGlowLayer(itemStack, candleData.glow.layer.toString());
                    }
                    if (candleData.swirl.layer != null) {
                        CandleItem.setSwirlLayer(itemStack, candleData.swirl.layer.toString());
                    }
                    if (candleData.effect != null) {
                        CandleItem.setEffectLocation(itemStack, candleData.effect.getLocationName());
                    }
                    if (candleData.effectParticle != null) {
                        CandleItem.setEffectParticle(itemStack, candleData.effectParticle);
                    }
                    if (!itemStack.m_41782_() || itemStack.m_41784_().m_128456_()) {
                        level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), new ItemStack((ItemLike)ModBlocks.CANDLE.get())));
                        continue;
                    }
                    Candle.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemStack);
                }
            }
        }
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((ItemLike)ModItems.CANDLE.get());
        Optional<CandleTile> tileEntityOptional = Optional.ofNullable((CandleTile)this.getBlockEntity(worldIn, pos));
        tileEntityOptional.ifPresent(candleTile -> {
            CandleData candleData = (CandleData)candleTile.candles.get(0);
            if (candleData.dyeColor != 13419416 && candleData.dyeColor != 0) {
                this.m_41115_(item, candleData.dyeColor);
            }
            if (candleData.height < 7) {
                CandleItem.setHeight(item, candleData.height);
            }
            if (candleData.herb.layer != null) {
                CandleItem.setHerbLayer(item, candleData.herb.layer.toString());
            }
            if (candleData.base.layer != null) {
                CandleItem.setBaseLayer(item, candleData.base.layer.toString());
            }
            if (candleData.glow.layer != null) {
                CandleItem.setGlowLayer(item, candleData.glow.layer.toString());
            }
            if (candleData.swirl.layer != null) {
                CandleItem.setSwirlLayer(item, candleData.swirl.layer.toString());
            }
            if (candleData.effect != null) {
                CandleItem.setEffectLocation(item, candleData.effect.getLocationName());
            }
            if (candleData.effectParticle != null) {
                CandleItem.setEffectParticle(item, candleData.effectParticle);
            }
        });
        Component customName = tileEntityOptional.map(CandleTile::getCustomName).orElse(null);
        if (customName != null && customName.getString().length() > 0) {
            item.m_41714_(customName);
        }
        return item;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = level.m_7702_(pos);
            if (tileentity != null) {
                this.dropCandles(level, pos);
            }
            for (Direction direction : Direction.values()) {
                level.m_46672_(pos.m_121945_(direction), (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.m_61143_((Property)CANDLES)) {
            default -> ONE_SHAPE;
            case 2 -> TWO_SHAPE;
            case 3 -> THREE_SHAPE;
            case 4 -> FOUR_SHAPE;
        };
    }

    public static VoxelShape getShape(BlockState state) {
        return switch ((Integer)state.m_61143_((Property)CANDLES)) {
            default -> ONE_SHAPE;
            case 2 -> TWO_SHAPE;
            case 3 -> THREE_SHAPE;
            case 4 -> FOUR_SHAPE;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(handIn);
        Random random = new Random();
        if (itemstack.m_41720_() == Items.f_42409_ && Candle.canBeLit(state, pos, worldIn)) {
            CandleTile tile = (CandleTile)worldIn.m_7702_(pos);
            if (tile == null) {
                return InteractionResult.FAIL;
            }
            if (!((CandleData)tile.candles.get((int)0)).lit) {
                ((CandleData)tile.candles.get((int)0)).lit = true;
            } else if (!((CandleData)tile.candles.get((int)1)).lit) {
                ((CandleData)tile.candles.get((int)1)).lit = true;
            } else if (!((CandleData)tile.candles.get((int)2)).lit) {
                ((CandleData)tile.candles.get((int)2)).lit = true;
            } else if (!((CandleData)tile.candles.get((int)3)).lit) {
                ((CandleData)tile.candles.get((int)3)).lit = true;
            } else {
                return InteractionResult.FAIL;
            }
            worldIn.m_5594_(null, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.m_41622_(1, (LivingEntity)player, player1 -> player1.m_21190_(handIn));
            return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
        }
        if (itemstack.m_41720_() == Items.f_42613_ && Candle.canBeLit(state, pos, worldIn)) {
            CandleTile tile = (CandleTile)worldIn.m_7702_(pos);
            if (tile == null) {
                return InteractionResult.FAIL;
            }
            if (!((CandleData)tile.candles.get((int)0)).hasCandle) {
                ((CandleData)tile.candles.get((int)0)).lit = true;
            }
            if (!((CandleData)tile.candles.get((int)1)).hasCandle) {
                ((CandleData)tile.candles.get((int)1)).lit = true;
            }
            if (!((CandleData)tile.candles.get((int)2)).hasCandle) {
                ((CandleData)tile.candles.get((int)2)).lit = true;
            }
            if (!((CandleData)tile.candles.get((int)3)).hasCandle) {
                ((CandleData)tile.candles.get((int)3)).lit = true;
            }
            worldIn.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, random.nextFloat() * 0.4f + 1.0f);
            itemstack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)worldIn.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public Candle(BlockBehaviour.Properties properties) {
        super(properties.m_60910_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)CANDLES_LIT, (Comparable)Integer.valueOf(0))).m_61124_((Property)f_151895_, (Comparable)Boolean.valueOf(false)));
    }

    protected Iterable<Vec3> m_142199_(BlockState blockState) {
        return (Iterable)PARTICLE_OFFSETS.get(((Integer)blockState.m_61143_((Property)CANDLES)).intValue());
    }

    public static void spawnSmokeParticles(Level worldIn, BlockPos pos, boolean spawnExtraSmoke) {
        RandomSource random = worldIn.m_213780_();
        SimpleParticleType basicparticletype = (SimpleParticleType)ModParticleTypes.EXTINGUISH.get();
        Vec3 offset = new Vec3(random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, random.m_188500_() / 3.0 * (double)(random.m_188499_() ? 1 : -1));
        worldIn.m_6493_((ParticleOptions)basicparticletype, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.m_188500_() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.m_188500_() * 0.1 + 0.1, offset.f_82481_ / 8.0);
        if (spawnExtraSmoke) {
            worldIn.m_6493_((ParticleOptions)basicparticletype, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.m_188500_() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.m_188500_() * 0.1 + 0.1, offset.f_82481_ / 8.0);
        }
    }

    public static void spawnParticleWave(Level worldIn, BlockPos pos, boolean spawnExtraSmoke, List<ResourceLocation> particle, int amount) {
        RandomSource random = worldIn.m_213780_();
        for (int i = 0; i < amount; ++i) {
            ParticleType type;
            float rotation = random.m_188501_() * 360.0f;
            Vec3 offset = new Vec3(random.m_188500_() * 2.0 * Math.cos(rotation), 0.0, random.m_188500_() * 2.0 * Math.sin(rotation));
            if (particle.isEmpty() || (type = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particle.get(random.m_188503_(particle.size())))) == null) continue;
            worldIn.m_6493_((ParticleOptions)type, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.m_188500_() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.m_188500_() * 0.025, offset.f_82481_ / 8.0);
            if (!spawnExtraSmoke) continue;
            worldIn.m_6493_((ParticleOptions)type, true, (double)pos.m_123341_() + 0.5 + offset.f_82479_, (double)pos.m_123342_() + random.m_188500_() * (double)0.15f, (double)pos.m_123343_() + 0.5 + offset.f_82481_, offset.f_82479_ / 8.0, random.m_188500_() * 0.025, offset.f_82481_ / 8.0);
        }
    }

    public static void extinguish(LevelAccessor level, BlockPos pos, BlockState state, CandleTile tile) {
        int i;
        int numLit = 0;
        for (i = 0; i < 4; ++i) {
            if (!((CandleData)tile.candles.get((int)i)).lit) continue;
            ++numLit;
        }
        ((CandleData)tile.candles.get((int)0)).lit = false;
        ((CandleData)tile.candles.get((int)1)).lit = false;
        ((CandleData)tile.candles.get((int)2)).lit = false;
        ((CandleData)tile.candles.get((int)3)).lit = false;
        if (!level.m_5776_()) {
            level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (level.m_5776_()) {
            for (i = 0; i < 10 * numLit; ++i) {
                Candle.spawnSmokeParticles((Level)level, pos, true);
            }
        }
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidStateIn.m_76152_() == Fluids.f_76193_) {
            boolean flag;
            CandleTile tile = (CandleTile)worldIn.m_7702_(pos);
            boolean bl = flag = ((CandleData)tile.candles.get((int)0)).lit || ((CandleData)tile.candles.get((int)1)).lit || ((CandleData)tile.candles.get((int)2)).lit || ((CandleData)tile.candles.get((int)3)).lit;
            if (flag) {
                Candle.extinguish(worldIn, pos, state, tile);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            worldIn.m_186469_(pos, fluidStateIn.m_76152_(), fluidStateIn.m_76152_().m_6718_((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public void m_5581_(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (projectile.m_6060_()) {
            boolean flag;
            CandleTile tile = (CandleTile)worldIn.m_7702_(hit.m_82425_());
            boolean flagLit = ((CandleData)tile.candles.get((int)0)).lit && ((CandleData)tile.candles.get((int)1)).lit && ((CandleData)tile.candles.get((int)2)).lit && ((CandleData)tile.candles.get((int)3)).lit;
            Entity entity = projectile.m_19749_();
            boolean bl = flag = entity == null || entity instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entity);
            if (flag && !flagLit && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
                if (((CandleData)tile.candles.get((int)0)).hasCandle) {
                    ((CandleData)tile.candles.get((int)0)).lit = true;
                }
                if (((CandleData)tile.candles.get((int)1)).hasCandle) {
                    ((CandleData)tile.candles.get((int)1)).lit = true;
                }
                if (((CandleData)tile.candles.get((int)2)).hasCandle) {
                    ((CandleData)tile.candles.get((int)2)).lit = true;
                }
                if (((CandleData)tile.candles.get((int)3)).hasCandle) {
                    ((CandleData)tile.candles.get((int)3)).lit = true;
                }
            }
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((BlockGetter)worldIn, pos, te -> {
            for (int i = 0; i < 4; ++i) {
                Item patt23004$temp;
                if (((CandleData)te.candles.get((int)i)).hasCandle || !((patt23004$temp = stack.m_41720_()) instanceof CandleItem)) continue;
                CandleItem candleItem = (CandleItem)patt23004$temp;
                ((CandleData)te.candles.get((int)i)).hasCandle = true;
                ((CandleData)te.candles.get((int)i)).dyeColor = CandleItem.getColorStatic(stack);
                ((CandleData)te.candles.get((int)i)).height = CandleItem.getHeight(stack);
                String herbLayer = CandleItem.getHerbLayer(stack);
                String baseLayer = CandleItem.getBaseLayer(stack);
                String glowLayer = CandleItem.getGlowLayer(stack);
                String swirlLayer = CandleItem.getSwirlLayer(stack);
                String effectLocation = CandleItem.getEffectLocation(stack);
                List<ResourceLocation> effectParticle = CandleItem.getEffectParticle(stack);
                ((CandleData)te.candles.get((int)i)).herb.layer = herbLayer != null ? (herbLayer.equals("minecraft:missingno") ? null : new ResourceLocation(herbLayer)) : null;
                ((CandleData)te.candles.get((int)i)).base.layer = baseLayer != null ? (baseLayer.equals("minecraft:missingno") ? null : new ResourceLocation(baseLayer)) : null;
                ((CandleData)te.candles.get((int)i)).glow.layer = glowLayer != null ? (glowLayer.equals("minecraft:missingno") ? null : new ResourceLocation(glowLayer)) : null;
                ((CandleData)te.candles.get((int)i)).swirl.layer = swirlLayer != null ? (swirlLayer.equals("minecraft:missingno") ? null : new ResourceLocation(swirlLayer)) : null;
                if (effectLocation != null) {
                    ((CandleData)te.candles.get(i)).setEffect(CandleEffects.getEffect(effectLocation).getCopy());
                } else {
                    ((CandleData)te.candles.get((int)i)).effect = new AbstractCandleEffect();
                }
                ((CandleData)te.candles.get((int)i)).effectParticle = effectParticle;
                break;
            }
            te.sync();
        });
        for (Direction direction : Direction.values()) {
            worldIn.m_46672_(pos.m_121945_(direction), (Block)this);
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        AtomicInteger toReturn = new AtomicInteger();
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CandleTile) {
            CandleTile candleTile = (CandleTile)blockEntity;
            candleTile.updateAnalog();
            return candleTile.redstoneAnalogSignal;
        }
        return toReturn.get();
    }

    public int m_6376_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public boolean m_7899_(BlockState pState) {
        return (Integer)pState.m_61143_((Property)POWER) > 0;
    }

    public int m_6378_(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Integer)pBlockState.m_61143_((Property)POWER);
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        for (Direction direction : Direction.values()) {
            pLevel.m_46672_(pPos.m_121945_(direction), (Block)this);
        }
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HorizontalDirectionalBlock.f_54117_, CANDLES, WATERLOGGED, POWER, CANDLES_LIT, f_151895_});
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof CandleTile) {
            CandleTile tile = (CandleTile)tileentity;
            tile.entityInside(entityIn);
        }
    }

    public static boolean canBeLit(BlockState state, BlockPos pos, Level world) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity instanceof CandleTile) {
            CandleTile tile = (CandleTile)entity;
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false && (!((CandleData)tile.candles.get((int)0)).lit || !((CandleData)tile.candles.get((int)1)).lit && ((CandleData)tile.candles.get((int)1)).hasCandle || !((CandleData)tile.candles.get((int)2)).lit && ((CandleData)tile.candles.get((int)2)).hasCandle || !((CandleData)tile.candles.get((int)3)).lit && ((CandleData)tile.candles.get((int)3)).hasCandle);
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return Candle.m_49863_((LevelReader)worldIn, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.candle_shift_1").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.candle_shift_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.candle_shift_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            String str = CandleItem.getEffectLocation(stack);
            if (str != null && str.length() > 0 && !str.equals("hexerei:no_effect")) {
                String translateEffect = "effect." + new ResourceLocation(str).m_135827_() + "." + new ResourceLocation(str).m_135815_();
                MutableComponent component = Component.m_237115_((String)translateEffect).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999)));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.hexerei.candle_effect", (Object[])new Object[]{component}));
            }
        }
        super.m_5871_(stack, world, tooltip, flagIn);
    }

    @Override
    public Class<CandleTile> getTileEntityClass() {
        return CandleTile.class;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CandleTile((BlockEntityType)ModTileEntities.CANDLE_TILE.get(), pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.CANDLE_TILE.get() ? (world2, pos, state2, entity) -> ((CandleTile)entity).tick() : null;
    }
}

