/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.owl;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.ClientboundOwlCourierDepotDataInventoryPacket;
import net.joefoxe.hexerei.util.message.ClientboundOwlCourierDepotDataPacket;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="hexerei")
public class OwlCourierDepotSavedData
extends SavedData {
    protected static final String DATA_NAME = "hexerei_owl_courier_depot";
    Map<GlobalPos, OwlCourierDepotData> depots = new HashMap<GlobalPos, OwlCourierDepotData>();

    public OwlCourierDepotSavedData addOwlCourierDepot(String name, GlobalPos pos) {
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : this.depots.entrySet()) {
            if (entry.getValue().name.equals(name)) {
                return this;
            }
            if (!entry.getKey().equals((Object)pos)) continue;
            return this;
        }
        this.depots.put(pos, new OwlCourierDepotData(name));
        this.syncToClient();
        this.m_77762_();
        return this;
    }

    public Map<GlobalPos, OwlCourierDepotData> getDepots() {
        return this.depots;
    }

    public void syncToClient() {
        HexereiPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundOwlCourierDepotDataPacket(this.m_7176_(new CompoundTag())));
    }

    public void syncInvToClient(GlobalPos pos) {
        HexereiPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundOwlCourierDepotDataInventoryPacket(this.invNbt(pos, new CompoundTag())));
    }

    public void clearOwlCourierDepot(GlobalPos pos) {
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : this.depots.entrySet()) {
            GlobalPos depotPos = entry.getKey();
            if (!pos.equals((Object)depotPos)) continue;
            this.depots.remove(entry.getKey());
            this.m_77762_();
            this.syncToClient();
            break;
        }
    }

    public void tick(ServerLevel serverLevel) {
    }

    @SubscribeEvent
    public static void serverTickEvent(TickEvent.ServerTickEvent event) {
    }

    private static OwlCourierDepotSavedData create(CompoundTag tag) {
        OwlCourierDepotSavedData data = new OwlCourierDepotSavedData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag pCompoundTag) {
        if (pCompoundTag.m_128441_("depots")) {
            ListTag depotList = pCompoundTag.m_128437_("depots", 10);
            for (int i = 0; i < depotList.size(); ++i) {
                CompoundTag depotTag = depotList.m_128728_(i);
                String depotName = depotTag.m_128461_("DepotName");
                Optional pos = GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)depotTag.m_128423_("Pos")).result();
                OwlCourierDepotData depotData = new OwlCourierDepotData(depotName);
                ContainerHelper.m_18980_((CompoundTag)depotTag, depotData.items);
                pos.ifPresent(globalPos -> this.depots.put((GlobalPos)globalPos, depotData));
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        ListTag depotList = new ListTag();
        for (Map.Entry<GlobalPos, OwlCourierDepotData> entry : this.depots.entrySet()) {
            CompoundTag depotTag = new CompoundTag();
            depotTag.m_128359_("DepotName", entry.getValue().name);
            Optional tag = GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)entry.getKey()).result();
            tag.ifPresent(value -> depotTag.m_128365_("Pos", value));
            ContainerHelper.m_18973_((CompoundTag)depotTag, entry.getValue().items);
            depotList.add((Object)depotTag);
        }
        pCompoundTag.m_128365_("depots", (Tag)depotList);
        return pCompoundTag;
    }

    public CompoundTag invNbt(GlobalPos pos, CompoundTag pCompoundTag) {
        Optional tag = GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).result();
        tag.ifPresent(value -> pCompoundTag.m_128365_("Pos", value));
        ContainerHelper.m_18973_((CompoundTag)pCompoundTag, this.depots.get((Object)pos).items);
        return pCompoundTag;
    }

    public static OwlCourierDepotSavedData get(ServerLevel world) {
        return (OwlCourierDepotSavedData)world.m_7654_().m_129783_().m_8895_().m_164861_(OwlCourierDepotSavedData::create, OwlCourierDepotSavedData::new, DATA_NAME);
    }

    public static OwlCourierDepotSavedData get() {
        return (OwlCourierDepotSavedData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(OwlCourierDepotSavedData::create, OwlCourierDepotSavedData::new, DATA_NAME);
    }
}

