/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.integration.jei.ExtraCauldronIcon;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.joefoxe.hexerei.util.HexereiTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class FluidMixingRecipeCategory
implements IRecipeCategory<FluidMixingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "fluid_mixing");
    public static final ResourceLocation POTION_UID = new ResourceLocation("hexerei", "potion_mixing");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/fluid_mixing_gui_jei.png");
    public static final ResourceLocation TEXTURE_BLANK = new ResourceLocation("hexerei", "textures/block/blank.png");
    private IDrawable background;
    private final IDrawable icon;
    private final IDrawable liquid;
    private final IDrawable cauldron;
    private final IDrawable output1;
    private final IDrawable output2;
    private Block heatSource;
    private boolean findNewHeatSource;
    private String type;

    public List<Component> getTooltipStrings(FluidMixingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (recipe.getHeatCondition() != FluidMixingRecipe.HeatCondition.NONE && this.isHovering(mouseX, mouseY, 79.0, 59.0, 24.0, 18.0)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.heat_source"));
            if (Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237110_((String)"<%s>", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAA6600)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.recipe_heated_1").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.recipe_heated_2").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.recipe_heated_3").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.recipe_heated_4").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237110_((String)"Heat source shown: - %s", (Object[])new Object[]{Component.m_237115_((String)this.heatSource.m_7705_()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xCC5522)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"[%s]", (Object[])new Object[]{Component.m_237115_((String)"tooltip.hexerei.shift").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAA00)))}).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.hexerei.recipe_heated").m_130948_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x999999))));
            }
            return tooltip;
        }
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public FluidMixingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 186, 109);
        this.icon = new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.f_42447_));
        this.liquid = helper.createDrawable(TEXTURE, 208, 12, 16, 32);
        this.cauldron = helper.createDrawable(TEXTURE, 238, 50, 12, 10);
        this.output1 = helper.createDrawable(TEXTURE, 209, 64, 47, 82);
        this.output2 = helper.createDrawable(TEXTURE, 209, 146, 47, 82);
        this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
        this.type = "Fluid";
    }

    public FluidMixingRecipeCategory(IGuiHelper helper, String type) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 186, 109);
        this.type = type;
        this.icon = Objects.equals(this.type, "Potion") ? new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.f_42589_), type) : new ExtraCauldronIcon(() -> new ItemStack((ItemLike)Items.f_42447_));
        this.liquid = helper.createDrawable(TEXTURE, 208, 12, 16, 32);
        this.cauldron = helper.createDrawable(TEXTURE, 238, 50, 12, 10);
        this.output1 = helper.createDrawable(TEXTURE, 209, 64, 47, 82);
        this.output2 = helper.createDrawable(TEXTURE, 209, 146, 47, 82);
        this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
    }

    public static Block getTagStack(TagKey<Block> key) {
        if (ForgeRegistries.BLOCKS.tags() != null) {
            Optional optional = ForgeRegistries.BLOCKS.tags().getTag(key).getRandomElement(RandomSource.m_216327_());
            return optional.orElse(Blocks.f_50016_);
        }
        return Blocks.f_50016_;
    }

    public RecipeType<FluidMixingRecipe> getRecipeType() {
        return new RecipeType(new ResourceLocation("hexerei", this.type.toLowerCase(Locale.ROOT) + "_mixing"), FluidMixingRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)("gui.jei.category." + (this.type + "_mixing").toLowerCase(Locale.ROOT)));
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidMixingRecipe recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        builder.setShapeless();
        FluidStack input = recipe.getLiquid();
        FluidStack output = recipe.getLiquidOutput();
        input.setAmount(2000);
        output.setAmount(2000);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 152, 51).setFluidRenderer(2000L, true, 12, 10).setBackground(this.cauldron, 0, 0).setOverlay(this.cauldron, 0, 0).addFluidStack(recipe.getLiquidOutput().getFluid(), 2000L, recipe.getLiquidOutput().hasTag() ? recipe.getLiquidOutput().getTag() : new CompoundTag());
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 57).setFluidRenderer(2000L, false, 16, 32).setBackground(this.liquid, 0, 0).setOverlay(this.liquid, 0, 0).addFluidStack(recipe.getLiquid().getFluid(), 2000L, recipe.getLiquid().hasTag() ? recipe.getLiquid().getTag() : new CompoundTag());
        int size = recipe.m_7527_().size();
        if (size > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 18).addIngredients((Ingredient)recipe.m_7527_().get(0));
        }
        if (size > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 105, 27).addIngredients((Ingredient)recipe.m_7527_().get(1));
        }
        if (size > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 114, 49).addIngredients((Ingredient)recipe.m_7527_().get(2));
        }
        if (size > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 105, 71).addIngredients((Ingredient)recipe.m_7527_().get(3));
        }
        if (size > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 83, 80).addIngredients((Ingredient)recipe.m_7527_().get(4));
        }
        if (size > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 71).addIngredients((Ingredient)recipe.m_7527_().get(5));
        }
        if (size > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 52, 49).addIngredients((Ingredient)recipe.m_7527_().get(6));
        }
        if (size > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 61, 27).addIngredients((Ingredient)recipe.m_7527_().get(7));
        }
    }

    public void draw(FluidMixingRecipe recipe, IRecipeSlotsView view, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (recipe.getHeatCondition() == FluidMixingRecipe.HeatCondition.HEATED || recipe.getHeatCondition() == FluidMixingRecipe.HeatCondition.SUPERHEATED) {
            boolean showOutput;
            FluidStack input = recipe.getLiquid();
            FluidStack output = recipe.getLiquidOutput();
            input.setAmount(2000);
            output.setAmount(2000);
            float newHeatSource = Hexerei.getClientTicks() % 200.0f / 200.0f;
            float craftPercent = Hexerei.getClientTicks() % 100.0f / 100.0f;
            boolean bl = showOutput = Hexerei.getClientTicks() % 200.0f > 100.0f;
            if (newHeatSource <= 0.05f && this.findNewHeatSource || this.heatSource == null) {
                this.findNewHeatSource = false;
                if (Minecraft.m_91087_().f_91073_ != null) {
                    this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
                }
            }
            if (newHeatSource > 0.05f) {
                this.findNewHeatSource = true;
            }
            boolean flag = recipe.getLiquid().hasTag() || recipe.getLiquidOutput().hasTag();
            CompoundTag tag = recipe.getLiquid().hasTag() ? recipe.getLiquid().getOrCreateTag() : new CompoundTag();
            CompoundTag tag2 = recipe.getLiquidOutput().hasTag() ? recipe.getLiquidOutput().getOrCreateTag() : new CompoundTag();
            boolean compare = NbtUtils.m_129235_((Tag)tag2, (Tag)tag, (boolean)true);
            Minecraft minecraft = Minecraft.m_91087_();
            Component outputName = recipe.getLiquidOutput().getDisplayName();
            int width = minecraft.f_91062_.m_92852_((FormattedText)outputName);
            Objects.requireNonNull(minecraft.f_91062_);
            float lineHeight = 9.0f / 2.0f;
            if (width > 131) {
                float percent = (float)width / 131.0f;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
                minecraft.f_91062_.m_272077_(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.m_280168_().m_85849_();
            } else {
                minecraft.f_91062_.m_272077_(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_49966_().m_61124_((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(75.0f, 67.0f, 100.0f);
            guiGraphics.m_280168_().m_252880_(8.0f, -8.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(16.0f, 16.0f, 16.0f);
            guiGraphics.m_280168_().m_252931_(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.5, 0.0, 0.5);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 30.0f;
            guiGraphics.m_280168_().m_85837_(rotationOffset.f_82479_, rotationOffset.f_82480_, rotationOffset.f_82481_);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(zRot));
            guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(xRot));
            guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(yRot));
            guiGraphics.m_280168_().m_85837_(-rotationOffset.f_82479_, -rotationOffset.f_82480_, -rotationOffset.f_82481_);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            Lighting.m_84931_();
            guiGraphics.m_280168_().m_85850_().m_252943_().rotate((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
            this.renderBlock(guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, blockState, -1);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, -1.0f, 0.0f);
            BlockState state = this.heatSource.m_49966_();
            Block block = state.m_60734_();
            if (block instanceof LiquidBlock) {
                LiquidBlock liquidBlock = (LiquidBlock)block;
                state = (BlockState)liquidBlock.m_5888_(liquidBlock.m_49966_()).m_76188_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(7));
                MixingCauldronRenderer.renderFluidBlockGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, new FluidStack((Fluid)liquidBlock.getFluid(), 2000), 1.0f, OverlayTexture.f_118083_);
            }
            this.renderBlock(guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, state, -1);
            guiGraphics.m_280168_().m_85849_();
            float fillPercentage = 1.0f;
            if (!showOutput) {
                if (input.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.f_118083_);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.f_118083_);
                }
                float height = 0.25f + 0.6875f * fillPercentage;
                for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                    ItemStack[] items = ((Ingredient)recipe.m_7527_().get(i)).m_43908_();
                    if (items.length <= 0 || items[(int)Hexerei.getClientTicksWithoutPartial() / 40 % items.length].m_41619_()) continue;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_85837_(0.5, (double)(height + 0.00390625f), 0.5);
                    double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                    guiGraphics.m_280168_().m_85837_(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)Hexerei.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                    guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((Hexerei.getClientTicks() + (float)(i * 20)) / 40.0f))));
                    guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_((float)(82.5 + 5.0 * Math.cos((Hexerei.getClientTicks() + (float)(i * 22)) / 40.0f))));
                    guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(-2.5 + 5.0 * Math.cos((Hexerei.getClientTicks() + (float)(i * 24)) / 40.0f))));
                    guiGraphics.m_280168_().m_85841_(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                    guiGraphics.m_280168_().m_85841_(0.4f, 0.4f, 0.4f);
                    this.renderItem(items[(int)Hexerei.getClientTicksWithoutPartial() / 40 % items.length], (Level)minecraft.f_91073_, guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.m_280168_().m_85849_();
                }
            } else if (input.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, output, fillPercentage, 1.0f, OverlayTexture.f_118083_);
            } else {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, output, 1.0f, fillPercentage, OverlayTexture.f_118083_);
            }
            guiGraphics.m_280168_().m_85849_();
            Lighting.m_84931_();
            buffer.m_109911_();
            RenderSystem.enableDepthTest();
            if (!output.isEmpty() && (!recipe.getLiquid().getFluid().m_6212_(recipe.getLiquidOutput().getFluid()) || flag && recipe.getLiquid().getFluid().m_6212_(recipe.getLiquidOutput().getFluid()) && !compare)) {
                this.output2.draw(guiGraphics, 138, 16);
                guiGraphics.m_280168_().m_85841_(0.6f, 0.6f, 0.6f);
                minecraft.f_91062_.m_272077_((Component)Component.m_237115_((String)"gui.jei.category.mixing_cauldron.convert_fluid"), 231.574f, 63.308f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            } else {
                this.output1.draw(guiGraphics, 138, 16);
            }
        } else {
            boolean flatLighting;
            boolean showOutput;
            FluidStack input = recipe.getLiquid();
            FluidStack output = recipe.getLiquidOutput();
            input.setAmount(2000);
            output.setAmount(2000);
            float newHeatSource = Hexerei.getClientTicks() % 200.0f / 200.0f;
            float craftPercent = Hexerei.getClientTicks() % 100.0f / 100.0f;
            boolean bl = showOutput = Hexerei.getClientTicks() % 200.0f > 100.0f;
            if (newHeatSource <= 0.05f && this.findNewHeatSource || this.heatSource == null) {
                this.findNewHeatSource = false;
                if (Minecraft.m_91087_().f_91073_ != null) {
                    this.heatSource = FluidMixingRecipeCategory.getTagStack(HexereiTags.Blocks.HEAT_SOURCES);
                }
            }
            if (newHeatSource > 0.05f) {
                this.findNewHeatSource = true;
            }
            boolean flag = recipe.getLiquid().hasTag() || recipe.getLiquidOutput().hasTag();
            CompoundTag tag = recipe.getLiquid().hasTag() ? recipe.getLiquid().getOrCreateTag() : new CompoundTag();
            CompoundTag tag2 = recipe.getLiquidOutput().hasTag() ? recipe.getLiquidOutput().getOrCreateTag() : new CompoundTag();
            boolean compare = NbtUtils.m_129235_((Tag)tag2, (Tag)tag, (boolean)true);
            Minecraft minecraft = Minecraft.m_91087_();
            Component outputName = recipe.getLiquidOutput().getDisplayName();
            int width = minecraft.f_91062_.m_92852_((FormattedText)outputName);
            Objects.requireNonNull(minecraft.f_91062_);
            float lineHeight = 9.0f / 2.0f;
            if (width > 131) {
                float percent = (float)width / 131.0f;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
                minecraft.f_91062_.m_272077_(outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                guiGraphics.m_280168_().m_85849_();
            } else {
                minecraft.f_91062_.m_272077_(outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            BlockState blockState = (BlockState)((MixingCauldron)ModBlocks.MIXING_CAULDRON.get()).m_49966_().m_61124_((Property)MixingCauldron.GUI_RENDER, (Comparable)Boolean.valueOf(true));
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BlockRenderDispatcher rendererer = Minecraft.m_91087_().m_91289_();
            rendererer.m_110910_(blockState);
            BakedModel bakedModel = rendererer.m_110910_(blockState);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(70.0f, 73.0f, 100.0f);
            guiGraphics.m_280168_().m_252880_(8.0f, -8.0f, 0.0f);
            guiGraphics.m_280168_().m_85841_(20.0f, 20.0f, 20.0f);
            guiGraphics.m_280168_().m_252931_(new Matrix4f().scale(1.0f, -1.0f, 1.0f));
            Vec3 rotationOffset = new Vec3(0.0, 0.0, 0.0);
            float zRot = 0.0f;
            float xRot = 20.0f;
            float yRot = 30.0f;
            guiGraphics.m_280168_().m_85837_(rotationOffset.f_82479_, rotationOffset.f_82480_, rotationOffset.f_82481_);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(zRot));
            guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(xRot));
            guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(yRot));
            guiGraphics.m_280168_().m_85837_(-rotationOffset.f_82479_, -rotationOffset.f_82480_, -rotationOffset.f_82481_);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl2 = flatLighting = !bakedModel.m_7547_();
            if (flatLighting) {
                Lighting.m_84930_();
            }
            this.renderBlock(guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0, blockState, -12566464);
            float fillPercentage = 1.0f;
            if (!showOutput) {
                if (input.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, input, fillPercentage, 1.0f, OverlayTexture.f_118083_);
                } else {
                    MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, input, 1.0f, fillPercentage, OverlayTexture.f_118083_);
                }
                float height = 0.25f + 0.6875f * fillPercentage;
                for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                    ItemStack[] items = ((Ingredient)recipe.m_7527_().get(i)).m_43908_();
                    if (items.length <= 0 || items[(int)Hexerei.getClientTicksWithoutPartial() / 40 % items.length].m_41619_()) continue;
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_85837_(0.5, (double)(height + 0.00390625f), 0.5);
                    double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
                    guiGraphics.m_280168_().m_85837_(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), Math.sin(Math.PI * (double)Hexerei.getClientTicks() / 30.0 + (double)(i * 20)) / 10.0 * 0.2, 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                    guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((Hexerei.getClientTicks() + (float)(i * 20)) / 40.0f))));
                    guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_((float)(82.5 + 5.0 * Math.cos((Hexerei.getClientTicks() + (float)(i * 22)) / 40.0f))));
                    guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_((float)(-2.5 + 5.0 * Math.cos((Hexerei.getClientTicks() + (float)(i * 24)) / 40.0f))));
                    guiGraphics.m_280168_().m_85841_(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
                    guiGraphics.m_280168_().m_85841_(0.4f, 0.4f, 0.4f);
                    this.renderItem(items[(int)Hexerei.getClientTicksWithoutPartial() / 40 % items.length], (Level)minecraft.f_91073_, guiGraphics.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
                    guiGraphics.m_280168_().m_85849_();
                }
            } else if (input.getFluid().m_205067_(Tags.Fluids.GASEOUS)) {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, output, fillPercentage, 1.0f, OverlayTexture.f_118083_);
            } else {
                MixingCauldronRenderer.renderFluidGUI(guiGraphics.m_280168_(), (MultiBufferSource)buffer, output, 1.0f, fillPercentage, OverlayTexture.f_118083_);
            }
            buffer.m_109911_();
            RenderSystem.enableDepthTest();
            if (flatLighting) {
                Lighting.m_84931_();
            }
            guiGraphics.m_280168_().m_85849_();
            if (!output.isEmpty() && (!recipe.getLiquid().getFluid().m_6212_(recipe.getLiquidOutput().getFluid()) || flag && recipe.getLiquid().getFluid().m_6212_(recipe.getLiquidOutput().getFluid()) && !compare)) {
                this.output2.draw(guiGraphics, 138, 16);
                guiGraphics.m_280168_().m_85841_(0.6f, 0.6f, 0.6f);
                minecraft.f_91062_.m_272077_((Component)Component.m_237115_((String)"gui.jei.category.mixing_cauldron.convert_fluid"), 231.574f, 63.308f, -12566464, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            } else {
                this.output1.draw(guiGraphics, 138, 16);
            }
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    poseStack.m_85837_(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

