/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.client.renderer.ModRenderTypes;
import net.joefoxe.hexerei.data.recipes.MoonPhases;
import net.joefoxe.hexerei.tileentity.CrystalBallTile;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class CrystalBallRenderer
implements BlockEntityRenderer<CrystalBallTile> {
    public void render(CrystalBallTile tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tileEntityIn.m_58904_().m_8055_(tileEntityIn.m_58899_()).m_155947_() || !(tileEntityIn.m_58904_().m_7702_(tileEntityIn.m_58899_()) instanceof CrystalBallTile)) {
            return;
        }
        int xOffset = 0;
        int yOffset = 0;
        switch (MoonPhases.MoonCondition.getMoonPhase(tileEntityIn.m_58904_())) {
            case NONE: {
                xOffset = 12;
                yOffset = 76;
                break;
            }
            case NEW_MOON: {
                xOffset = 12;
                yOffset = 44;
                break;
            }
            case WAXING_CRESCENT: {
                xOffset = 44;
                yOffset = 44;
                break;
            }
            case FIRST_QUARTER: {
                xOffset = 76;
                yOffset = 44;
                break;
            }
            case WAXING_GIBBOUS: {
                xOffset = 108;
                yOffset = 44;
                break;
            }
            case FULL_MOON: {
                xOffset = 12;
                yOffset = 12;
                break;
            }
            case WANING_GIBBOUS: {
                xOffset = 44;
                yOffset = 12;
                break;
            }
            case LAST_QUARTER: {
                xOffset = 76;
                yOffset = 12;
                break;
            }
            case WANING_CRESCENT: {
                xOffset = 108;
                yOffset = 12;
            }
        }
        DyeColor col = HexereiUtil.getDyeColorNamed("jeb_", 0);
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        if (col != null) {
            float f3 = Hexerei.getClientTicks() / 10.0f * 4.0f % 16.0f / 16.0f;
            DyeColor col2 = HexereiUtil.getDyeColorNamed("jeb_", 1);
            float[] afloat1 = Sheep.m_29829_((DyeColor)col);
            float[] afloat2 = Sheep.m_29829_((DyeColor)col2);
            f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
            f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
            f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
        }
        this.renderQuad(tileEntityIn, matrixStackIn, xOffset, yOffset, bufferIn.m_6299_(ModRenderTypes.MOON_PHASE), partialTicks);
        if (bufferIn instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)bufferIn;
            bufferSource.m_109911_();
        }
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 0.5625f, 0.5f);
        matrixStackIn.m_252880_(0.0f, tileEntityIn.orbOffset / 16.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Mth.m_14189_((float)partialTicks, (float)tileEntityIn.degreesSpunOld, (float)tileEntityIn.degreesSpun) * 4.0f));
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ((Block)ModBlocks.CRYSTAL_BALL_ORB.get()).m_49966_(), null, 0xFFFFFF);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 0.4375f, 0.5f);
        matrixStackIn.m_252880_(0.0f, tileEntityIn.largeRingOffset / 16.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTicks, (float)tileEntityIn.degreesSpunOld, (float)tileEntityIn.degreesSpun) * 6.0f));
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.CRYSTAL_BALL_LARGE_RING.get()).m_49966_());
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252880_(0.5f, 0.28125f, 0.5f);
        matrixStackIn.m_252880_(0.0f, tileEntityIn.smallRingOffset / 16.0f, 0.0f);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Mth.m_14189_((float)partialTicks, (float)tileEntityIn.degreesSpunOld, (float)tileEntityIn.degreesSpun) * 6.0f));
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.CRYSTAL_BALL_SMALL_RING.get()).m_49966_());
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.CRYSTAL_BALL_STAND.get()).m_49966_());
        matrixStackIn.m_85849_();
    }

    public void renderQuad(CrystalBallTile tileEntityIn, PoseStack poseStack, int xOffset, int yOffset, VertexConsumer consumer, float partialTicks) {
        Vector3f[] bottomVertices = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
        Vector3f[] topVertices = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f)};
        CrystalBallRenderer.applyWobble(bottomVertices, 0.0f);
        CrystalBallRenderer.applyWobble(topVertices, 0.5f);
        ArrayList<Vector3f[]> offsetMap = new ArrayList<Vector3f[]>();
        for (int i = 0; i < 4; ++i) {
            offsetMap.add(new Vector3f[]{bottomVertices[(i + 1) % 4], bottomVertices[i], topVertices[i % 4], topVertices[(i + 1) % 4]});
        }
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5625f, 0.5f);
        poseStack.m_252880_(0.0f, tileEntityIn.orbOffset / 16.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-Mth.m_14189_((float)partialTicks, (float)tileEntityIn.degreesSpunOld, (float)tileEntityIn.degreesSpun) * 4.0f));
        poseStack.m_85841_(0.25f, 0.25f, 0.25f);
        CrystalBallRenderer.drawWobblyCube(poseStack, 1.0f, 0.86f * tileEntityIn.moonAlpha, offsetMap, bottomVertices, topVertices, consumer, xOffset, yOffset);
        CrystalBallRenderer.drawWobblyCube(poseStack, 0.85f, 0.5f * tileEntityIn.moonAlpha, offsetMap, bottomVertices, topVertices, consumer, xOffset, yOffset);
        CrystalBallRenderer.drawWobblyCube(poseStack, 1.12f, 0.6f * tileEntityIn.moonAlpha, offsetMap, bottomVertices, topVertices, consumer, xOffset, yOffset);
        poseStack.m_85849_();
    }

    public static void drawWobblyCube(PoseStack poseStack, float scale, float alpha, Collection<Vector3f[]> offsetMap, Vector3f[] bottomVertices, Vector3f[] topVertices, VertexConsumer consumer, int xOffset, int yOffset) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, scale);
        for (Vector3f[] offsets : offsetMap) {
            CrystalBallRenderer.drawSide(poseStack, alpha, offsets, consumer, xOffset, yOffset);
        }
        CrystalBallRenderer.drawSide(poseStack, alpha, new Vector3f[]{bottomVertices[3], bottomVertices[2], bottomVertices[1], bottomVertices[0]}, consumer, xOffset, yOffset);
        CrystalBallRenderer.drawSide(poseStack, alpha, topVertices, consumer, xOffset, yOffset);
        poseStack.m_85849_();
    }

    public static void drawSide(PoseStack poseStack, float alpha, Vector3f[] offsets, VertexConsumer consumer, int xOffset, int yOffset) {
        poseStack.m_85836_();
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        float f = 1.0f;
        float f1 = 1.0f;
        float f2 = 1.0f;
        consumer.m_252986_(matrix, offsets[0].x(), offsets[0].y(), offsets[0].z()).m_85950_(f, f1, f2, alpha).m_7421_((float)xOffset / 256.0f, (float)(yOffset + 8) / 256.0f).m_85969_(0xF000F0).m_5752_();
        consumer.m_252986_(matrix, offsets[1].x(), offsets[1].y(), offsets[1].z()).m_85950_(f, f1, f2, alpha).m_7421_((float)(xOffset + 8) / 256.0f, (float)(yOffset + 8) / 256.0f).m_85969_(0xF000F0).m_5752_();
        consumer.m_252986_(matrix, offsets[2].x(), offsets[2].y(), offsets[2].z()).m_85950_(f, f1, f2, alpha).m_7421_((float)(xOffset + 8) / 256.0f, (float)yOffset / 256.0f).m_85969_(0xF000F0).m_5752_();
        consumer.m_252986_(matrix, offsets[3].x(), offsets[3].y(), offsets[3].z()).m_85950_(f, f1, f2, alpha).m_7421_((float)xOffset / 256.0f, (float)yOffset / 256.0f).m_85969_(0xF000F0).m_5752_();
        poseStack.m_85849_();
    }

    public static void applyWobble(Vector3f[] offsets, float initialOffset) {
        CrystalBallRenderer.applyWobble(offsets, initialOffset, 0.025f);
    }

    public static void applyWobble(Vector3f[] offsets, float initialOffset, float strength) {
        float value = initialOffset;
        for (Vector3f vector3f : offsets) {
            float sine = Mth.m_14031_((float)((float)((double)((float)Minecraft.m_91087_().f_91073_.m_46467_() / 10.0f) + (double)value * Math.PI * 2.0))) * strength;
            vector3f.add(sine, -sine, sine);
            value += 0.25f;
        }
    }

    private void renderItem(ItemStack stack, Level level, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, null);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, float red, float green, float blue) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, red, green, blue);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BlockState state, RenderType renderType, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, ModelData.EMPTY, renderType, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, RenderType renderType, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.m_216335_((long)42L), modelData)) {
                        dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(renderType != null ? renderType : RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, rt);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((ItemStack)stack).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, float red, float green, float blue) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    for (RenderType rt : bakedmodel.getRenderTypes(p_110913_, RandomSource.m_216335_((long)42L), modelData)) {
                        dispatcher.m_110937_().renderModel(p_110914_.m_85850_(), p_110915_.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)rt, (boolean)false)), p_110913_, bakedmodel, red, green, blue, p_110916_, p_110917_, modelData, null);
                    }
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlockC(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, float red, float green, float blue) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, 0.0f, 0.0f, 0.0f, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    poseStack.m_85837_(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemDisplayContext.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

